/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.persistence.db;

import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.jbpm.JbpmConfiguration;
import org.jbpm.db.hibernate.HibernateHelper;
import org.jbpm.persistence.db.DbPersistenceService;
import org.jbpm.svc.Service;
import org.jbpm.svc.ServiceFactory;
import org.jbpm.util.JndiUtil;

public class DbPersistenceServiceFactory
implements ServiceFactory {
    private static final long serialVersionUID = 1L;
    Configuration configuration = null;
    String sessionFactoryJndiName = null;
    SessionFactory sessionFactory = null;
    String dataSourceJndiName = null;
    DataSource dataSource = null;
    boolean isTransactionEnabled = true;
    SchemaExport schemaExport = null;
    private static Log log = LogFactory.getLog((Class)DbPersistenceServiceFactory.class);

    public Service openService() {
        log.debug((Object)"creating persistence service");
        return new DbPersistenceService(this);
    }

    public synchronized Configuration getConfiguration() {
        if (this.configuration == null) {
            String hibernateCfgXmlResource = null;
            if (JbpmConfiguration.Configs.hasObject("resource.hibernate.cfg.xml")) {
                hibernateCfgXmlResource = JbpmConfiguration.Configs.getString("resource.hibernate.cfg.xml");
            }
            String hibernatePropertiesResource = null;
            if (JbpmConfiguration.Configs.hasObject("resource.hibernate.properties")) {
                hibernatePropertiesResource = JbpmConfiguration.Configs.getString("resource.hibernate.properties");
            }
            this.configuration = HibernateHelper.createConfiguration(hibernateCfgXmlResource, hibernatePropertiesResource);
            String hibernateQueriesResource = JbpmConfiguration.Configs.getString("resource.hibernate.queries.hbm.xml");
            this.configuration.addResource(hibernateQueriesResource);
        }
        return this.configuration;
    }

    public synchronized SchemaExport getSchemaExport() {
        if (this.schemaExport == null) {
            log.debug((Object)"creating schema export");
            this.schemaExport = new SchemaExport(this.getConfiguration());
        }
        return this.schemaExport;
    }

    public synchronized SessionFactory getSessionFactory() {
        if (this.sessionFactory == null) {
            if (this.sessionFactoryJndiName != null) {
                log.debug((Object)("looking up hibernate session factory in jndi '" + this.sessionFactoryJndiName + "'"));
                this.sessionFactory = (SessionFactory)JndiUtil.lookup(this.sessionFactoryJndiName, SessionFactory.class);
            } else {
                log.debug((Object)"building hibernate session factory");
                this.sessionFactory = this.getConfiguration().buildSessionFactory();
            }
        }
        return this.sessionFactory;
    }

    public DataSource getDataSource() {
        if (this.dataSource == null && this.dataSourceJndiName != null) {
            log.debug((Object)("looking up datasource from jndi location '" + this.dataSourceJndiName + "'"));
            this.dataSource = (DataSource)JndiUtil.lookup(this.dataSourceJndiName, DataSource.class);
        }
        return this.dataSource;
    }

    public void createSchema() {
        this.getSchemaExport().create(this.getScript(), true);
        HibernateHelper.clearHibernateCache(this.getSessionFactory());
    }

    public void dropSchema() {
        HibernateHelper.clearHibernateCache(this.getSessionFactory());
        this.getSchemaExport().drop(this.getScript(), true);
    }

    boolean getScript() {
        boolean script = false;
        String showSql = this.getConfiguration().getProperty("hibernate.show_sql");
        if ("true".equalsIgnoreCase(showSql)) {
            script = true;
        }
        return script;
    }

    public String getDataSourceJndiName() {
        return this.dataSourceJndiName;
    }

    public void setDataSourceJndiName(String dataSourceJndiName) {
        this.dataSourceJndiName = dataSourceJndiName;
    }

    public String getSessionFactoryJndiName() {
        return this.sessionFactoryJndiName;
    }

    public void setSessionFactoryJndiName(String sessionFactoryJndiName) {
        this.sessionFactoryJndiName = sessionFactoryJndiName;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setSchemaExport(SchemaExport schemaExport) {
        this.schemaExport = schemaExport;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public boolean isTransactionEnabled() {
        return this.isTransactionEnabled;
    }

    public void setTransactionEnabled(boolean isTransactionEnabled) {
        this.isTransactionEnabled = isTransactionEnabled;
    }
}

