/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.persistence.db;

import java.sql.Connection;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.jbpm.JbpmException;
import org.jbpm.db.ContextSession;
import org.jbpm.db.GraphSession;
import org.jbpm.db.LoggingSession;
import org.jbpm.db.MessagingSession;
import org.jbpm.db.SchedulerSession;
import org.jbpm.db.TaskMgmtSession;
import org.jbpm.persistence.JbpmPersistenceException;
import org.jbpm.persistence.PersistenceService;
import org.jbpm.persistence.db.DbPersistenceServiceFactory;
import org.jbpm.svc.Service;

public class DbPersistenceService
implements Service,
PersistenceService {
    private static final long serialVersionUID = 1L;
    DbPersistenceServiceFactory persistenceServiceFactory = null;
    Connection connection = null;
    boolean mustConnectionBeClosed = false;
    Transaction transaction = null;
    boolean isTransactionEnabled = true;
    boolean isRollbackOnly = false;
    Session session;
    boolean mustSessionBeFlushed = false;
    boolean mustSessionBeClosed = false;
    GraphSession graphSession = null;
    TaskMgmtSession taskMgmtSession = null;
    SchedulerSession schedulerSession = null;
    MessagingSession messagingSession = null;
    ContextSession contextSession = null;
    LoggingSession loggingSession = null;
    private static Log log = LogFactory.getLog((Class)DbPersistenceService.class);

    public DbPersistenceService(DbPersistenceServiceFactory persistenceServiceFactory) {
        this.persistenceServiceFactory = persistenceServiceFactory;
        this.isTransactionEnabled = persistenceServiceFactory.isTransactionEnabled();
    }

    public SessionFactory getSessionFactory() {
        return this.persistenceServiceFactory.getSessionFactory();
    }

    public Session getSession() {
        if (this.session == null && this.getSessionFactory() != null) {
            Connection connection = this.getConnection();
            if (connection != null) {
                log.debug((Object)("creating hibernate session with connection " + connection));
                this.session = this.getSessionFactory().openSession(connection);
                this.mustSessionBeClosed = true;
                this.mustSessionBeFlushed = true;
                this.mustConnectionBeClosed = false;
            } else {
                log.debug((Object)"creating hibernate session");
                this.session = this.getSessionFactory().openSession();
                this.mustSessionBeClosed = true;
                this.mustSessionBeFlushed = true;
                this.mustConnectionBeClosed = false;
            }
            if (this.isTransactionEnabled) {
                log.debug((Object)"beginning hibernate transaction");
                this.transaction = this.session.beginTransaction();
            }
        }
        return this.session;
    }

    public Connection getConnection() {
        if (this.connection == null) {
            if (this.persistenceServiceFactory.getDataSource() != null) {
                try {
                    log.debug((Object)"fetching jdbc connection from datasource");
                    this.connection = this.persistenceServiceFactory.getDataSource().getConnection();
                    this.mustConnectionBeClosed = true;
                }
                catch (Throwable t) {
                    throw new RuntimeException("couldn't obtain connection from datasource", t);
                }
            } else if (this.session != null) {
                log.debug((Object)"fetching connection from hibernate session. this transfers responsibility for closing the jdbc connection to the user!");
                this.connection = this.session.connection();
                this.mustConnectionBeClosed = false;
            }
        }
        return this.connection;
    }

    public void close() {
        if (this.session != null && this.transaction == null && this.isRollbackOnly) {
            throw new JbpmException("User provided session was combined with setRollbackOnly.  With user provided hibernate sessions, the user is responsible for managing transactions");
        }
        if (this.isTransactionEnabled && this.transaction != null) {
            if (this.isRollbackOnly) {
                try {
                    log.debug((Object)"rolling back hibernate transaction");
                    this.mustSessionBeFlushed = false;
                    this.transaction.rollback();
                }
                catch (Throwable t) {
                    throw new JbpmPersistenceException("couldn't rollback hibernate session", t);
                }
            }
            try {
                log.debug((Object)"committing hibernate transaction");
                this.mustSessionBeFlushed = false;
                this.transaction.commit();
            }
            catch (Throwable t) {
                try {
                    this.transaction.rollback();
                }
                catch (Throwable t2) {
                    log.error((Object)"problem rolling back after failed commit", t2);
                }
                throw new JbpmPersistenceException("couldn't commit hibernate session", t);
            }
        }
        if (this.mustSessionBeFlushed) {
            try {
                log.debug((Object)"flushing hibernate session");
                this.session.flush();
            }
            catch (Throwable t) {
                throw new JbpmPersistenceException("couldn't flush hibernate session", t);
            }
        }
        if (this.mustSessionBeClosed) {
            try {
                log.debug((Object)"closing hibernate session");
                this.session.close();
            }
            catch (Throwable t) {
                throw new JbpmPersistenceException("couldn't close hibernate session", t);
            }
        }
        if (this.mustConnectionBeClosed) {
            try {
                log.debug((Object)"closing jdbc connection");
                this.connection.close();
            }
            catch (Throwable t) {
                throw new JbpmPersistenceException("couldn't close jdbc connection", t);
            }
        }
    }

    public void assignId(Object object) {
        try {
            this.getSession().save(object);
        }
        catch (Throwable t) {
            throw new JbpmPersistenceException("couldn't assign id to " + object, t);
        }
    }

    public GraphSession getGraphSession() {
        Session session;
        if (this.graphSession == null && (session = this.getSession()) != null) {
            this.graphSession = new GraphSession(session);
        }
        return this.graphSession;
    }

    public LoggingSession getLoggingSession() {
        Session session;
        if (this.loggingSession == null && (session = this.getSession()) != null) {
            this.loggingSession = new LoggingSession(session);
        }
        return this.loggingSession;
    }

    public MessagingSession getMessagingSession() {
        Session session;
        if (this.messagingSession == null && (session = this.getSession()) != null) {
            this.messagingSession = new MessagingSession(session);
        }
        return this.messagingSession;
    }

    public SchedulerSession getSchedulerSession() {
        Session session;
        if (this.schedulerSession == null && (session = this.getSession()) != null) {
            this.schedulerSession = new SchedulerSession(session);
        }
        return this.schedulerSession;
    }

    public ContextSession getContextSession() {
        Session session;
        if (this.contextSession == null && (session = this.getSession()) != null) {
            this.contextSession = new ContextSession(session);
        }
        return this.contextSession;
    }

    public TaskMgmtSession getTaskMgmtSession() {
        Session session;
        if (this.taskMgmtSession == null && (session = this.getSession()) != null) {
            this.taskMgmtSession = new TaskMgmtSession(session);
        }
        return this.taskMgmtSession;
    }

    public DataSource getDataSource() {
        return this.persistenceServiceFactory.dataSource;
    }

    public boolean isRollbackOnly() {
        return this.isRollbackOnly;
    }

    public void setRollbackOnly(boolean isRollbackOnly) {
        this.isRollbackOnly = isRollbackOnly;
    }

    public void setRollbackOnly() {
        this.isRollbackOnly = true;
    }

    public void setSession(Session session) {
        this.session = session;
        log.debug((Object)"injecting a session disables transaction");
        this.isTransactionEnabled = false;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public void setContextSession(ContextSession contextSession) {
        this.contextSession = contextSession;
    }

    public void setDataSource(DataSource dataSource) {
        this.persistenceServiceFactory.dataSource = dataSource;
    }

    public void setGraphSession(GraphSession graphSession) {
        this.graphSession = graphSession;
    }

    public void setLoggingSession(LoggingSession loggingSession) {
        this.loggingSession = loggingSession;
    }

    public void setMessagingSession(MessagingSession messagingSession) {
        this.messagingSession = messagingSession;
    }

    public void setSchedulerSession(SchedulerSession schedulerSession) {
        this.schedulerSession = schedulerSession;
    }

    public void setTaskMgmtSession(TaskMgmtSession taskMgmtSession) {
        this.taskMgmtSession = taskMgmtSession;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.persistenceServiceFactory.sessionFactory = sessionFactory;
    }

    public Transaction getTransaction() {
        return this.transaction;
    }

    public void setTransaction(Transaction transaction) {
        this.transaction = transaction;
    }

    public boolean isTransactionEnabled() {
        return this.isTransactionEnabled;
    }

    public void setTransactionEnabled(boolean isTransactionEnabled) {
        this.isTransactionEnabled = isTransactionEnabled;
    }
}

