/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.graph.node;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;
import org.jbpm.JbpmContext;
import org.jbpm.context.def.VariableAccess;
import org.jbpm.context.exe.ContextInstance;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.def.Transition;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;
import org.jbpm.jpdl.xml.JpdlXmlReader;
import org.jbpm.jpdl.xml.Parsable;

public class ProcessState
extends Node
implements Parsable {
    private static final long serialVersionUID = 1L;
    protected transient String subProcessName = null;
    protected transient String subProcessVersion = null;
    protected ProcessDefinition subProcessDefinition = null;
    protected Set variableAccesses = null;
    public static final String[] supportedEventTypes = new String[]{"subprocess-created", "subprocess-end", "node-enter", "node-leave", "before-signal", "after-signal"};
    private static Log log = LogFactory.getLog((Class)ProcessState.class);

    public String[] getSupportedEventTypes() {
        return supportedEventTypes;
    }

    public void read(Element processStateElement, JpdlXmlReader jpdlReader) {
        JbpmContext jbpmContext;
        Element subProcessElement = processStateElement.element("sub-process");
        if (subProcessElement != null) {
            this.subProcessName = subProcessElement.attributeValue("name");
            this.subProcessVersion = subProcessElement.attributeValue("version");
        }
        if ((jbpmContext = JbpmContext.getCurrentJbpmContext()) != null) {
            if (this.subProcessName != null) {
                if (this.subProcessVersion != null) {
                    try {
                        int version = Integer.parseInt(this.subProcessVersion);
                        this.subProcessDefinition = jbpmContext.getGraphSession().findProcessDefinition(this.subProcessName, version);
                    }
                    catch (NumberFormatException e) {
                        jpdlReader.addWarning("version in process-state was not a number: " + processStateElement.asXML());
                    }
                } else {
                    this.subProcessDefinition = jbpmContext.getGraphSession().findLatestProcessDefinition(this.subProcessName);
                }
            } else {
                jpdlReader.addWarning("no sub-process name specfied in process-state " + processStateElement.asXML());
            }
        }
        if (this.subProcessName != null && this.subProcessDefinition == null && this.subProcessVersion == null && this.subProcessName.equals(this.processDefinition.getName())) {
            this.subProcessDefinition = this.processDefinition;
        }
        if (this.subProcessDefinition != null) {
            log.debug((Object)("subprocess for process-state '" + this.name + "' bound to " + this.subProcessDefinition));
        } else {
            log.debug((Object)("subprocess for process-state '" + this.name + "' not yet bound"));
        }
        this.variableAccesses = new HashSet(jpdlReader.readVariableAccesses(processStateElement));
    }

    public void execute(ExecutionContext executionContext) {
        Token superProcessToken = executionContext.getToken();
        ProcessInstance subProcessInstance = superProcessToken.createSubProcessInstance(this.subProcessDefinition);
        this.fireEvent("subprocess-created", executionContext);
        if (this.variableAccesses != null && !this.variableAccesses.isEmpty()) {
            ContextInstance superContextInstance = executionContext.getContextInstance();
            ContextInstance subContextInstance = subProcessInstance.getContextInstance();
            Iterator iter = this.variableAccesses.iterator();
            while (iter.hasNext()) {
                VariableAccess variableAccess = (VariableAccess)iter.next();
                if (!variableAccess.isReadable()) continue;
                String variableName = variableAccess.getVariableName();
                Object value = superContextInstance.getVariable(variableName, superProcessToken);
                String mappedName = variableAccess.getMappedName();
                log.debug((Object)("copying super process var '" + variableName + "' to sub process var '" + mappedName + "': " + value));
                if (value == null) continue;
                subContextInstance.setVariable(mappedName, value);
            }
        }
        subProcessInstance.signal();
    }

    public void leave(ExecutionContext executionContext, Transition transition) {
        ProcessInstance subProcessInstance = executionContext.getSubProcessInstance();
        Token superProcessToken = subProcessInstance.getSuperProcessToken();
        if (this.variableAccesses != null && !this.variableAccesses.isEmpty()) {
            ContextInstance superContextInstance = executionContext.getContextInstance();
            ContextInstance subContextInstance = subProcessInstance.getContextInstance();
            Iterator iter = this.variableAccesses.iterator();
            while (iter.hasNext()) {
                VariableAccess variableAccess = (VariableAccess)iter.next();
                if (!variableAccess.isWritable()) continue;
                String mappedName = variableAccess.getMappedName();
                Object value = subContextInstance.getVariable(mappedName);
                String variableName = variableAccess.getVariableName();
                log.debug((Object)("copying sub process var '" + mappedName + "' to super process var '" + variableName + "': " + value));
                if (value == null) continue;
                superContextInstance.setVariable(variableName, value, superProcessToken);
            }
        }
        this.fireEvent("subprocess-end", executionContext);
        superProcessToken.setSubProcessInstance(null);
        super.leave(executionContext, this.getDefaultLeavingTransition());
    }

    public ProcessDefinition getSubProcessDefinition() {
        return this.subProcessDefinition;
    }

    public void setSubProcessDefinition(ProcessDefinition subProcessDefinition) {
        this.subProcessDefinition = subProcessDefinition;
    }
}

