/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.graph.def;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Element;
import org.jbpm.graph.def.GraphElement;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.NodeCollection;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.jpdl.xml.JpdlXmlReader;
import org.jbpm.jpdl.xml.Parsable;

public class SuperState
extends Node
implements Parsable,
NodeCollection {
    private static final long serialVersionUID = 1L;
    protected List nodes = null;
    transient Map nodesMap = null;
    public static final String[] supportedEventTypes = new String[]{"node-enter", "node-leave", "task-create", "task-assign", "task-start", "task-end", "transition", "before-signal", "after-signal", "superstate-enter", "superstate-leave", "subprocess-created", "subprocess-end", "timer"};

    public SuperState() {
    }

    public SuperState(String name) {
        super(name);
    }

    public String[] getSupportedEventTypes() {
        return supportedEventTypes;
    }

    public void read(Element element, JpdlXmlReader jpdlReader) {
        jpdlReader.readNodes(element, this);
    }

    public void execute(ExecutionContext executionContext) {
        if (this.nodes == null || this.nodes.size() == 0) {
            throw new RuntimeException("transition enters superstate +" + this + "' and it there is no first child-node to delegate to");
        }
        Node startNode = (Node)this.nodes.get(0);
        startNode.enter(executionContext);
    }

    public List getNodes() {
        return this.nodes;
    }

    public Map getNodesMap() {
        if (this.nodesMap == null && this.nodes != null) {
            this.nodesMap = new HashMap();
            Iterator iter = this.nodes.iterator();
            while (iter.hasNext()) {
                Node node = (Node)iter.next();
                this.nodesMap.put(node.getName(), node);
            }
        }
        return this.nodesMap;
    }

    public Node getNode(String name) {
        return (Node)this.getNodesMap().get(name);
    }

    public boolean hasNode(String name) {
        return this.getNodesMap().containsKey(name);
    }

    public Node addNode(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("can't add a null node to a superstate");
        }
        if (this.nodes == null) {
            this.nodes = new ArrayList();
        }
        this.nodes.add(node);
        node.superState = this;
        this.nodesMap = null;
        return node;
    }

    public Node removeNode(Node node) {
        Node removedNode = null;
        if (node == null) {
            throw new IllegalArgumentException("can't remove a null node from a superstate");
        }
        if (this.nodes != null && this.nodes.remove(node)) {
            removedNode = node;
            removedNode.superState = null;
            this.nodesMap = null;
        }
        return removedNode;
    }

    public void reorderNode(int oldIndex, int newIndex) {
        if (this.nodes == null || Math.min(oldIndex, newIndex) < 0 || Math.max(oldIndex, newIndex) >= this.nodes.size()) {
            throw new IndexOutOfBoundsException("couldn't reorder element from index '" + oldIndex + "' to index '" + newIndex + "' in nodeList '" + this.nodes + "'");
        }
        Object o = this.nodes.remove(oldIndex);
        this.nodes.add(newIndex, o);
    }

    public String generateNodeName() {
        return ProcessDefinition.generateNodeName(this.nodes);
    }

    public Node findNode(String hierarchicalName) {
        return ProcessDefinition.findNode(this, hierarchicalName);
    }

    public boolean containsNode(Node node) {
        boolean containsNode = false;
        SuperState parent = node.getSuperState();
        while (!containsNode && parent != null) {
            if (this.equals(parent)) {
                containsNode = true;
                continue;
            }
            parent = parent.getSuperState();
        }
        return containsNode;
    }

    public GraphElement getParent() {
        GraphElement parent = this.processDefinition;
        if (this.superState != null) {
            parent = this.superState;
        }
        return parent;
    }
}

