/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.db;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import org.hibernate.Query;
import org.hibernate.Session;
import org.jbpm.graph.exe.Token;
import org.jbpm.msg.Message;

public class MessagingSession
implements Serializable {
    private static final long serialVersionUID = 1L;
    Session session = null;
    Message nextMessage = null;

    public MessagingSession(Session session) {
        this.session = session;
    }

    public void save(Message message) {
        this.session.saveOrUpdate((Object)message);
    }

    public void delete(Message message) {
        this.session.delete((Object)message);
    }

    public boolean hasNextMessage(String destination) {
        Iterator messageIterator = this.getMessageIterator(destination);
        boolean hasMessages = messageIterator.hasNext();
        if (hasMessages) {
            this.nextMessage = (Message)messageIterator.next();
        }
        return hasMessages;
    }

    public Message nextMessage(String destination) {
        Message message = null;
        if (this.nextMessage != null) {
            message = this.nextMessage;
            this.nextMessage = null;
        } else {
            Iterator iter = this.getMessageIterator(destination);
            if (iter.hasNext()) {
                message = (Message)iter.next();
            }
            if (iter.hasNext()) {
                this.nextMessage = (Message)iter.next();
            }
        }
        return message;
    }

    public Message loadMessage(long id) {
        return (Message)this.session.get(Message.class, (Serializable)new Long(id));
    }

    public List findMessages(String destination) {
        List messages = null;
        Query query = this.session.getNamedQuery("MessagingSession.findMessages");
        query.setString("destination", destination);
        messages = query.list();
        return messages;
    }

    public List findErrorMessages(String destination) {
        List messages = null;
        Query query = this.session.getNamedQuery("MessagingSession.findErrorMessages");
        query.setString("destination", destination);
        messages = query.list();
        return messages;
    }

    public Iterator getMessageIterator(String destination) {
        if (destination == null) {
            throw new NullPointerException("destination is null");
        }
        Query query = this.session.getNamedQuery("MessagingSession.findMessages");
        query.setString("destination", destination);
        return query.iterate();
    }

    public void suspendMessages(Token token) {
        Query query = this.session.getNamedQuery("MessagingSession.suspendMessagesForToken");
        query.setEntity("token", (Object)token);
        query.executeUpdate();
    }

    public void resumeMessages(Token token) {
        Query query = this.session.getNamedQuery("MessagingSession.resumeMessagesForToken");
        query.setEntity("token", (Object)token);
        query.executeUpdate();
    }
}

