/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.calendar;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.jbpm.calendar.BusinessCalendar;

public class Holiday
implements Serializable {
    private static final long serialVersionUID = 1L;
    Date fromDay = null;
    Date toDay = null;
    BusinessCalendar businessCalendar = null;

    public static List parseHolidays(Properties calendarProperties, BusinessCalendar businessCalendar) {
        ArrayList<Holiday> holidays = new ArrayList<Holiday>();
        SimpleDateFormat dateFormat = new SimpleDateFormat(calendarProperties.getProperty("day.format"));
        Iterator<Object> iter = calendarProperties.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            if (!key.startsWith("holiday")) continue;
            Holiday holiday = new Holiday(calendarProperties.getProperty(key), dateFormat, businessCalendar);
            holidays.add(holiday);
        }
        return holidays;
    }

    public Holiday(String holidayText, DateFormat dateFormat, BusinessCalendar businessCalendar) {
        this.businessCalendar = businessCalendar;
        try {
            int separatorIndex = holidayText.indexOf(45);
            if (separatorIndex == -1) {
                this.toDay = this.fromDay = dateFormat.parse(holidayText.trim());
            } else {
                String fromText = holidayText.substring(0, separatorIndex).trim();
                String toText = holidayText.substring(separatorIndex + 1).trim();
                this.fromDay = dateFormat.parse(fromText);
                this.toDay = dateFormat.parse(toText);
            }
            Calendar calendar = BusinessCalendar.getCalendar();
            calendar.setTime(this.toDay);
            calendar.add(5, 1);
            this.toDay = calendar.getTime();
        }
        catch (ParseException e) {
            throw new RuntimeException("couldn't parse holiday '" + holidayText + "'", e);
        }
    }

    public boolean includes(Date date) {
        return this.fromDay.getTime() <= date.getTime() && date.getTime() < this.toDay.getTime();
    }
}

