/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.ant;

import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.hibernate.cfg.Configuration;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.jbpm.ant.AntHelper;
import org.jbpm.db.JbpmSchema;

public class JbpmSchemaTask
extends Task {
    String cfg = null;
    String properties = null;
    boolean quiet = false;
    boolean text = false;
    String output = null;
    String delimiter = null;
    String actions = null;

    public void execute() throws BuildException {
        if (this.actions == null) {
            throw new RuntimeException("actions is null in jbpmschema task");
        }
        Configuration configuration = AntHelper.getConfiguration(this.cfg, this.properties);
        JbpmSchema jbpmSchema = new JbpmSchema(configuration);
        SchemaExport schemaExport = new SchemaExport(configuration);
        if (this.output != null) {
            schemaExport.setOutputFile(this.output);
        }
        if (this.delimiter != null) {
            schemaExport.setDelimiter(this.delimiter);
        }
        StringTokenizer tokenizer = new StringTokenizer(this.actions, ",");
        while (tokenizer.hasMoreTokens()) {
            String action = tokenizer.nextToken();
            if ("drop".equalsIgnoreCase(action)) {
                schemaExport.drop(!this.quiet, !this.text);
                continue;
            }
            if ("create".equalsIgnoreCase(action)) {
                schemaExport.create(!this.quiet, !this.text);
                continue;
            }
            if (!"clean".equalsIgnoreCase(action)) continue;
            jbpmSchema.cleanSchema();
        }
    }

    public void setActions(String actions) {
        this.actions = actions;
    }

    public void setCfg(String cfg) {
        this.cfg = cfg;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public void setOutput(String output) {
        this.output = output;
    }

    public void setProperties(String properties) {
        this.properties = properties;
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    public void setText(boolean text) {
        this.text = text;
    }
}

