/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.tree.renderkit.html;

import java.io.IOException;
import java.util.Set;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UISelectMany;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import org.apache.myfaces.custom.tree.HtmlTreeCheckbox;
import org.apache.myfaces.renderkit.RendererUtils;
import org.apache.myfaces.renderkit.html.HtmlCheckboxRendererBase;

public class HtmlTreeCheckboxRenderer
extends HtmlCheckboxRendererBase {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Converter converter;
        HtmlTreeCheckbox checkbox = (HtmlTreeCheckbox)component;
        String forAttr = checkbox.getFor();
        if (forAttr == null) {
            throw new IllegalStateException("Mandatory attribute 'for'");
        }
        UIComponent uiComponent = checkbox.findComponent(forAttr);
        if (uiComponent == null) {
            throw new IllegalStateException("Could not find component '" + forAttr + "' (calling findComponent on component '" + checkbox.getClientId(context) + "')");
        }
        if (!(uiComponent instanceof UISelectMany)) {
            throw new IllegalStateException("UISelectMany expected");
        }
        UISelectMany uiSelectMany = (UISelectMany)uiComponent;
        try {
            converter = RendererUtils.findUISelectManyConverter(context, uiSelectMany);
        }
        catch (FacesException e) {
            converter = null;
        }
        Set lookupSet = RendererUtils.getSelectedValuesAsSet(context, component, converter, uiSelectMany);
        Object itemValue = checkbox.getItemValue();
        String itemStrValue = null;
        if (converter == null) {
            if (null != itemValue) {
                itemStrValue = itemValue.toString();
            }
        } else {
            itemStrValue = converter.getAsString(context, (UIComponent)uiSelectMany, itemValue);
        }
        this.renderCheckbox(context, (UIComponent)uiSelectMany, itemStrValue, checkbox.getItemLabel(), this.isDisabled(context, (UIComponent)uiSelectMany), lookupSet.contains(itemStrValue), true);
    }

    protected boolean isDisabled(FacesContext facesContext, UIComponent uiComponent) {
        return super.isDisabled(facesContext, uiComponent);
    }

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        if (!(uiComponent instanceof HtmlTreeCheckbox)) {
            super.decode(facesContext, uiComponent);
        }
    }
}

