/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.newspaper;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.component.html.HtmlDataTable;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.custom.newspaper.HtmlNewspaperTable;
import org.apache.myfaces.renderkit.RendererUtils;
import org.apache.myfaces.renderkit.html.HTML;
import org.apache.myfaces.renderkit.html.HtmlRendererUtils;
import org.apache.myfaces.renderkit.html.HtmlTableRendererBase;
import org.apache.myfaces.util.ArrayUtils;
import org.apache.myfaces.util.StringUtils;

public class HtmlNewspaperTableRenderer
extends HtmlTableRendererBase {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$myfaces$custom$newspaper$HtmlNewspaperTableRenderer == null ? (class$org$apache$myfaces$custom$newspaper$HtmlNewspaperTableRenderer = HtmlNewspaperTableRenderer.class$("org.apache.myfaces.custom.newspaper.HtmlNewspaperTableRenderer")) : class$org$apache$myfaces$custom$newspaper$HtmlNewspaperTableRenderer));
    static /* synthetic */ Class class$org$apache$myfaces$custom$newspaper$HtmlNewspaperTableRenderer;
    static /* synthetic */ Class class$javax$faces$component$UIData;

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        RendererUtils.checkParamValidity(facesContext, uiComponent, class$javax$faces$component$UIData == null ? (class$javax$faces$component$UIData = HtmlNewspaperTableRenderer.class$("javax.faces.component.UIData")) : class$javax$faces$component$UIData);
        ResponseWriter writer = facesContext.getResponseWriter();
        HtmlNewspaperTable newspaperTable = (HtmlNewspaperTable)uiComponent;
        HtmlRendererUtils.writePrettyLineSeparator(facesContext);
        writer.startElement("table", (UIComponent)newspaperTable);
        writer.writeAttribute("id", (Object)newspaperTable.getClientId(facesContext), null);
        HtmlRendererUtils.renderHTMLAttributes(writer, (UIComponent)newspaperTable, HTML.TABLE_PASSTHROUGH_ATTRIBUTES);
        this.renderFacet(facesContext, writer, newspaperTable, true);
    }

    public void encodeChildren(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        int newspaperColumns;
        int last;
        RendererUtils.checkParamValidity(facesContext, uiComponent, class$javax$faces$component$UIData == null ? (class$javax$faces$component$UIData = HtmlNewspaperTableRenderer.class$("javax.faces.component.UIData")) : class$javax$faces$component$UIData);
        ResponseWriter writer = facesContext.getResponseWriter();
        HtmlNewspaperTable newspaperTable = (HtmlNewspaperTable)uiComponent;
        HtmlRendererUtils.writePrettyLineSeparator(facesContext);
        writer.startElement("tbody", (UIComponent)newspaperTable);
        Styles styles = HtmlNewspaperTableRenderer.getStyles(newspaperTable);
        int first = newspaperTable.getFirst();
        int rows = newspaperTable.getRows();
        int rowCount = newspaperTable.getRowCount();
        if (rows <= 0) {
            rows = rowCount - first;
        }
        if ((last = first + rows) > rowCount) {
            last = rowCount;
        }
        int newspaperRows = (last - first) % (newspaperColumns = newspaperTable.getNewspaperColumns()) == 0 ? (last - first) / newspaperColumns : (last - first) / newspaperColumns + 1;
        for (int nr = 0; nr < newspaperRows; ++nr) {
            HtmlRendererUtils.writePrettyLineSeparator(facesContext);
            writer.startElement("tr", (UIComponent)newspaperTable);
            if (styles.hasRowStyle()) {
                String rowStyle = styles.getRowStyle(nr);
                writer.writeAttribute("class", (Object)rowStyle, null);
            }
            for (int nc = 0; nc < newspaperColumns; ++nc) {
                int currentRow = nc * newspaperRows + nr + first;
                if (currentRow >= last) continue;
                newspaperTable.setRowIndex(currentRow);
                if (!newspaperTable.isRowAvailable()) {
                    log.error((Object)("Row is not available. Rowindex = " + currentRow));
                    return;
                }
                List children = newspaperTable.getChildren();
                for (int j = 0; j < newspaperTable.getChildCount(); ++j) {
                    UIComponent child = (UIComponent)children.get(j);
                    if (!(child instanceof UIColumn) || !child.isRendered()) continue;
                    writer.startElement("td", (UIComponent)newspaperTable);
                    if (styles.hasColumnStyle()) {
                        writer.writeAttribute("class", (Object)styles.getColumnStyle(j), null);
                    }
                    RendererUtils.renderChild(facesContext, child);
                    writer.endElement("td");
                }
                if (nc >= newspaperColumns - 1) continue;
                this.renderSpacerCell(facesContext, writer, newspaperTable);
            }
            writer.endElement("tr");
        }
        writer.endElement("tbody");
    }

    private int getNewspaperColumns() {
        return 3;
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        RendererUtils.checkParamValidity(facesContext, uiComponent, class$javax$faces$component$UIData == null ? (class$javax$faces$component$UIData = HtmlNewspaperTableRenderer.class$("javax.faces.component.UIData")) : class$javax$faces$component$UIData);
        ResponseWriter writer = facesContext.getResponseWriter();
        HtmlNewspaperTable newspaperTable = (HtmlNewspaperTable)uiComponent;
        this.renderFacet(facesContext, writer, newspaperTable, false);
        writer.endElement("table");
        HtmlRendererUtils.writePrettyLineSeparator(facesContext);
    }

    private int countColumns(HtmlNewspaperTable newspaperTable) {
        int columnCount = 0;
        Iterator it = newspaperTable.getChildren().iterator();
        while (it.hasNext()) {
            UIComponent uiComponent = (UIComponent)it.next();
            if (!(uiComponent instanceof UIColumn) || !((UIColumn)uiComponent).isRendered()) continue;
            ++columnCount;
        }
        return columnCount;
    }

    private boolean hasFacet(HtmlNewspaperTable newspaperTable, boolean header) {
        Iterator it = newspaperTable.getChildren().iterator();
        while (it.hasNext()) {
            UIColumn column;
            UIComponent uiComponent = (UIComponent)it.next();
            if (!(uiComponent instanceof UIColumn) || !(column = (UIColumn)uiComponent).isRendered()) continue;
            if (header && ((UIColumn)uiComponent).getHeader() != null) {
                return true;
            }
            if (header || ((UIColumn)uiComponent).getFooter() == null) continue;
            return true;
        }
        return false;
    }

    private void renderFacet(FacesContext facesContext, ResponseWriter writer, HtmlNewspaperTable newspaperTable, boolean header) throws IOException {
        UIComponent facet;
        int columnCount = this.countColumns(newspaperTable);
        boolean hasColumnFacet = this.hasFacet(newspaperTable, header);
        UIComponent uIComponent = facet = header ? newspaperTable.getHeader() : newspaperTable.getFooter();
        if (facet == null && !hasColumnFacet) {
            return;
        }
        HtmlRendererUtils.writePrettyLineSeparator(facesContext);
        String elemName = header ? "thead" : "tfoot";
        writer.startElement(elemName, (UIComponent)newspaperTable);
        String styleClass = header ? HtmlNewspaperTableRenderer.getHeaderClass(newspaperTable) : HtmlNewspaperTableRenderer.getFooterClass(newspaperTable);
        if (header) {
            if (facet != null) {
                this.renderTableHeaderOrFooterRow(facesContext, writer, newspaperTable, facet, styleClass, "td", columnCount);
            }
            if (hasColumnFacet) {
                this.renderColumnHeaderOrFooterRow(facesContext, writer, newspaperTable, styleClass, header);
            }
        } else {
            if (hasColumnFacet) {
                this.renderColumnHeaderOrFooterRow(facesContext, writer, newspaperTable, styleClass, header);
            }
            if (facet != null) {
                this.renderTableHeaderOrFooterRow(facesContext, writer, newspaperTable, facet, styleClass, "td", columnCount);
            }
        }
        writer.endElement(elemName);
    }

    private void renderTableHeaderOrFooterRow(FacesContext facesContext, ResponseWriter writer, HtmlNewspaperTable newspaperTable, UIComponent facet, String styleClass, String colElementName, int tableColumns) throws IOException {
        HtmlRendererUtils.writePrettyLineSeparator(facesContext);
        writer.startElement("tr", (UIComponent)newspaperTable);
        writer.startElement(colElementName, (UIComponent)newspaperTable);
        if (styleClass != null) {
            writer.writeAttribute("class", (Object)styleClass, null);
        }
        if (colElementName.equals("th")) {
            writer.writeAttribute("scope", (Object)"colgroup", null);
        }
        int totalColumns = newspaperTable.getNewspaperColumns() * tableColumns;
        if (newspaperTable.getSpacer() != null) {
            totalColumns = totalColumns + this.getNewspaperColumns() - 1;
        }
        writer.writeAttribute("colspan", (Object)new Integer(totalColumns), null);
        if (facet != null) {
            RendererUtils.renderChild(facesContext, facet);
        }
        writer.endElement(colElementName);
        writer.endElement("tr");
    }

    private void renderColumnHeaderOrFooterRow(FacesContext facesContext, ResponseWriter writer, HtmlNewspaperTable newspaperTable, String styleClass, boolean header) throws IOException {
        HtmlRendererUtils.writePrettyLineSeparator(facesContext);
        writer.startElement("tr", (UIComponent)newspaperTable);
        int newspaperColumns = newspaperTable.getNewspaperColumns();
        for (int nc = 0; nc < newspaperColumns; ++nc) {
            Iterator it = newspaperTable.getChildren().iterator();
            while (it.hasNext()) {
                UIColumn column;
                UIComponent uiComponent = (UIComponent)it.next();
                if (!(uiComponent instanceof UIColumn) || !(column = (UIColumn)uiComponent).isRendered()) continue;
                UIComponent facet = null;
                facet = header ? column.getHeader() : column.getFooter();
                this.renderColumnHeaderOrFooterCell(facesContext, writer, column, styleClass, facet);
            }
            if (nc >= newspaperColumns - 1) continue;
            this.renderSpacerCell(facesContext, writer, newspaperTable);
        }
        writer.endElement("tr");
    }

    private void renderColumnHeaderOrFooterCell(FacesContext facesContext, ResponseWriter writer, UIColumn uiColumn, String styleClass, UIComponent facet) throws IOException {
        writer.startElement("th", (UIComponent)uiColumn);
        if (styleClass != null) {
            writer.writeAttribute("class", (Object)styleClass, null);
        }
        if (facet != null) {
            RendererUtils.renderChild(facesContext, facet);
        }
        writer.endElement("th");
    }

    private void renderSpacerCell(FacesContext facesContext, ResponseWriter writer, HtmlNewspaperTable newspaperTable) throws IOException {
        if (newspaperTable.getSpacer() == null) {
            return;
        }
        writer.startElement("td", (UIComponent)newspaperTable);
        RendererUtils.renderChild(facesContext, newspaperTable.getSpacer());
        writer.endElement("td");
    }

    private static String getHeaderClass(HtmlNewspaperTable newspaperTable) {
        if (newspaperTable instanceof HtmlDataTable) {
            return newspaperTable.getHeaderClass();
        }
        return (String)newspaperTable.getAttributes().get("headerClass");
    }

    private static String getFooterClass(HtmlNewspaperTable newspaperTable) {
        if (newspaperTable instanceof HtmlDataTable) {
            return newspaperTable.getFooterClass();
        }
        return (String)newspaperTable.getAttributes().get("footerClass");
    }

    public static Styles getStyles(HtmlNewspaperTable newspaperTable) {
        String columnClasses;
        String rowClasses;
        if (newspaperTable instanceof HtmlDataTable) {
            rowClasses = newspaperTable.getRowClasses();
            columnClasses = newspaperTable.getColumnClasses();
        } else {
            rowClasses = (String)newspaperTable.getAttributes().get("rowClasses");
            columnClasses = (String)newspaperTable.getAttributes().get("columnClasses");
        }
        return new Styles(rowClasses, columnClasses);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Styles {
        private String[] _columnStyle;
        private String[] _rowStyle;

        Styles(String rowStyles, String columnStyles) {
            this._rowStyle = rowStyles == null ? ArrayUtils.EMPTY_STRING_ARRAY : StringUtils.trim(StringUtils.splitShortString(rowStyles, ','));
            this._columnStyle = columnStyles == null ? ArrayUtils.EMPTY_STRING_ARRAY : StringUtils.trim(StringUtils.splitShortString(columnStyles, ','));
        }

        public String getRowStyle(int idx) {
            if (!this.hasRowStyle()) {
                return null;
            }
            return this._rowStyle[idx % this._rowStyle.length];
        }

        public String getColumnStyle(int idx) {
            if (!this.hasColumnStyle()) {
                return null;
            }
            return this._columnStyle[idx % this._columnStyle.length];
        }

        public boolean hasRowStyle() {
            return this._rowStyle.length > 0;
        }

        public boolean hasColumnStyle() {
            return this._columnStyle.length > 0;
        }
    }
}

