/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.component.html.util;

import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.context.FacesContext;
import javax.faces.render.Renderer;

public class HtmlComponentUtils {
    private HtmlComponentUtils() {
    }

    public static String getClientId(UIComponent component, Renderer renderer, FacesContext context) {
        Boolean forceValue = (Boolean)component.getAttributes().get("forceId");
        boolean forceId = false;
        if (forceValue != null) {
            forceId = forceValue;
        }
        if (forceId && component.getId() != null) {
            String clientId = component.getId();
            UIComponent parentContainer = HtmlComponentUtils.findParentNamingContainer(component, false);
            if (parentContainer != null && parentContainer instanceof UIData) {
                int rowIndex;
                Boolean forceIdIndexValue = (Boolean)component.getAttributes().get("forceIdIndex");
                boolean forceIdIndex = true;
                if (forceIdIndexValue != null) {
                    forceIdIndex = forceIdIndexValue;
                }
                if (forceIdIndex && (rowIndex = ((UIData)parentContainer).getRowIndex()) != -1) {
                    clientId = clientId + "[" + rowIndex + "]";
                }
            }
            if (renderer != null) {
                clientId = renderer.convertClientId(context, clientId);
            }
            return clientId;
        }
        return null;
    }

    public static UIComponent findParentNamingContainer(UIComponent component, boolean returnRootIfNotFound) {
        UIComponent parent = component.getParent();
        if (returnRootIfNotFound && parent == null) {
            return component;
        }
        while (parent != null) {
            if (parent instanceof NamingContainer) {
                return parent;
            }
            if (returnRootIfNotFound) {
                UIComponent nextParent = parent.getParent();
                if (nextParent == null) {
                    return parent;
                }
                parent = nextParent;
                continue;
            }
            parent = parent.getParent();
        }
        return null;
    }
}

