/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.serial.objectmetamodel;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import org.jboss.serial.objectmetamodel.DataExport;
import org.jboss.serial.objectmetamodel.ObjectDescription;
import org.jboss.serial.objectmetamodel.ObjectReference;
import org.jboss.serial.objectmetamodel.ObjectSubstitutionInterface;
import org.jboss.serial.objectmetamodel.safecloning.SafeCloningRepository;

public class ObjectsCache
extends DataExport {
    final HashMap objectsCache = new HashMap();
    ObjectSubstitutionInterface substitution;
    ClassLoader loader = null;
    boolean checkSerializableClass = true;
    SafeCloningRepository safeToReuse;
    JBossSeralizationOutputInterface output;
    JBossSeralizationInputInterface input;

    public ObjectsCache(ObjectSubstitutionInterface substitution, ClassLoader loader, SafeCloningRepository safeToReuse, boolean checkSerializableClass) {
        this.loader = loader;
        this.substitution = substitution;
        this.checkSerializableClass = checkSerializableClass;
        this.safeToReuse = safeToReuse;
        if (this.loader == null) {
            this.loader = Thread.currentThread().getContextClassLoader();
        }
    }

    public ClassLoader getLoader() {
        return this.loader;
    }

    public void setLoader(ClassLoader loader) {
        this.loader = loader;
    }

    public ObjectSubstitutionInterface getSubstitution() {
        return this.substitution;
    }

    public void setSubstitution(ObjectSubstitutionInterface substitution) {
        this.substitution = substitution;
    }

    public ObjectDescription findObjectInCache(ObjectReference obj) {
        return (ObjectDescription)this.objectsCache.get(obj);
    }

    private ObjectReference makeKey(Object obj) {
        return new ObjectReference(obj);
    }

    public ObjectDescription findObjectInCache(String className, int cacheId) {
        return this.findObjectInCache(new ObjectReference(cacheId, className));
    }

    public void putObjectInCache(Object obj, ObjectDescription description) {
        this.objectsCache.put(this.makeKey(obj), description);
    }

    public void putObjectInCache(ObjectReference objRef, ObjectDescription description) {
        this.objectsCache.put(objRef, description);
    }

    public SafeCloningRepository getSafeToReuse() {
        return this.safeToReuse;
    }

    public boolean isCheckSerializableClass() {
        return this.checkSerializableClass;
    }

    public void setCheckSerializableClass(boolean checkSerializableClass) {
        this.checkSerializableClass = checkSerializableClass;
    }

    public JBossSeralizationOutputInterface getOutput() {
        return this.output;
    }

    public void setOutput(JBossSeralizationOutputInterface output) {
        this.output = output;
    }

    public JBossSeralizationInputInterface getInput() {
        return this.input;
    }

    public void setInput(JBossSeralizationInputInterface input) {
        this.input = input;
    }

    public static interface JBossSeralizationInputInterface
    extends ObjectInput {
        public ObjectReference readObjectReference() throws IOException;

        public byte readByteDirectly() throws IOException;
    }

    public static interface JBossSeralizationOutputInterface
    extends ObjectOutput {
        public void addObjectReference(ObjectReference var1) throws IOException;

        public void openObjectDefinition() throws IOException;

        public void closeObjectDefinition() throws IOException;

        public void writeByteDirectly(byte var1) throws IOException;

        public boolean isCheckSerializableClass();
    }
}

