/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.serial.io;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.NotActiveException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectInputValidation;
import java.io.ObjectStreamClass;
import java.io.StreamCorruptedException;
import org.jboss.serial.objectmetamodel.DataContainer;

public class JBossObjectInputStream
extends ObjectInputStream {
    InputStream is;
    DataInputStream dis;
    DataContainer container;
    ClassLoader classLoader;

    public JBossObjectInputStream(InputStream is) throws IOException {
        this(is, Thread.currentThread().getContextClassLoader());
    }

    public JBossObjectInputStream(InputStream is, ClassLoader loader) throws IOException {
        if (is != null) {
            this.is = is;
            this.dis = is instanceof DataInputStream ? (DataInputStream)is : new DataInputStream(is);
        }
        this.classLoader = loader;
    }

    protected Object readObjectOverride() throws IOException, ClassNotFoundException {
        DataContainer container = new DataContainer(this.classLoader, false);
        container.loadData(this.dis);
        ObjectInput input = container.getInput();
        return input.readObject();
    }

    public Object readObjectDirect() throws IOException, ClassNotFoundException {
        DataContainer container = new DataContainer(this.classLoader, false);
        ObjectInput input = container.getDirectInput(this.dis);
        return input.readObject();
    }

    public Object readUnshared() throws IOException, ClassNotFoundException {
        return this.readObjectOverride();
    }

    public void defaultReadObject() throws IOException, ClassNotFoundException {
    }

    public void registerValidation(ObjectInputValidation obj, int prio) throws NotActiveException, InvalidObjectException {
    }

    protected void readStreamHeader() throws IOException, StreamCorruptedException {
    }

    protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
        return null;
    }

    public int read() throws IOException {
        return this.dis.read();
    }

    public int read(byte[] buf, int off, int len) throws IOException {
        return this.dis.read(buf, off, len);
    }

    public int available() throws IOException {
        return 1;
    }

    public void close() throws IOException {
    }

    public boolean readBoolean() throws IOException {
        return this.dis.readBoolean();
    }

    public byte readByte() throws IOException {
        return this.dis.readByte();
    }

    public int readUnsignedByte() throws IOException {
        return this.dis.readUnsignedByte();
    }

    public char readChar() throws IOException {
        return this.dis.readChar();
    }

    public short readShort() throws IOException {
        return this.dis.readShort();
    }

    public int readUnsignedShort() throws IOException {
        return this.dis.readUnsignedShort();
    }

    public int readInt() throws IOException {
        return this.dis.readInt();
    }

    public long readLong() throws IOException {
        return this.dis.readLong();
    }

    public float readFloat() throws IOException {
        return this.dis.readFloat();
    }

    public double readDouble() throws IOException {
        return this.dis.readDouble();
    }

    public void readFully(byte[] buf) throws IOException {
        this.dis.readFully(buf);
    }

    public void readFully(byte[] buf, int off, int len) throws IOException {
        this.dis.readFully(buf, off, len);
    }

    public int skipBytes(int len) throws IOException {
        return this.dis.skipBytes(len);
    }

    public String readLine() throws IOException {
        return this.dis.readLine();
    }

    public String readUTF() throws IOException {
        return this.dis.readUTF();
    }

    public int read(byte[] b) throws IOException {
        return this.dis.read(b);
    }

    public long skip(long n) throws IOException {
        return this.dis.skip(n);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }
}

