/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shale.validator;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.Application;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.validator.Arg;
import org.apache.commons.validator.Field;
import org.apache.commons.validator.Form;
import org.apache.commons.validator.GenericValidator;
import org.apache.commons.validator.ValidatorAction;
import org.apache.commons.validator.ValidatorResources;
import org.apache.commons.validator.Var;
import org.apache.shale.util.Messages;
import org.xml.sax.SAXException;

public class CommonsValidator
implements Validator,
Serializable {
    private static Logger logger;
    private static Map standardTypes;
    private static final Messages messages;
    private static final Log log;
    public String formName = null;
    private String type;
    private Boolean client;
    private Boolean server;
    private String message;
    private Map vars = new HashMap();
    private static final String ARG_VARNAME = "arg";
    private static final String MIN_VARNAME = "min";
    private static final String MAX_VARNAME = "max";
    private static final String MIN_LENGTH_VARNAME = "minlength";
    private static final String MAX_LENGTH_VARNAME = "maxlength";
    private static final String MASK_VARNAME = "mask";
    private static final String DATE_PATTERN_STRICT_VARNAME = "datePatternStrict";
    private static final String MESSAGE_ARG_NAME = "message";
    private static final String PARAMETER_ARG_NAME = "parameter";
    private static final String FORM_NAME_PREFIX = "org.apache.shale.validator.";
    private static final String JSCALLBACK_ARG_NAME = "jscallback";
    private static final String SUBMITTED_VALUE_VARNAME = "submittedValue";
    static final /* synthetic */ boolean $assertionsDisabled;

    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    public Map getVars() {
        return this.vars;
    }

    public void setType(String newValue) {
        this.type = newValue;
    }

    public String getType() {
        return this.type;
    }

    public void setClient(Boolean newValue) {
        this.client = newValue;
    }

    public Boolean getClient() {
        return this.client;
    }

    public void setServer(Boolean newValue) {
        this.server = newValue;
    }

    public Boolean getServer() {
        return this.server;
    }

    public void setMessage(String newValue) {
        this.message = newValue;
    }

    public String getMessage() {
        return this.message;
    }

    public void setArg(String newValue) {
        this.vars.put(ARG_VARNAME, newValue);
    }

    public String getArg() {
        return (String)this.vars.get(ARG_VARNAME);
    }

    public void setMin(Double newValue) {
        this.vars.put(MIN_VARNAME, newValue);
    }

    public Double getMin() {
        return (Double)this.vars.get(MIN_VARNAME);
    }

    public void setMax(Double newValue) {
        this.vars.put(MAX_VARNAME, newValue);
    }

    public Double getMax() {
        return (Double)this.vars.get(MAX_VARNAME);
    }

    public void setMinLength(Integer newValue) {
        this.vars.put(MIN_LENGTH_VARNAME, newValue);
    }

    public Integer getMinLength() {
        return (Integer)this.vars.get(MIN_LENGTH_VARNAME);
    }

    public void setMaxLength(Integer newValue) {
        this.vars.put(MAX_LENGTH_VARNAME, newValue);
    }

    public Integer getMaxLength() {
        return (Integer)this.vars.get(MAX_LENGTH_VARNAME);
    }

    public void setMask(String newValue) {
        this.vars.put(MASK_VARNAME, newValue);
    }

    public String getMask() {
        return (String)this.vars.get(MASK_VARNAME);
    }

    public void setDatePatternStrict(String newValue) {
        this.vars.put(DATE_PATTERN_STRICT_VARNAME, newValue);
    }

    public String getDatePatternStrict() {
        return (String)this.vars.get(DATE_PATTERN_STRICT_VARNAME);
    }

    private static ValidatorResources getValidatorResources() {
        String VALIDATOR_RESOURCES_KEY = "org.apache.shale.validator.resources";
        FacesContext context = FacesContext.getCurrentInstance();
        ExternalContext external = context.getExternalContext();
        Map applicationMap = external.getApplicationMap();
        ValidatorResources validatorResources = (ValidatorResources)applicationMap.get("org.apache.shale.validator.resources");
        if (validatorResources == null) {
            try {
                String pathnames = external.getInitParameter("org.apache.shale.validator.VALIDATOR_RULES");
                if (pathnames == null || pathnames.length() <= 0) {
                    pathnames = "/org/apache/shale/validator/validator-rules.xml";
                }
                StringTokenizer st = new StringTokenizer(pathnames, ",");
                ArrayList<URL> urlList = new ArrayList<URL>();
                while (st.hasMoreTokens()) {
                    String validatorRules = st.nextToken().trim();
                    logger.log(Level.INFO, messages.getMessage("commonsValidator.loadresource", new Object[]{validatorRules}));
                    URL input = external.getResource(validatorRules);
                    if (input == null) {
                        input = (class$org$apache$shale$validator$CommonsValidator == null ? CommonsValidator.class$("org.apache.shale.validator.CommonsValidator") : class$org$apache$shale$validator$CommonsValidator).getResource(validatorRules);
                    }
                    if (input != null) {
                        urlList.add(input);
                        continue;
                    }
                    logger.log(Level.WARNING, messages.getMessage("commonsValidator.skipresource", new Object[]{validatorRules}));
                }
                int urlSize = urlList.size();
                String[] urlArray = new String[urlSize];
                for (int urlIndex = 0; urlIndex < urlSize; ++urlIndex) {
                    URL url = (URL)urlList.get(urlIndex);
                    urlArray[urlIndex] = url.toExternalForm();
                }
                validatorResources = new ValidatorResources(urlArray);
                applicationMap.put("org.apache.shale.validator.resources", validatorResources);
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, messages.getMessage("commonsValidator.loaderror"), ex);
                return null;
            }
            catch (SAXException ex) {
                logger.log(Level.SEVERE, messages.getMessage("commonsValidator.loaderror"), ex);
                return null;
            }
        }
        return validatorResources;
    }

    protected Object[] getMessageArgs(String ruleName) {
        Arg[] templateArgs = CommonsValidator.getArgs(MESSAGE_ARG_NAME, ruleName);
        if (!$assertionsDisabled && templateArgs == null) {
            throw new AssertionError();
        }
        Object[] target = new Object[templateArgs.length];
        for (int i = 0; i < templateArgs.length; ++i) {
            target[i] = this.vars.get(templateArgs[i].getKey());
        }
        return target;
    }

    protected Class[] loadMethodParamClasses(ValidatorAction validationAction) throws ClassNotFoundException {
        ArrayList<String> tmp = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(validationAction.getMethodParams(), ",");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken().trim();
            if (token.length() <= 0) continue;
            tmp.add(token);
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        if (!$assertionsDisabled && classLoader == null) {
            throw new AssertionError();
        }
        Class[] parameterClasses = new Class[tmp.size()];
        for (int i = 0; i < tmp.size(); ++i) {
            String className = (String)tmp.get(i);
            parameterClasses[i] = standardTypes.containsKey(className) ? (Class)standardTypes.get(className) : classLoader.loadClass(className);
        }
        return parameterClasses;
    }

    public String[] getMethodParamNames(String name) {
        Arg[] templateArgs = CommonsValidator.getArgs(PARAMETER_ARG_NAME, name);
        if (!$assertionsDisabled && templateArgs == null) {
            throw new AssertionError();
        }
        String[] target = new String[templateArgs.length];
        for (int i = 0; i < templateArgs.length; ++i) {
            target[i] = templateArgs[i].getKey();
        }
        return target;
    }

    protected static Arg[] getArgs(String name, String ruleName) {
        StringBuffer formName = new StringBuffer(FORM_NAME_PREFIX);
        formName.append(ruleName);
        Form formDef = CommonsValidator.getValidatorResources().getForm(Locale.getDefault(), formName.toString());
        if (!$assertionsDisabled && formDef == null) {
            throw new AssertionError();
        }
        Field field = formDef.getField(ruleName);
        if (!$assertionsDisabled && field == null) {
            throw new AssertionError();
        }
        Arg[] templateArgs = field.getArgs(name);
        int max = -1;
        for (int i = templateArgs.length - 1; i > -1; --i) {
            if (templateArgs[i] == null) continue;
            max = i;
            break;
        }
        if (max == -1) {
            return new Arg[0];
        }
        if (max < templateArgs.length - 1) {
            Arg[] tmp = new Arg[max + 1];
            System.arraycopy(templateArgs, 0, tmp, 0, max + 1);
            templateArgs = tmp;
        }
        return templateArgs;
    }

    public String getVarType(String varName) {
        StringBuffer formName = new StringBuffer(FORM_NAME_PREFIX);
        formName.append(this.getType());
        Form formDef = CommonsValidator.getValidatorResources().getForm(Locale.getDefault(), formName.toString());
        if (!$assertionsDisabled && formDef == null) {
            throw new AssertionError();
        }
        Field field = formDef.getField(this.getType());
        if (!$assertionsDisabled && field == null) {
            throw new AssertionError();
        }
        String jsType = "string";
        Var var = field.getVar(varName);
        if (var != null && var.getJsType() != null) {
            jsType = var.getJsType();
        }
        return jsType;
    }

    public static String getJsCallbackMnemonic(String ruleName) {
        Arg[] args = CommonsValidator.getArgs(JSCALLBACK_ARG_NAME, ruleName);
        if (args == null || args.length == 0) {
            return ruleName;
        }
        return args[0].getKey();
    }

    protected Object[] loadMethodParamValues(ValidatorAction validatorAction, Class[] methodParamClasses) {
        String[] paramNames = this.getMethodParamNames(validatorAction.getName());
        if (!$assertionsDisabled && paramNames == null) {
            throw new AssertionError();
        }
        Object[] target = new Object[paramNames.length];
        if (!$assertionsDisabled && paramNames.length != methodParamClasses.length) {
            throw new AssertionError();
        }
        for (int i = 0; i < paramNames.length; ++i) {
            Object obj = this.vars.get(paramNames[i]);
            target[i] = CommonsValidator.convert(obj, methodParamClasses[i]);
        }
        return target;
    }

    public static ValidatorAction getValidatorAction(String name) {
        return CommonsValidator.getValidatorResources().getValidatorAction(name);
    }

    public ValidatorAction getValidatorAction() {
        return CommonsValidator.getValidatorResources().getValidatorAction(this.getType());
    }

    protected String[] getDependencies(String name) {
        ValidatorAction action = CommonsValidator.getValidatorAction(name);
        if (!$assertionsDisabled && action == null) {
            throw new AssertionError();
        }
        List dependencies = action.getDependencyList();
        String[] types = new String[dependencies.size() + 1];
        for (int i = 0; i < dependencies.size(); ++i) {
            types[i] = (String)dependencies.get(i);
        }
        types[types.length - 1] = name;
        return types;
    }

    public void validate(FacesContext context, UIComponent component, Object value) {
        if (Boolean.FALSE.equals(this.getServer())) {
            return;
        }
        String[] types = this.getDependencies(this.getType());
        for (int j = 0; j < types.length; ++j) {
            ValidatorAction validatorAction = CommonsValidator.getValidatorAction(types[j]);
            try {
                Boolean r;
                this.vars.put(SUBMITTED_VALUE_VARNAME, value);
                Class validatorClass = this.loadValidatorClass(validatorAction);
                Class[] paramClasses = this.loadMethodParamClasses(validatorAction);
                Object[] paramValues = this.loadMethodParamValues(validatorAction, paramClasses);
                Method validatorMethod = this.loadValidatorMethod(validatorAction, validatorClass, paramClasses);
                Object validator = null;
                if (!Modifier.isStatic(validatorMethod.getModifiers())) {
                    validator = validatorClass.newInstance();
                }
                if (!(r = (Boolean)validatorMethod.invoke((Object)validatorClass, paramValues)).equals(Boolean.FALSE)) continue;
                throw new ValidatorException(new FacesMessage(FacesMessage.SEVERITY_ERROR, this.getErrorMessage(context, validatorAction), null));
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(messages.getMessage("commonsValidator.intException", new Object[]{this.getType(), component.getId()}), e);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(messages.getMessage("commonsValidator.intException", new Object[]{this.getType(), component.getId()}), e);
            }
            catch (InstantiationException e) {
                throw new RuntimeException(messages.getMessage("commonsValidator.intException", new Object[]{this.getType(), component.getId()}), e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(messages.getMessage("commonsValidator.intException", new Object[]{this.getType(), component.getId()}), e);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(messages.getMessage("commonsValidator.intException", new Object[]{this.getType(), component.getId()}), e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(messages.getMessage("commonsValidator.intException", new Object[]{this.getType(), component.getId()}), e);
            }
            finally {
                this.vars.remove(SUBMITTED_VALUE_VARNAME);
            }
        }
    }

    protected Class loadValidatorClass(ValidatorAction validatorAction) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        if (!$assertionsDisabled && classLoader == null) {
            throw new AssertionError();
        }
        Class<?> validatorClass = classLoader.loadClass(validatorAction.getClassname());
        return validatorClass;
    }

    protected Method loadValidatorMethod(ValidatorAction validatorAction, Class validatorClass, Class[] methodParamClasses) throws NoSuchMethodException {
        Method validatorMethod = validatorClass.getMethod(validatorAction.getMethod(), methodParamClasses);
        return validatorMethod;
    }

    public String getErrorMessage(FacesContext context, ValidatorAction validatorAction) {
        String DEFAULT_BUNDLE_NAME = "org.apache.shale.validator.messages";
        Locale locale = context.getViewRoot().getLocale();
        String msg = this.getMessage();
        if (msg == null) {
            ResourceBundle bundle;
            Application app;
            String appBundleName;
            String msgkey = validatorAction.getMsg();
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            if (loader == null) {
                loader = this.getClass().getClassLoader();
            }
            if ((appBundleName = (app = context.getApplication()).getMessageBundle()) != null && (bundle = ResourceBundle.getBundle(appBundleName, locale, loader)) != null) {
                try {
                    msg = bundle.getString(msgkey);
                }
                catch (MissingResourceException ex) {
                    // empty catch block
                }
            }
            if (msg == null && (bundle = ResourceBundle.getBundle("org.apache.shale.validator.messages", locale, loader)) != null) {
                try {
                    msg = bundle.getString(msgkey);
                }
                catch (MissingResourceException ex) {
                    // empty catch block
                }
            }
        }
        Object[] params = this.getMessageArgs(validatorAction.getName());
        msg = new MessageFormat(msg, locale).format(params);
        return msg;
    }

    private static Object convert(Object obj, Class cl) {
        if (cl.isInstance(obj)) {
            return obj;
        }
        if (cl == String.class) {
            return "" + obj;
        }
        if (obj instanceof String) {
            String str = (String)obj;
            if (cl == Boolean.TYPE) {
                return Boolean.valueOf(str);
            }
            if (cl == Byte.TYPE) {
                return new Byte(str);
            }
            if (cl == Character.TYPE) {
                return new Character(str.charAt(0));
            }
            if (cl == Double.TYPE) {
                return new Double(str);
            }
            if (cl == Float.TYPE) {
                return new Float(str);
            }
            if (cl == Integer.TYPE) {
                return new Integer(str);
            }
            if (cl == Long.TYPE) {
                return new Long(str);
            }
            if (cl == Short.TYPE) {
                return new Short(str);
            }
        } else if (obj instanceof Number) {
            Number num = (Number)obj;
            if (cl == Byte.TYPE) {
                return new Byte(num.byteValue());
            }
            if (cl == Double.TYPE) {
                return new Double(num.doubleValue());
            }
            if (cl == Float.TYPE) {
                return new Float(num.floatValue());
            }
            if (cl == Integer.TYPE) {
                return new Integer(num.intValue());
            }
            if (cl == Long.TYPE) {
                return new Long(num.longValue());
            }
            if (cl == Short.TYPE) {
                return new Short(num.shortValue());
            }
        }
        return obj;
    }

    public static boolean isSupplied(String str) {
        return str.trim().length() > 0;
    }

    public static boolean isDate(String d, String datePatternStrict) {
        return GenericValidator.isDate((String)d, (String)datePatternStrict, (boolean)true);
    }

    static {
        $assertionsDisabled = !CommonsValidator.class.desiredAssertionStatus();
        logger = Logger.getLogger("org.apache.shale.validator");
        messages = new Messages("org.apache.shale.resources.Bundle");
        log = LogFactory.getLog((Class)CommonsValidator.class);
        standardTypes = new HashMap();
        standardTypes.put("boolean", Boolean.TYPE);
        standardTypes.put("byte", Byte.TYPE);
        standardTypes.put("char", Character.TYPE);
        standardTypes.put("double", Double.TYPE);
        standardTypes.put("float", Float.TYPE);
        standardTypes.put("int", Integer.TYPE);
        standardTypes.put("long", Long.TYPE);
        standardTypes.put("short", Short.TYPE);
        standardTypes.put("java.lang.String", String.class);
    }
}

