/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shale.util;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Messages {
    private Map bundles = new HashMap();
    private Locale defaultLocale = Locale.getDefault();
    private MessageFormat format = new MessageFormat("");
    private transient Log log = null;
    private ClassLoader cl = null;
    private String name = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Messages() {
        this(null, null);
    }

    public Messages(String name) {
        this(name, null);
    }

    public Messages(String name, ClassLoader cl) {
        this.name = name;
        this.cl = cl;
    }

    public ClassLoader getClassLoader() {
        return this.cl;
    }

    public void setClassLoader(ClassLoader cl) {
        this.cl = null;
        this.reset();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.reset();
    }

    public String getMessage(String key) {
        return this.getMessage(key, this.defaultLocale);
    }

    public String getMessage(String key, Object[] params) {
        return this.getMessage(key, this.defaultLocale, params);
    }

    public String getMessage(String key, Locale locale) {
        ResourceBundle rb = this.getBundle(locale);
        try {
            return rb.getString(key);
        }
        catch (MissingResourceException e) {
            if (this.log().isWarnEnabled()) {
                this.log().warn((Object)("Key " + key + " was not found in resource bundle '" + this.getName() + "' for locale '" + locale + "'"));
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMessage(String key, Locale locale, Object[] params) {
        String message = this.getMessage(key, locale);
        if (message == null || params == null || params.length < 1) {
            return message;
        }
        MessageFormat messageFormat = this.format;
        synchronized (messageFormat) {
            this.format.applyPattern(message);
            message = this.format.format(params);
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourceBundle getBundle(Locale locale) {
        if (!$assertionsDisabled && locale == null) {
            throw new AssertionError();
        }
        ResourceBundle rb = null;
        ClassLoader rbcl = this.cl;
        if (this.cl == null) {
            this.cl = Thread.currentThread().getContextClassLoader();
        }
        Map map = this.bundles;
        synchronized (map) {
            rb = (ResourceBundle)this.bundles.get(locale);
            if (rb == null) {
                try {
                    rb = ResourceBundle.getBundle(this.name, locale, this.cl);
                }
                catch (MissingResourceException e) {
                    rb = ResourceBundle.getBundle(this.name, this.defaultLocale, this.cl);
                }
                if (rb == null) {
                    if (this.log().isWarnEnabled()) {
                        this.log().warn((Object)("Resource bundle '" + this.getName() + "' was not found for locale '" + locale + "'"));
                    }
                } else {
                    this.bundles.put(locale, rb);
                }
            }
            return rb;
        }
    }

    private Log log() {
        if (this.log == null) {
            this.log = LogFactory.getLog((Class)Messages.class);
        }
        return this.log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reset() {
        Map map = this.bundles;
        synchronized (map) {
            this.bundles.clear();
        }
    }

    static {
        $assertionsDisabled = !Messages.class.desiredAssertionStatus();
    }
}

