/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shale.dialog.config;

import java.io.IOException;
import java.net.URL;
import java.util.Map;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.Rule;
import org.apache.shale.dialog.Dialog;
import org.apache.shale.dialog.impl.ActionStateImpl;
import org.apache.shale.dialog.impl.DialogImpl;
import org.apache.shale.dialog.impl.EndStateImpl;
import org.apache.shale.dialog.impl.SubdialogStateImpl;
import org.apache.shale.dialog.impl.TransitionImpl;
import org.apache.shale.dialog.impl.ViewStateImpl;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ConfigurationParser {
    private static final String[] REGISTRATIONS = new String[]{"-//Apache Software Foundation//DTD Shale Dialog Configuration 1.0//EN", "/org/apache/shale/dialog/dialog.dtd"};
    private Map dialogs = null;
    private URL resource = null;
    private boolean validating = true;

    public Map getDialogs() {
        return this.dialogs;
    }

    public void setDialogs(Map dialogs) {
        this.dialogs = dialogs;
    }

    public URL getResource() {
        return this.resource;
    }

    public void setResource(URL resource) {
        this.resource = resource;
    }

    public boolean isValidating() {
        return this.validating;
    }

    public void setValidating(boolean validating) {
        this.validating = validating;
    }

    public void parse() throws IOException, SAXException {
        Digester digester = this.digester();
        digester.clear();
        digester.push((Object)this.getDialogs());
        InputSource source = new InputSource(this.getResource().toExternalForm());
        source.setByteStream(this.getResource().openStream());
        digester.parse(source);
    }

    private Digester digester() {
        Digester digester = new Digester();
        digester.setNamespaceAware(false);
        digester.setUseContextClassLoader(true);
        digester.setValidating(this.isValidating());
        for (int i = 0; i < REGISTRATIONS.length; i += 2) {
            URL url = this.getClass().getResource(REGISTRATIONS[i + 1]);
            digester.register(REGISTRATIONS[i], url.toString());
        }
        digester.addObjectCreate("dialogs/dialog", "className", DialogImpl.class);
        digester.addSetProperties("dialogs/dialog");
        digester.addSetProperty("dialogs/dialog/property", "name", "value");
        digester.addRule("dialogs/dialog", (Rule)new AddDialogRule());
        digester.addObjectCreate("dialogs/dialog/action", "className", ActionStateImpl.class);
        digester.addSetProperties("dialogs/dialog/action");
        digester.addSetProperty("dialogs/dialog/action/property", "name", "value");
        digester.addSetNext("dialogs/dialog/action", "addState", "org.apache.shale.dialog.State");
        digester.addObjectCreate("dialogs/dialog/action/transition", "className", TransitionImpl.class);
        digester.addSetProperties("dialogs/dialog/action/transition");
        digester.addSetProperty("dialogs/dialog/action/transition/property", "name", "value");
        digester.addSetNext("dialogs/dialog/action/transition", "addTransition", "org.apache.shale.dialog.Transition");
        digester.addObjectCreate("dialogs/dialog/end", "className", EndStateImpl.class);
        digester.addSetProperties("dialogs/dialog/end");
        digester.addSetProperty("dialogs/dialog/end/property", "name", "value");
        digester.addSetNext("dialogs/dialog/end", "addState", "org.apache.shale.dialog.State");
        digester.addObjectCreate("dialogs/dialog/end/transition", "className", TransitionImpl.class);
        digester.addSetProperties("dialogs/dialog/end/transition");
        digester.addSetProperty("dialogs/dialog/end/transition/property", "name", "value");
        digester.addSetNext("dialogs/dialog/end/transition", "addTransition", "org.apache.shale.dialog.Transition");
        digester.addObjectCreate("dialogs/dialog/subdialog", "className", SubdialogStateImpl.class);
        digester.addSetProperties("dialogs/dialog/subdialog");
        digester.addSetProperty("dialogs/dialog/subdialog/property", "name", "value");
        digester.addSetNext("dialogs/dialog/subdialog", "addState", "org.apache.shale.dialog.State");
        digester.addObjectCreate("dialogs/dialog/subdialog/transition", "className", TransitionImpl.class);
        digester.addSetProperties("dialogs/dialog/subdialog/transition");
        digester.addSetProperty("dialogs/dialog/subdialog/transition/property", "name", "value");
        digester.addSetNext("dialogs/dialog/subdialog/transition", "addTransition", "org.apache.shale.dialog.Transition");
        digester.addObjectCreate("dialogs/dialog/transition", "className", TransitionImpl.class);
        digester.addSetProperties("dialogs/dialog/transition");
        digester.addSetProperty("dialogs/dialog/transition/property", "name", "value");
        digester.addSetNext("dialogs/dialog/transition", "addTransition", "org.apache.shale.dialog.Transition");
        digester.addObjectCreate("dialogs/dialog/view", "className", ViewStateImpl.class);
        digester.addSetProperties("dialogs/dialog/view");
        digester.addSetProperty("dialogs/dialog/view/property", "name", "value");
        digester.addSetNext("dialogs/dialog/view", "addState", "org.apache.shale.dialog.State");
        digester.addObjectCreate("dialogs/dialog/view/transition", "className", TransitionImpl.class);
        digester.addSetProperties("dialogs/dialog/view/transition");
        digester.addSetProperty("dialogs/dialog/view/transition/property", "name", "value");
        digester.addSetNext("dialogs/dialog/view/transition", "addTransition", "org.apache.shale.dialog.Transition");
        return digester;
    }

    static class AddDialogRule
    extends Rule {
        AddDialogRule() {
        }

        public void end(String namespace, String name) throws Exception {
            Dialog dialog = (Dialog)this.getDigester().peek();
            Map map = (Map)this.getDigester().peek(1);
            map.put(dialog.getName(), dialog);
        }
    }
}

