/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shale.component;

import javax.faces.application.FacesMessage;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.shale.util.LoadBundle;
import org.apache.shale.util.Messages;
import org.apache.shale.util.TokenProcessor;

public class Token
extends UIInput {
    private static final Log log = LogFactory.getLog((Class)Token.class);
    private static final String MESSAGE_SUMMARY_KEY = "token.summary.invalid";
    private static final String MESSAGE_DETAIL_KEY = "token.detail.invalid";
    private static Messages messages = new Messages("org.apache.shale.resources.Bundle", Token.class.getClassLoader());
    private String messageSummary = null;
    private String messageDetail = null;

    public String getMessageSummary() {
        if (null != this.messageSummary) {
            return this.messageSummary;
        }
        ValueBinding valuebinding = this.getValueBinding("messageSummary");
        if (valuebinding != null) {
            return (String)valuebinding.getValue(this.getFacesContext());
        }
        return null;
    }

    public void setMessageSummary(String message) {
        this.messageSummary = message;
    }

    public String getMessageDetail() {
        if (null != this.messageDetail) {
            return this.messageDetail;
        }
        ValueBinding valuebinding = this.getValueBinding("messageDetail");
        if (valuebinding != null) {
            return (String)valuebinding.getValue(this.getFacesContext());
        }
        return null;
    }

    public void setMessageDetail(String message) {
        this.messageDetail = message;
    }

    public Token() {
        this.setRendererType("org.apache.shale.Token");
    }

    public String getFamily() {
        return "org.apache.shale.Token";
    }

    public void validate(FacesContext context) {
        TokenProcessor tp;
        super.validate(context);
        String token = (String)this.getValue();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Validating token '" + token + "'"));
        }
        if (!(tp = this.getTokenProcessor(context)).verify(context, token)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"  Validation failed!");
            }
            this.setValid(false);
            String summary = this.getErrorSummaryMessage(context);
            String detail = this.getErrorDetailMessage(context);
            FacesMessage message = new FacesMessage(summary, detail);
            message.setSeverity(FacesMessage.SEVERITY_ERROR);
            context.addMessage(this.getClientId(context), message);
        }
    }

    private String getErrorSummaryMessage(FacesContext context) {
        String msg = null;
        msg = this.getMessageSummary();
        if (msg == null) {
            String bundleName = null;
            bundleName = context.getApplication().getMessageBundle();
            if (bundleName != null) {
                LoadBundle loadBundle = new LoadBundle(bundleName);
                msg = (String)loadBundle.getMap().get(MESSAGE_SUMMARY_KEY);
            }
        }
        if (msg == null) {
            msg = messages.getMessage(MESSAGE_SUMMARY_KEY);
        }
        return msg;
    }

    private String getErrorDetailMessage(FacesContext context) {
        String msg = null;
        msg = this.getMessageDetail();
        if (msg == null) {
            String bundleName = null;
            bundleName = context.getApplication().getMessageBundle();
            if (bundleName != null) {
                LoadBundle loadBundle = new LoadBundle(bundleName);
                msg = (String)loadBundle.getMap().get(MESSAGE_DETAIL_KEY);
            }
        }
        if (msg == null) {
            msg = messages.getMessage(MESSAGE_DETAIL_KEY);
        }
        return msg;
    }

    public String getToken() {
        FacesContext context = FacesContext.getCurrentInstance();
        TokenProcessor tp = this.getTokenProcessor(context);
        String token = tp.generate(context);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Generating token '" + token + "'"));
        }
        return token;
    }

    private TokenProcessor getTokenProcessor(FacesContext context) {
        TokenProcessor tp = (TokenProcessor)context.getExternalContext().getApplicationMap().get("org.apache.shale.TOKEN_PROCESSOR");
        if (tp == null) {
            tp = new TokenProcessor();
            context.getExternalContext().getApplicationMap().put("org.apache.shale.TOKEN_PROCESSOR", tp);
        }
        return tp;
    }

    public void restoreState(FacesContext context, Object obj) {
        Object[] aobj = (Object[])obj;
        super.restoreState(context, aobj[0]);
        this.messageSummary = (String)aobj[1];
        this.messageDetail = (String)aobj[2];
    }

    public Object saveState(FacesContext context) {
        Object[] aobj = new Object[]{super.saveState(context), this.messageSummary, this.messageDetail};
        return aobj;
    }
}

