/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.framework.util.command;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import org.ajax4jsf.framework.resource.ClientScript;
import org.ajax4jsf.framework.util.InputUtils;
import org.ajax4jsf.framework.util.command.CommandScript;
import org.ajax4jsf.framework.util.javascript.JSFunction;
import org.ajax4jsf.framework.util.javascript.JSReference;
import org.ajax4jsf.framework.util.javascript.ScriptString;

public class CommandScriptBuilder {
    public static final ClientScript SCRIPT = new CommandScript();
    private static final ScriptString JSR_EVENT = new JSReference("(event || window.event)");
    private boolean checkActionAndListener = true;
    private StringBuffer codeAfter = new StringBuffer();
    private StringBuffer codeBefore = new StringBuffer();
    private UICommand component;
    private Map parameters;
    private String target;
    private boolean useOriginalOnclick = true;

    public CommandScriptBuilder(UICommand command) {
        this.component = command;
        this.collectParams();
    }

    public void addCodeAfter(String codeAfter) {
        this.codeAfter.append(codeAfter);
    }

    public void addCodeBefore(String codeBefore) {
        this.codeBefore.append(codeBefore);
    }

    public void addParameter(String name, Object value) {
        if (this.parameters == null) {
            this.parameters = new LinkedHashMap();
        }
        this.parameters.put(name, value);
    }

    private void addParameter(UIParameter parameter) {
        this.addParameter(parameter.getName(), parameter.getValue());
    }

    private void collectParams() {
        Iterator iter = this.component.getChildren().iterator();
        while (iter.hasNext()) {
            UIComponent kid = (UIComponent)iter.next();
            if (!(kid instanceof UIParameter)) continue;
            this.addParameter((UIParameter)kid);
        }
    }

    public StringBuffer getScript() {
        Object onclick;
        StringBuffer script = new StringBuffer();
        script.append(this.codeBefore).append(";");
        if (this.useOriginalOnclick && (onclick = this.component.getAttributes().get("onclick")) != null) {
            script.append(onclick).append(";");
        }
        if (this.shouldGenerateAction()) {
            JSFunction function = new JSFunction("new A4J_Command");
            function.addParameter(JSR_EVENT);
            function.addParameter(this.parameters);
            function.addParameter(this.target);
            function.appendScript(script);
            script.append(";");
        }
        script.append(this.codeAfter).append(";");
        return script;
    }

    public String getTarget() {
        return this.target;
    }

    private boolean hasActionOrListenerSet() {
        return this.component.getAction() != null || this.component.getActionListener() != null;
    }

    public boolean isCheckActionAndListener() {
        return this.checkActionAndListener;
    }

    public boolean isUseOriginalOnclick() {
        return this.useOriginalOnclick;
    }

    public void setCheckActionAndListener(boolean checkActionAndListener) {
        this.checkActionAndListener = checkActionAndListener;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void setUseOriginalOnclick(boolean useOriginalOnclick) {
        this.useOriginalOnclick = useOriginalOnclick;
    }

    private boolean shouldGenerateAction() {
        return !InputUtils.isDisabled((UIComponent)this.component) && (!this.checkActionAndListener || this.hasActionOrListenerSet());
    }

    public String toString() {
        return this.getScript().toString();
    }
}

