/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.framework.renderer;

import java.io.IOException;
import java.util.Iterator;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;
import org.ajax4jsf.framework.renderer.ChameleonRenderer;
import org.ajax4jsf.framework.renderer.RendererUtils;
import org.ajax4jsf.framework.resource.InternetResource;
import org.ajax4jsf.framework.resource.InternetResourceBuilder;
import org.ajax4jsf.framework.skin.Skin;
import org.ajax4jsf.framework.skin.SkinFactory;
import org.ajax4jsf.framework.util.message.Messages;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class RendererBase
extends Renderer
implements ChameleonRenderer {
    protected static final String JAVASCRIPT_NAMESPACE = "Exadel";
    private static final Log log = LogFactory.getLog((Class)RendererBase.class);
    private static final RendererUtils utils = new RendererUtils();
    private SkinFactory skinFactory = null;
    private InternetResourceBuilder resourceBuilder = null;

    public void decode(FacesContext context, UIComponent component) {
        if (context == null) {
            throw new NullPointerException(Messages.getMessage(Messages.CONTEXT_NULL_ERROR, "decode"));
        }
        if (component == null) {
            throw new NullPointerException(Messages.getMessage(Messages.COMPONENT_NULL_ERROR, "decode"));
        }
        if (!this.getComponentClass().isInstance(component)) {
            throw new IllegalArgumentException(Messages.getMessage(Messages.COMPONENT_CLASS_ERROR, "", this.getComponentClass().getName()));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage(Messages.START_DECODING_COMPONENT_INFO, component.getClientId(context), component.getClass().getName()));
        }
        this.preDecode(context, component);
        if (component.isRendered()) {
            this.doDecode(context, component);
        }
    }

    protected void preDecode(FacesContext context, UIComponent component) {
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (context == null) {
            throw new NullPointerException(Messages.getMessage(Messages.CONTEXT_NULL_ERROR, "encodeBegin"));
        }
        if (component == null) {
            throw new NullPointerException(Messages.getMessage(Messages.COMPONENT_NULL_ERROR, "encodeBegin"));
        }
        if (!this.getComponentClass().isInstance(component)) {
            throw new IllegalArgumentException(Messages.getMessage(Messages.COMPONENT_CLASS_ERROR, component.getClientId(context), this.getComponentClass().getName()));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage(Messages.START_ENCODING_COMPONENT_INFO, component.getClientId(context), component.getClass().getName()));
        }
        this.preEncodeBegin(context, component);
        if (component.isRendered()) {
            ResponseWriter writer = context.getResponseWriter();
            this.doEncodeBegin(writer, context, component);
        }
    }

    protected void preEncodeBegin(FacesContext context, UIComponent component) throws IOException {
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (context == null) {
            throw new NullPointerException(Messages.getMessage(Messages.CONTEXT_NULL_ERROR, "encodeEnd"));
        }
        if (component == null) {
            throw new NullPointerException(Messages.getMessage(Messages.COMPONENT_NULL_ERROR, "encodeEnd"));
        }
        if (!this.getComponentClass().isInstance(component)) {
            throw new IllegalArgumentException(Messages.getMessage(Messages.COMPONENT_CLASS_ERROR, component.getClientId(context), this.getComponentClass().getName()));
        }
        if (component.isRendered()) {
            ResponseWriter writer = context.getResponseWriter();
            this.doEncodeEnd(writer, context, component);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage(Messages.FINISH_ENCODING_COMPONENT_INFO, component.getClientId(context), component.getClass().getName()));
        }
    }

    public InternetResource getResource(String resourceURI) throws FacesException {
        return this.getResourceBuilder().createResource(this, resourceURI);
    }

    private InternetResourceBuilder getResourceBuilder() {
        if (this.resourceBuilder == null) {
            this.resourceBuilder = InternetResourceBuilder.getInstance();
        }
        return this.resourceBuilder;
    }

    protected Skin getSkin(FacesContext context) {
        if (this.skinFactory == null) {
            this.skinFactory = SkinFactory.getInstance();
        }
        return this.skinFactory.getSkin(context);
    }

    public RendererUtils getUtils() {
        return utils;
    }

    protected abstract Class getComponentClass();

    protected void doDecode(FacesContext context, UIComponent component) {
    }

    protected void doEncodeBegin(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
    }

    protected void doEncodeEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
    }

    protected void addResource(String key, InternetResource resource) {
        this.getResourceBuilder().addResource(key, resource);
    }

    public void renderChildren(FacesContext facesContext, UIComponent component) throws IOException {
        if (component.getChildCount() > 0) {
            Iterator it = component.getChildren().iterator();
            while (it.hasNext()) {
                UIComponent child = (UIComponent)it.next();
                this.renderChild(facesContext, child);
            }
        }
    }

    public void renderChild(FacesContext facesContext, UIComponent child) throws IOException {
        if (!child.isRendered()) {
            return;
        }
        child.encodeBegin(facesContext);
        if (child.getRendersChildren()) {
            child.encodeChildren(facesContext);
        } else {
            this.renderChildren(facesContext, child);
        }
        child.encodeEnd(facesContext);
    }
}

