/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.serial.persister;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Proxy;
import org.jboss.logging.Logger;
import org.jboss.serial.classmetamodel.ClassMetaData;
import org.jboss.serial.classmetamodel.ClassMetamodelFactory;
import org.jboss.serial.exception.SerializationException;
import org.jboss.serial.objectmetamodel.ObjectDescription;
import org.jboss.serial.objectmetamodel.ObjectSubstitutionInterface;
import org.jboss.serial.persister.Persister;

public class ClassReferencePersister
implements Persister {
    protected static final Logger log = Logger.getLogger((Class)(class$org$jboss$serial$persister$ClassReferencePersister == null ? (class$org$jboss$serial$persister$ClassReferencePersister = ClassReferencePersister.class$("org.jboss.serial.persister.ClassReferencePersister")) : class$org$jboss$serial$persister$ClassReferencePersister));
    byte id;
    static /* synthetic */ Class class$org$jboss$serial$persister$ClassReferencePersister;

    public byte getId() {
        return this.id;
    }

    public void setId(byte id) {
        this.id = id;
    }

    public void writeData(ObjectDescription descriptor, ObjectOutput output, Object obj, ObjectSubstitutionInterface substitution) throws IOException {
        Class clazz = (Class)obj;
        ClassMetaData clazzMetaData = ClassMetamodelFactory.getClassMetaData(clazz, false);
        boolean isProxy = clazzMetaData.isProxy();
        output.writeBoolean(isProxy);
        if (isProxy) {
            Class<?>[] interfaces = clazz.getInterfaces();
            output.writeInt(interfaces.length);
            for (int i = 0; i < interfaces.length; ++i) {
                output.writeUTF(interfaces[i].getName());
            }
        } else {
            output.writeUTF(clazz.getName());
        }
    }

    public Object readData(ClassLoader loader, ObjectDescription descriptor, ObjectInput input, ObjectSubstitutionInterface substitution) throws IOException {
        boolean isProxy = input.readBoolean();
        if (isProxy) {
            int size = input.readInt();
            Class[] interfaces = new Class[size];
            for (int i = 0; i < interfaces.length; ++i) {
                interfaces[i] = this.lookupClass(loader, input.readUTF());
            }
            return Proxy.getProxyClass(loader, interfaces);
        }
        String name = input.readUTF();
        return this.lookupClass(loader, name);
    }

    private Class lookupClass(ClassLoader loader, String name) throws IOException {
        try {
            return loader.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            throw new SerializationException(e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

