/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.serial.classmetamodel;

import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectStreamClass;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import org.jboss.serial.classmetamodel.ClassMetaData;
import org.jboss.serial.classmetamodel.ClassMetadataField;
import org.jboss.serial.classmetamodel.ConstructorManager;
import org.jboss.serial.classmetamodel.DefaultConstructorManager;
import org.jboss.serial.classmetamodel.FieldsManager;
import org.jboss.serial.classmetamodel.SunConstructorManager;
import org.jboss.serial.exception.SerializationException;

public class ClassMetamodelFactory {
    static Method methodLookup;
    static Method methodGetField;
    static HashMap cache;
    static HashMap solvedClasses;
    static ClassMetaData proxyMetaData;
    static ConstructorManager[] constructorManagers;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$java$io$ObjectStreamClass;
    static /* synthetic */ Class class$java$io$ObjectStreamField;
    static /* synthetic */ Class class$java$io$Serializable;
    static /* synthetic */ Class class$java$io$Externalizable;
    static /* synthetic */ Class class$java$io$ObjectInputStream;
    static /* synthetic */ Class class$java$io$ObjectOutputStream;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Boolean;

    private static ObjectStreamClass lookup(Class clazz) throws IllegalAccessException, InvocationTargetException {
        return (ObjectStreamClass)methodLookup.invoke(null, clazz, Boolean.TRUE);
    }

    private static Field getField(Object source) throws IllegalAccessException, InvocationTargetException {
        return (Field)methodGetField.invoke(source, new Object[0]);
    }

    public static ClassMetaData getClassMetaData(String clazzName, ClassLoader loader, boolean checkSerializable) throws IOException {
        try {
            return ClassMetamodelFactory.getClassMetaData(ClassMetamodelFactory.solveClass(clazzName, loader), checkSerializable);
        }
        catch (ClassNotFoundException e) {
            throw new SerializationException("class " + clazzName + " not found", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Class lookupClassOnCahce(String clazzName, ClassLoader loader) throws ClassNotFoundException {
        Class<?> clazzFound = null;
        ClassAndLoaderKey key = new ClassAndLoaderKey(clazzName, loader);
        clazzFound = (Class<?>)solvedClasses.get(key);
        if (clazzFound == null) {
            HashMap hashMap = solvedClasses;
            synchronized (hashMap) {
                clazzFound = loader.loadClass(clazzName);
                solvedClasses.put(key, clazzFound);
            }
        }
        return clazzFound;
    }

    static Class solveClass(String clazzName, ClassLoader loader) throws ClassNotFoundException {
        if (clazzName.startsWith("[")) {
            Class clazz = ClassMetamodelFactory.findClass(clazzName, loader);
            int countOf = 0;
            for (int i = 0; i < clazzName.length() && clazzName.charAt(i) == '['; ++i) {
                ++countOf;
            }
            int[] arrays = new int[countOf];
            for (int i = 0; i < arrays.length; ++i) {
                arrays[i] = 0;
            }
            return Array.newInstance(clazz, arrays).getClass();
        }
        return ClassMetamodelFactory.lookupClassOnCahce(clazzName, loader);
    }

    private static Class findClass(String clazzName, ClassLoader loader) throws ClassNotFoundException {
        while (clazzName.startsWith("[")) {
            if ((clazzName = clazzName.substring(1)).startsWith("L")) {
                clazzName = clazzName.substring(1, clazzName.lastIndexOf(";"));
                return ClassMetamodelFactory.lookupClassOnCahce(clazzName, loader);
            }
            if (clazzName.startsWith("[")) continue;
            char nativeSignature = clazzName.charAt(0);
            switch (nativeSignature) {
                case 'Z': {
                    return Boolean.TYPE;
                }
                case 'B': {
                    return Byte.TYPE;
                }
                case 'C': {
                    return Character.TYPE;
                }
                case 'S': {
                    return Short.TYPE;
                }
                case 'I': {
                    return Integer.TYPE;
                }
                case 'J': {
                    return Long.TYPE;
                }
                case 'F': {
                    return Float.TYPE;
                }
                case 'D': {
                    return Double.TYPE;
                }
            }
            loader.loadClass(clazzName);
        }
        throw new RuntimeException("signature " + clazzName + " invalid");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassMetaData getClassMetaData(Class clazz, boolean checkSerializable) throws IOException {
        if (checkSerializable && !(class$java$io$Serializable == null ? (class$java$io$Serializable = ClassMetamodelFactory.class$("java.io.Serializable")) : class$java$io$Serializable).isAssignableFrom(clazz)) {
            throw new NotSerializableException(clazz.getName());
        }
        ClassMetaData returnData = null;
        returnData = (ClassMetaData)cache.get(clazz);
        if (returnData == null) {
            HashMap hashMap = cache;
            synchronized (hashMap) {
                returnData = (ClassMetaData)cache.get(clazz);
                if (returnData == null) {
                    returnData = new ClassMetaData();
                    returnData.setClassName(clazz.getName());
                    returnData.setClazz(clazz);
                    returnData.setProxy(Proxy.isProxyClass(clazz));
                    try {
                        returnData.setConstructor(ClassMetamodelFactory.findConstructor(clazz));
                    }
                    catch (NoSuchMethodException e) {
                        returnData.setConstructor(null);
                    }
                    returnData.setExternalizable((class$java$io$Externalizable == null ? (class$java$io$Externalizable = ClassMetamodelFactory.class$("java.io.Externalizable")) : class$java$io$Externalizable).isAssignableFrom(clazz));
                    ClassMetamodelFactory.fieldsExplode(clazz, returnData);
                    cache.put(clazz, returnData);
                }
            }
        }
        if (returnData.isProxy()) {
            return proxyMetaData;
        }
        return returnData;
    }

    private static Constructor findConstructor(Class clazz) throws NoSuchMethodException {
        for (int i = 0; i < constructorManagers.length; ++i) {
            if (!constructorManagers[i].isSupported()) continue;
            return constructorManagers[i].getConstructor(clazz);
        }
        throw new NoSuchMethodException("Constructor not found as having difficulties in reflection");
    }

    private static void fieldsExplode(Class clazz, ClassMetaData returnData) {
        if (!returnData.isExternalizable() && !returnData.isArray) {
            ClassMetamodelFactory.lookupInternalMethods(clazz, returnData);
            for (Class classIteration = clazz; classIteration != null; classIteration = classIteration.getSuperclass()) {
                Field[] fields = classIteration.getDeclaredFields();
                for (int i = 0; i < fields.length; ++i) {
                    if ((fields[i].getModifiers() & 0x88) != 0) continue;
                    fields[i].setAccessible(true);
                    ClassMetadataField classfield = new ClassMetadataField();
                    classfield.setField(fields[i]);
                    classfield.setFieldName(fields[i].getName());
                    classfield.setObject(!ClassMetamodelFactory.isImmutable(fields[i].getType()));
                    FieldsManager.getFieldsManager().fillMetadata(classfield);
                    returnData.addField(classfield.getFieldName(), classfield);
                }
            }
        }
    }

    private static void lookupInternalMethods(Class clazz, ClassMetaData metaclass) {
        try {
            Method method = clazz.getDeclaredMethod("readResolve", new Class[0]);
            method.setAccessible(true);
            metaclass.setReadResolveMethod(method);
        }
        catch (Exception ignored) {
            // empty catch block
        }
        Class currentClass = clazz;
        while ((class$java$io$Serializable == null ? ClassMetamodelFactory.class$("java.io.Serializable") : class$java$io$Serializable).isAssignableFrom(currentClass)) {
            try {
                Method method = currentClass.getDeclaredMethod("readObject", class$java$io$ObjectInputStream == null ? (class$java$io$ObjectInputStream = ClassMetamodelFactory.class$("java.io.ObjectInputStream")) : class$java$io$ObjectInputStream);
                method.setAccessible(true);
                metaclass.setPrivateMethodRead(method);
                method = currentClass.getDeclaredMethod("writeObject", class$java$io$ObjectOutputStream == null ? (class$java$io$ObjectOutputStream = ClassMetamodelFactory.class$("java.io.ObjectOutputStream")) : class$java$io$ObjectOutputStream);
                method.setAccessible(true);
                metaclass.setPrivateMethodWrite(method);
                break;
            }
            catch (Exception exception) {
                currentClass = currentClass.getSuperclass();
            }
        }
    }

    public static boolean isImmutable(Class clazz) {
        return clazz == (class$java$lang$Character == null ? (class$java$lang$Character = ClassMetamodelFactory.class$("java.lang.Character")) : class$java$lang$Character) || clazz == (class$java$lang$String == null ? (class$java$lang$String = ClassMetamodelFactory.class$("java.lang.String")) : class$java$lang$String) || clazz == (class$java$lang$Long == null ? (class$java$lang$Long = ClassMetamodelFactory.class$("java.lang.Long")) : class$java$lang$Long) || clazz == (class$java$lang$Byte == null ? (class$java$lang$Byte = ClassMetamodelFactory.class$("java.lang.Byte")) : class$java$lang$Byte) || clazz == (class$java$lang$Double == null ? (class$java$lang$Double = ClassMetamodelFactory.class$("java.lang.Double")) : class$java$lang$Double) || clazz == (class$java$lang$Float == null ? (class$java$lang$Float = ClassMetamodelFactory.class$("java.lang.Float")) : class$java$lang$Float) || clazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = ClassMetamodelFactory.class$("java.lang.Integer")) : class$java$lang$Integer) || clazz == (class$java$lang$Short == null ? (class$java$lang$Short = ClassMetamodelFactory.class$("java.lang.Short")) : class$java$lang$Short) || clazz == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = ClassMetamodelFactory.class$("java.lang.Boolean")) : class$java$lang$Boolean) || clazz.isPrimitive();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            methodLookup = (class$java$io$ObjectStreamClass == null ? (class$java$io$ObjectStreamClass = ClassMetamodelFactory.class$("java.io.ObjectStreamClass")) : class$java$io$ObjectStreamClass).getDeclaredMethod("lookup", class$java$lang$Class == null ? (class$java$lang$Class = ClassMetamodelFactory.class$("java.lang.Class")) : class$java$lang$Class, Boolean.TYPE);
            methodLookup.setAccessible(true);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            methodGetField = (class$java$io$ObjectStreamField == null ? (class$java$io$ObjectStreamField = ClassMetamodelFactory.class$("java.io.ObjectStreamField")) : class$java$io$ObjectStreamField).getDeclaredMethod("getField", new Class[0]);
            methodGetField.setAccessible(true);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        cache = new HashMap();
        solvedClasses = new HashMap();
        proxyMetaData = null;
        constructorManagers = new ConstructorManager[]{new SunConstructorManager(), new DefaultConstructorManager()};
        try {
            proxyMetaData = ClassMetamodelFactory.getClassMetaData("java.lang.reflect.Proxy", Thread.currentThread().getContextClassLoader(), true);
            proxyMetaData.setProxy(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static class ClassAndLoaderKey {
        protected ClassLoader loader;
        protected String name;

        public ClassAndLoaderKey(String name, ClassLoader loader) {
            this.name = name;
            this.loader = loader;
        }

        public ClassLoader getLoader() {
            return this.loader;
        }

        public void setLoader(ClassLoader loader) {
            this.loader = loader;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClassAndLoaderKey that = (ClassAndLoaderKey)o;
            if (!this.loader.equals(that.loader)) {
                return false;
            }
            return this.name.equals(that.name);
        }

        public int hashCode() {
            int result = this.loader.hashCode();
            result = 29 * result + this.name.hashCode();
            return result;
        }
    }
}

