/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.mdb;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.EJBException;
import javax.ejb.MessageDriven;
import javax.ejb.Timer;
import javax.ejb.TimerService;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import javax.jms.Connection;
import javax.jms.ConnectionConsumer;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.ServerSessionPool;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.Transaction;
import org.jboss.annotation.ejb.AcknowledgementMode;
import org.jboss.annotation.ejb.DefaultActivationSpecs;
import org.jboss.annotation.ejb.Durability;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.MethodInfo;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.util.MethodHashing;
import org.jboss.aspects.asynch.FutureHolder;
import org.jboss.deployment.DeploymentException;
import org.jboss.ejb.txtimer.TimedObjectInvoker;
import org.jboss.ejb3.EJB3Util;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.EJBContainerInvocation;
import org.jboss.ejb3.EJBProxyFactory;
import org.jboss.ejb3.Ejb3Deployment;
import org.jboss.ejb3.EjbTimerUtil;
import org.jboss.ejb3.ProxyFactoryHelper;
import org.jboss.ejb3.ProxyUtils;
import org.jboss.ejb3.ThreadLocalENCFactory;
import org.jboss.ejb3.interceptor.InterceptorInfoRepository;
import org.jboss.ejb3.mdb.ActivationSpec;
import org.jboss.ejb3.mdb.DLQHandler;
import org.jboss.ejb3.mdb.MDBConfig;
import org.jboss.ejb3.mdb.MDBContext;
import org.jboss.ejb3.tx.TxUtil;
import org.jboss.jms.ConnectionFactoryHelper;
import org.jboss.jms.asf.ServerSessionPoolFactory;
import org.jboss.jms.asf.StdServerSessionPool;
import org.jboss.jms.jndi.JMSProviderAdapter;
import org.jboss.logging.Logger;
import org.jboss.metadata.ActivationConfigPropertyMetaData;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.mx.util.ObjectNameConverter;
import org.jboss.system.Registry;

public class MDB
extends EJBContainer
implements TimedObjectInvoker {
    private static final Logger log = Logger.getLogger(MDB.class);
    protected Method ON_MESSAGE;
    protected TimerService timerService;
    protected ActivationSpec activationSpec = new ActivationSpec();
    protected boolean isContainerManagedTx;
    protected AcknowledgementMode acknowledgeMode;
    protected boolean isNotSupportedTx;
    protected Connection connection;
    protected ConnectionConsumer connectionConsumer;
    protected ServerSessionPool serverSessionPool;
    protected MDBConfig config;
    protected ExceptionListenerImpl exListener;
    protected DLQHandler dlqHandler;
    protected String messagingType = null;
    protected Method getServerSessionPool;
    protected static final String DEFAULT_DESTINATION_TYPE = "javax.jms.Topic";

    public MDB(String ejbName, AspectManager manager, ClassLoader cl, String beanClassName, Hashtable ctxProperties, InterceptorInfoRepository interceptorRepository, Ejb3Deployment deployment) {
        super("jboss.j2ee:service=EJB3,name=" + ejbName, manager, cl, beanClassName, ejbName, ctxProperties, interceptorRepository, deployment);
        Method[] methods;
        this.beanContextClass = MDBContext.class;
        for (Method m : methods = ServerSessionPoolFactory.class.getMethods()) {
            if (!m.getName().equals("getServerSessionPool")) continue;
            this.getServerSessionPool = m;
            break;
        }
    }

    public String getMessagingType() {
        if (this.messagingType == null) {
            this.messagingType = "javax.jms.MessageListener";
            MessageDriven annotation = (MessageDriven)this.resolveAnnotation(MessageDriven.class);
            for (ActivationConfigProperty property : annotation.activationConfig()) {
                if (!property.propertyName().equals("messagingType")) continue;
                this.messagingType = property.propertyValue();
                return this.messagingType;
            }
        }
        return this.messagingType;
    }

    public String getResourceAdaptorName() {
        String result = null;
        MessageDriven annotation = (MessageDriven)this.resolveAnnotation(MessageDriven.class);
        for (ActivationConfigProperty property : annotation.activationConfig()) {
            if (!property.propertyName().equals("resourceAdaptorName")) continue;
            return property.propertyValue();
        }
        return result;
    }

    public String getDestination() {
        String result = null;
        MessageDriven annotation = (MessageDriven)this.resolveAnnotation(MessageDriven.class);
        for (ActivationConfigProperty property : annotation.activationConfig()) {
            if (!property.propertyName().equals("destination")) continue;
            return property.propertyValue();
        }
        return result;
    }

    public Map getActivationConfigProperties() {
        HashMap<String, ActivationConfigPropertyMetaData> result = new HashMap<String, ActivationConfigPropertyMetaData>();
        MessageDriven annotation = (MessageDriven)this.resolveAnnotation(MessageDriven.class);
        for (ActivationConfigProperty property : annotation.activationConfig()) {
            if (property.propertyName().equals("destination") || property.propertyName().equals("resourceAdaptorName") || property.propertyName().equals("messagingType")) continue;
            ActivationConfigPropertyMetaData metaData = new ActivationConfigPropertyMetaData();
            try {
                Field nameField = ActivationConfigPropertyMetaData.class.getDeclaredField("name");
                nameField.setAccessible(true);
                nameField.set(metaData, property.propertyName());
                Field valueField = ActivationConfigPropertyMetaData.class.getDeclaredField("value");
                valueField.setAccessible(true);
                valueField.set(metaData, property.propertyValue());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            result.put(property.propertyName(), metaData);
        }
        return result;
    }

    public TransactionAttributeType getTransactionAttributeType() {
        TransactionAttribute annotation = (TransactionAttribute)this.resolveAnnotation(TransactionAttribute.class);
        if (annotation != null) {
            return annotation.value();
        }
        return TransactionAttributeType.REQUIRED;
    }

    public void start() throws Exception {
        super.start();
        this.exListener = new ExceptionListenerImpl(this);
        this.createProxies();
        this.populateActivationSpec();
        this.config = MDBConfig.createMDBConfig(this.activationSpec);
        this.innerStart();
        this.timerService = EjbTimerUtil.getTimerService(this, this);
        this.startProxies();
    }

    protected void innerStart() throws Exception {
        try {
            this.innerCreate();
        }
        catch (JMSException e) {
            new Thread("EJB3 MDB Create Recovery Thread"){

                public void run() {
                    MDB.this.exListener.onException(e);
                }
            }.start();
            return;
        }
        if (this.dlqHandler != null) {
            this.dlqHandler.start();
        }
        if (this.connection != null) {
            this.connection.setExceptionListener((ExceptionListener)this.exListener);
            this.connection.start();
        }
    }

    public ObjectName getJmxName() {
        ObjectName jmxName = null;
        String jndiName = ProxyFactoryHelper.getLocalJndiName(this);
        String name = "jboss.j2ee:service=EJB,jndiName=" + jndiName;
        try {
            jmxName = ObjectNameConverter.convert((String)name);
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
            throw new RuntimeException("Failed to create ObjectName, msg=" + e.getMessage());
        }
        return jmxName;
    }

    protected void createProxies() throws Exception {
        EJBProxyFactory proxyFactory = this.getProxyFactory();
        if (proxyFactory != null) {
            ObjectName jmxName = this.getJmxName();
            MBeanServer server = MBeanServerLocator.locateJBoss();
            ObjectName containerName = this.getJmxName();
            Hashtable<String, String> props = containerName.getKeyPropertyList();
            String invokerBinding = "message-inflow-driven-bean";
            props.put("plugin", "invoker");
            props.put("binding", invokerBinding);
            ObjectName invokerName = new ObjectName(containerName.getDomain(), props);
            server.registerMBean(proxyFactory, jmxName);
            int jmxHash = jmxName.hashCode();
            Registry.bind((Object)new Integer(jmxHash), (Object)jmxName);
            proxyFactory.create();
        }
    }

    protected void startProxies() throws Exception {
        EJBProxyFactory proxyFactory = this.getProxyFactory();
        if (proxyFactory != null) {
            proxyFactory.start();
        }
    }

    public Object localInvoke(Method method, Object[] args, FutureHolder provider) throws Throwable {
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        try {
            long hash = MethodHashing.calculateHash((Method)method);
            MethodInfo info = (MethodInfo)this.methodInterceptors.get(hash);
            if (info == null) {
                throw new RuntimeException("Could not resolve beanClass method from proxy call: " + method.toString());
            }
            Interceptor[] aspects = info.interceptors;
            EJBContainerInvocation nextInvocation = new EJBContainerInvocation(info, aspects);
            nextInvocation.setAdvisor((Advisor)this);
            nextInvocation.setArguments(args);
            ProxyUtils.addLocalAsynchronousInfo(nextInvocation, provider);
            Object object = nextInvocation.invokeNext();
            return object;
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw t;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
    }

    private void innerCreate() throws Exception {
        log.debug((Object)"Initializing");
        MessageDriven messageDriven = (MessageDriven)this.resolveAnnotation(MessageDriven.class);
        JMSProviderAdapter adapter = this.getJMSProviderAdapter();
        log.debug((Object)("Provider adapter: " + adapter));
        this.setupDLQ(adapter);
        TransactionManagement transactionManagement = (TransactionManagement)this.resolveAnnotation(TransactionManagement.class);
        this.isContainerManagedTx = transactionManagement == null ? true : transactionManagement.value() == TransactionManagementType.CONTAINER;
        String ackMode = this.config.getAcknowledgeMode();
        this.acknowledgeMode = ackMode != null && (ackMode.equals("DUPS_OK_ACKNOWLEDGE") || ackMode.equals(AcknowledgementMode.AUTO_ACKNOWLEDGE.name()) || ackMode.equals("Dups-ok-acknowledge")) ? AcknowledgementMode.DUPS_OK : AcknowledgementMode.AUTO_ACKNOWLEDGE;
        TransactionAttribute trans = (TransactionAttribute)this.resolveAnnotation(this.getOnMessage(), TransactionAttribute.class);
        TransactionAttributeType txType = trans == null ? TransactionAttributeType.REQUIRED : trans.value();
        this.isNotSupportedTx = txType == TransactionAttributeType.NOT_SUPPORTED;
        Context context = adapter.getInitialContext();
        log.debug((Object)("context: " + context));
        if (context == null) {
            throw new RuntimeException("Failed to get the root context");
        }
        String destinationType = this.config.getDestinationType();
        if (destinationType == null) {
            log.warn((Object)"No message-driven-destination given; using; guessing type");
            destinationType = this.getDestinationType(context, this.config.getDestination());
        }
        if (DEFAULT_DESTINATION_TYPE.equals(destinationType)) {
            this.innerCreateTopic(context, adapter);
        } else if ("javax.jms.Queue".equals(destinationType)) {
            this.innerCreateQueue(context, adapter);
        } else {
            throw new DeploymentException("Unknown destination-type " + destinationType);
        }
        log.debug((Object)("Initialized with config " + this.toString()));
        context.close();
    }

    private void innerCreateQueue(Context context, JMSProviderAdapter adapter) throws Exception {
        log.debug((Object)("Got destination type Queue for " + this.ejbName));
        String jndiSuffix = this.parseJndiSuffix(this.config.getDestination(), this.ejbName);
        log.debug((Object)("jndiSuffix: " + jndiSuffix));
        Object qFactory = context.lookup(adapter.getQueueFactoryRef());
        QueueConnection qConnection = null;
        try {
            qConnection = ConnectionFactoryHelper.createQueueConnection((Object)qFactory, (String)this.config.getUser(), (String)this.config.getPassword());
            this.connection = qConnection;
        }
        catch (ClassCastException e) {
            throw new DeploymentException("Expected a QueueConnection check your provider adaptor: " + adapter.getQueueFactoryRef());
        }
        String clientId = this.config.getClientID();
        log.debug((Object)("Using client id: " + clientId));
        if (clientId != null && clientId.length() > 0) {
            this.connection.setClientID(clientId);
        }
        Queue queue = null;
        try {
            if (this.config.getDestination() != null) {
                queue = (Queue)context.lookup(this.config.getDestination());
            }
        }
        catch (NamingException e) {
            log.warn((Object)("Could not find the queue destination-jndi-name=" + this.config.getDestination()));
        }
        catch (ClassCastException e) {
            throw new DeploymentException("Expected a Queue destination-jndi-name=" + this.config.getDestination());
        }
        if (queue == null) {
            queue = (Queue)this.createDestination(Queue.class, context, "queue/" + jndiSuffix, jndiSuffix);
        }
        this.serverSessionPool = this.createSessionPool((Destination)queue, (Connection)qConnection, true, this.acknowledgeMode.ordinal(), new MessageListenerImpl(this));
        log.debug((Object)("Server session pool: " + this.pool));
        this.connectionConsumer = qConnection.createConnectionConsumer(queue, this.config.getMessageSelector(), this.serverSessionPool, this.config.getMaxMessages());
        log.debug((Object)("Connection consumer: " + this.connectionConsumer));
    }

    private void innerCreateTopic(Context context, JMSProviderAdapter adapter) throws Exception {
        log.debug((Object)("Got destination type Topic for " + this.ejbName));
        String jndiSuffix = this.parseJndiSuffix(this.config.getDestination(), this.ejbName);
        log.debug((Object)("jndiSuffix: " + jndiSuffix));
        Object factory = context.lookup(adapter.getTopicFactoryRef());
        TopicConnection tConnection = null;
        try {
            tConnection = ConnectionFactoryHelper.createTopicConnection((Object)factory, (String)this.config.getUser(), (String)this.config.getPassword());
            this.connection = tConnection;
        }
        catch (ClassCastException e) {
            throw new DeploymentException("Expected a TopicConnection check your provider adaptor: " + adapter.getTopicFactoryRef());
        }
        String clientId = this.config.getClientID();
        log.debug((Object)("Using client id: " + clientId));
        if (clientId != null && clientId.length() > 0) {
            this.connection.setClientID(clientId);
        }
        Topic topic = null;
        try {
            if (this.config.getDestination() != null) {
                topic = (Topic)context.lookup(this.config.getDestination());
            }
        }
        catch (NamingException e) {
            log.warn((Object)("Could not find the topic destination-jndi-name=" + this.config.getDestination()));
        }
        catch (ClassCastException e) {
            throw new DeploymentException("Expected a Topic destination-jndi-name=" + this.config.getDestination());
        }
        if (topic == null) {
            topic = (Topic)this.createDestination(Topic.class, context, "topic/" + jndiSuffix, jndiSuffix);
        }
        this.serverSessionPool = this.createSessionPool((Destination)topic, (Connection)tConnection, true, this.acknowledgeMode.ordinal(), new MessageListenerImpl(this));
        String durability = this.config.getDurability();
        Durability subscriptionDurability = durability != null && durability.equals("Durable") ? Durability.DURABLE : Durability.NON_DURABLE;
        if (subscriptionDurability == Durability.NON_DURABLE) {
            this.connectionConsumer = tConnection.createConnectionConsumer(topic, this.config.getMessageSelector(), this.serverSessionPool, this.config.getMaxMessages());
        } else {
            String durableName = this.config.getSubscriptionName();
            this.connectionConsumer = tConnection.createDurableConnectionConsumer(topic, durableName, this.config.getMessageSelector(), this.serverSessionPool, this.config.getMaxMessages());
        }
        log.debug((Object)"Topic connectionConsumer set up");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ServerSessionPool createSessionPool(Destination dest, Connection connection, boolean isTransacted, int ack, MessageListener listener) throws NamingException, JMSException {
        ServerSessionPool pool;
        block10: {
            InitialContext context = EJB3Util.getInitialContext(this.initialContextProperties);
            try {
                log.debug((Object)("JNDI Hashtable: " + this.initialContextProperties));
                ServerSessionPoolFactory factory = (ServerSessionPoolFactory)context.lookup(this.config.getServerSessionPoolFactoryJNDI());
                if (this.getServerSessionPool.getParameterTypes().length == 9) {
                    try {
                        pool = (ServerSessionPool)this.getServerSessionPool.invoke((Object)factory, dest, connection, this.config.getMinPoolSize(), this.config.getMaxPoolSize(), this.config.getKeepAlive(), isTransacted, ack, !this.isContainerManagedTx || this.isNotSupportedTx, listener);
                        break block10;
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                    catch (InvocationTargetException e) {
                        throw new RuntimeException(e);
                    }
                }
                try {
                    pool = (ServerSessionPool)this.getServerSessionPool.invoke((Object)factory, connection, this.config.getMinPoolSize(), this.config.getMaxPoolSize(), this.config.getKeepAlive(), isTransacted, ack, !this.isContainerManagedTx || this.isNotSupportedTx, listener);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
            finally {
                context.close();
            }
        }
        return pool;
    }

    protected Destination createDestination(Class type, Context ctx, String jndiName, String jndiSuffix) throws Exception {
        try {
            return (Destination)ctx.lookup(jndiName);
        }
        catch (NamingException e) {
            String methodName;
            log.warn((Object)("destination not found: " + jndiName + " reason: " + e));
            log.warn((Object)("creating a new temporary destination: " + jndiName));
            MBeanServer server = MBeanServerLocator.locateJBoss();
            if (type == Topic.class) {
                methodName = "createTopic";
            } else if (type == Queue.class) {
                methodName = "createQueue";
            } else {
                throw new IllegalArgumentException("Expected javax.jms.Queue or javax.jms.Topic: " + type);
            }
            server.invoke(new ObjectName("jboss.mq:service=DestinationManager"), methodName, new Object[]{jndiSuffix}, new String[]{"java.lang.String"});
            return (Destination)ctx.lookup(jndiName);
        }
    }

    protected String parseJndiSuffix(String jndiname, String defautSuffix) {
        int indexOfSlash;
        String jndiSuffix = "";
        jndiSuffix = jndiname != null ? ((indexOfSlash = jndiname.indexOf("/")) != -1 ? jndiname.substring(indexOfSlash + 1) : jndiname) : defautSuffix;
        return jndiSuffix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JMSProviderAdapter getJMSProviderAdapter() throws NamingException {
        InitialContext context = this.getInitialContext();
        String providerAdapterJNDI = this.config.getProviderAdapterJNDI();
        try {
            log.debug((Object)("Looking up provider adapter: " + providerAdapterJNDI));
            JMSProviderAdapter jMSProviderAdapter = (JMSProviderAdapter)context.lookup(providerAdapterJNDI);
            return jMSProviderAdapter;
        }
        finally {
            context.close();
        }
    }

    protected String getDestinationType(Context ctx, String destinationJNDI) {
        String destType = null;
        if (destinationJNDI != null) {
            try {
                Destination dest = (Destination)ctx.lookup(destinationJNDI);
                if (dest instanceof Topic) {
                    destType = DEFAULT_DESTINATION_TYPE;
                } else if (dest instanceof Queue) {
                    destType = "javax.jms.Queue";
                }
            }
            catch (NamingException ex) {
                log.debug((Object)"Could not do heristic lookup of destination ", (Throwable)ex);
            }
        }
        if (destType == null) {
            log.warn((Object)"Could not determine destination type, defaults to: javax.jms.Topic");
            destType = DEFAULT_DESTINATION_TYPE;
        }
        return destType;
    }

    private void setupDLQ(JMSProviderAdapter adapter) throws Exception {
        if (this.config.isUseDLQ()) {
            this.dlqHandler = new DLQHandler(adapter, this.config);
            this.dlqHandler.create();
        }
    }

    protected Method getOnMessage() {
        if (this.ON_MESSAGE != null) {
            return this.ON_MESSAGE;
        }
        try {
            Class<Message> arg = Message.class;
            if (MessageListener.class.isAssignableFrom(this.clazz)) {
                this.ON_MESSAGE = this.clazz.getMethod("onMessage", arg);
            } else {
                Class<?> messagingTypeClass = this.getClassloader().loadClass(this.getMessagingType());
                Method[] methods = messagingTypeClass.getDeclaredMethods();
                this.ON_MESSAGE = methods[0];
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ExceptionInInitializerError(e);
        }
        return this.ON_MESSAGE;
    }

    private void populateActivationSpec() {
        DefaultActivationSpecs defaultSpecs = (DefaultActivationSpecs)this.resolveAnnotation(DefaultActivationSpecs.class);
        if (defaultSpecs != null) {
            this.activationSpec.merge(defaultSpecs.value());
        }
        MessageDriven md = (MessageDriven)this.resolveAnnotation(MessageDriven.class);
        this.activationSpec.merge(md.activationConfig());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object localInvoke(Method method, Object[] args) throws Throwable {
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        ThreadLocalENCFactory.push(this.enc);
        try {
            long hash = MethodHashing.calculateHash((Method)method);
            MethodInfo info = (MethodInfo)this.methodInterceptors.get(hash);
            if (info == null) {
                throw new RuntimeException("Could not resolve beanClass method from proxy call: " + method.toString());
            }
            Interceptor[] aspects = info.interceptors;
            EJBContainerInvocation nextInvocation = new EJBContainerInvocation(info, aspects);
            nextInvocation.setAdvisor((Advisor)this);
            nextInvocation.setArguments(args);
            Object object = nextInvocation.invokeNext();
            return object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
            ThreadLocalENCFactory.pop();
        }
    }

    public TimerService getTimerService() {
        return this.timerService;
    }

    public void callTimeout(Timer timer) throws Exception {
        Method timeout = this.callbackHandler.getTimeoutCallback();
        if (timeout == null) {
            throw new EJBException("No method has been annotated with @Timeout");
        }
        Object[] args = new Object[]{timer};
        try {
            this.localInvoke(timeout, args);
        }
        catch (Throwable throwable) {
            if (throwable instanceof Exception) {
                throw (Exception)throwable;
            }
            throw new RuntimeException(throwable);
        }
    }

    protected void innerStop() {
        try {
            if (this.connection != null) {
                this.connection.setExceptionListener(null);
                log.debug((Object)"unset exception listener");
            }
        }
        catch (Exception e) {
            log.error((Object)"Could not set ExceptionListener to null", (Throwable)e);
        }
        try {
            if (this.connection != null) {
                this.connection.stop();
                log.debug((Object)"connection stopped");
            }
        }
        catch (Exception e) {
            log.error((Object)"Could not stop JMS connection", (Throwable)e);
        }
    }

    public void stop() throws Exception {
        EjbTimerUtil.removeTimerService(this);
        if (this.exListener != null) {
            this.exListener.stop();
        }
        this.innerStop();
        if (this.dlqHandler != null) {
            this.dlqHandler.stop();
        }
        this.stopProxies();
    }

    protected void stopProxies() throws Exception {
        EJBProxyFactory proxyFactory = this.getProxyFactory();
        if (proxyFactory != null) {
            proxyFactory.stop();
        }
    }

    protected void destroyProxies() throws Exception {
        EJBProxyFactory proxyFactory = this.getProxyFactory();
        if (proxyFactory != null) {
            proxyFactory.destroy();
            ObjectName jmxName = this.getJmxName();
            MBeanServer server = MBeanServerLocator.locateJBoss();
            server.unregisterMBean(this.getJmxName());
            int jmxHash = jmxName.hashCode();
            Registry.unbind((Object)new Integer(jmxHash));
        }
    }

    public void innerDestroy() throws Exception {
        try {
            if (this.connectionConsumer != null) {
                this.connectionConsumer.close();
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to close connection consumer", (Throwable)e);
        }
        try {
            if (this.serverSessionPool instanceof StdServerSessionPool) {
                StdServerSessionPool p = (StdServerSessionPool)this.serverSessionPool;
                p.clear();
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to clear session pool", (Throwable)e);
        }
        if (this.connection != null) {
            try {
                this.connection.close();
                this.connection = null;
            }
            catch (Exception e) {
                log.error((Object)"Failed to close connection", (Throwable)e);
            }
        }
        try {
            if (this.dlqHandler != null) {
                this.dlqHandler.destroy();
                this.dlqHandler = null;
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to close the dlq handler", (Throwable)e);
        }
    }

    public void destroy() throws Exception {
        this.innerDestroy();
        this.destroyProxies();
    }

    class ExceptionListenerImpl
    implements ExceptionListener {
        MDB invoker;
        Thread currentThread;
        boolean notStoped = true;

        ExceptionListenerImpl(MDB invoker) {
            this.invoker = invoker;
        }

        public void onException(JMSException ex) {
            this.currentThread = Thread.currentThread();
            log.warn((Object)"JMS provider failure detected: ", (Throwable)ex);
            boolean tryIt = true;
            while (tryIt && this.notStoped) {
                log.info((Object)"Trying to reconnect to JMS provider");
                try {
                    try {
                        Thread.sleep(MDB.this.config.getReconnectInterval());
                    }
                    catch (InterruptedException ie) {
                        tryIt = false;
                        return;
                    }
                    this.invoker.innerStop();
                    this.invoker.innerDestroy();
                    this.invoker.innerStart();
                    tryIt = false;
                    log.info((Object)"Reconnected to JMS provider");
                }
                catch (Exception e) {
                    log.error((Object)"Reconnect failed: JMS provider failure detected:", (Throwable)e);
                }
            }
            this.currentThread = null;
        }

        void stop() {
            log.debug((Object)"Stop requested");
            this.notStoped = false;
            if (this.currentThread != null) {
                this.currentThread.interrupt();
                log.debug((Object)"Current thread interrupted");
            }
        }
    }

    class MessageListenerImpl
    implements MessageListener {
        MDB invoker;

        MessageListenerImpl(MDB invoker) {
            this.invoker = invoker;
        }

        public void onMessage(Message message) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("processing message: " + message));
            }
            try {
                Transaction tx = TxUtil.getTransactionManager().getTransaction();
                if (MDB.this.config.isUseDLQ() && message.getJMSRedelivered() && MDB.this.dlqHandler.handleRedeliveredMessage(message, tx)) {
                    return;
                }
                this.invoker.localInvoke(MDB.this.ON_MESSAGE, new Object[]{message});
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Throwable e) {
                log.error((Object)"Exception in JMSCI message listener", e);
            }
        }
    }
}

