/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.entity;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceContextType;
import org.jboss.ejb3.PersistenceUnitRegistry;
import org.jboss.ejb3.entity.InjectedEntityManager;
import org.jboss.ejb3.entity.ManagedEntityManagerFactory;
import org.jboss.ejb3.entity.PersistenceUnitDeployment;

public class InjectedEntityManagerFactory
implements EntityManagerFactory,
Externalizable {
    private transient EntityManagerFactory delegate;
    private transient ManagedEntityManagerFactory managedFactory;
    private String kernelName;

    public InjectedEntityManagerFactory() {
    }

    public InjectedEntityManagerFactory(ManagedEntityManagerFactory managedFactory) {
        this.delegate = managedFactory.getEntityManagerFactory();
        this.managedFactory = managedFactory;
    }

    protected EntityManagerFactory getDelegate() {
        return this.delegate;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.managedFactory.getKernelName());
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        String kernelName = in.readUTF();
        PersistenceUnitDeployment deployment = PersistenceUnitRegistry.getPersistenceUnit(kernelName);
        if (deployment == null) {
            throw new IOException("Unable to find persistence unit in registry: " + kernelName);
        }
        this.managedFactory = deployment.getManagedFactory();
        this.delegate = this.managedFactory.getEntityManagerFactory();
    }

    public EntityManager createEntityManager() {
        return this.getDelegate().createEntityManager();
    }

    public EntityManager createEntityManager(PersistenceContextType type) {
        return this.getDelegate().createEntityManager(type);
    }

    public EntityManager getEntityManager() {
        return new InjectedEntityManager(this.managedFactory);
    }

    public void close() {
        throw new IllegalStateException("It is illegal to close an injected EntityManagerFactory");
    }

    public boolean isOpen() {
        return this.getDelegate().isOpen();
    }
}

