/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.embedded;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.management.MBeanServer;
import org.jboss.aop.AspectXmlLoader;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.ejb3.embedded.EJB3StandaloneDeployer;
import org.jboss.ejb3.embedded.KernelErrors;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.bootstrap.basic.BasicBootstrap;
import org.jboss.kernel.plugins.deployment.xml.BeanXMLDeployer;
import org.jboss.kernel.spi.deployment.KernelDeployment;
import org.jboss.logging.Logger;

public class EJB3StandaloneBootstrap {
    private static final Logger log = Logger.getLogger(EJB3StandaloneBootstrap.class);
    public static Kernel kernel;
    private static EJB3StandaloneDeployer deployer;
    private static boolean warned;
    private static ArrayList<KernelDeployment> deployments;
    private static ArrayList<URL> aopDeployments;
    public static HashSet ignoredJars;

    public static Kernel getKernel() {
        return kernel;
    }

    public static void deployXmlResource(String resource) {
        try {
            BeanXMLDeployer deployer = new BeanXMLDeployer(kernel);
            URL bootstrap = Thread.currentThread().getContextClassLoader().getResource(resource);
            if (bootstrap == null) {
                throw new RuntimeException("Cannot find " + resource);
            }
            deployments.add(0, deployer.deploy(bootstrap));
            deployer.validate();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public static Hashtable getInitialContextProperties() {
        Hashtable hash = null;
        ControllerContext context = kernel.getController().getInstalledContext((Object)"InitialContextProperties");
        if (context != null) {
            hash = (Hashtable)context.getTarget();
        } else if (!warned) {
            log.warn((Object)"Could not find an configured InitialContextProperties, this is ok if your already have a correct jndi.properties file");
            warned = true;
        }
        return hash;
    }

    public static void scanClasspath(String paths) {
        try {
            String classpath = System.getProperty("java.class.path");
            StringTokenizer tokenizer = new StringTokenizer(classpath, File.pathSeparator);
            String[] split = paths.split(",");
            for (int i = 0; i < split.length; ++i) {
                split[i] = split[i].trim();
            }
            deployer = EJB3StandaloneBootstrap.createDeployer();
            while (tokenizer.hasMoreTokens()) {
                File fp;
                String path = tokenizer.nextToken().trim();
                boolean found = false;
                for (String wantedPath : split) {
                    if (!path.endsWith(wantedPath)) continue;
                    found = true;
                    break;
                }
                if (!found || ignoredJars.contains((fp = new File(path)).getName())) continue;
                URL archive = fp.toURL();
                deployer.getArchives().add(archive);
            }
            if (deployer.getArchives().size() == 0) {
                deployer = null;
                return;
            }
            deployer.create();
            deployer.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!KernelErrors.validate(kernel)) {
            throw new RuntimeException("Problems scanning classpath");
        }
    }

    public static void scanClasspath() {
        try {
            String classpath = System.getProperty("java.class.path");
            StringTokenizer tokenizer = new StringTokenizer(classpath, File.pathSeparator);
            deployer = EJB3StandaloneBootstrap.createDeployer();
            while (tokenizer.hasMoreTokens()) {
                String path = tokenizer.nextToken();
                File fp = new File(path);
                if (ignoredJars.contains(fp.getName())) continue;
                URL archive = fp.toURL();
                deployer.getArchives().add(archive);
            }
            if (deployer.getArchives().size() == 0) {
                deployer = null;
                return;
            }
            deployer.create();
            deployer.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!KernelErrors.validate(kernel)) {
            throw new RuntimeException("Problems scanning classpath");
        }
    }

    public static EJB3StandaloneDeployer createDeployer() {
        EJB3StandaloneDeployer deployer = new EJB3StandaloneDeployer();
        deployer.setJndiProperties(EJB3StandaloneBootstrap.getInitialContextProperties());
        deployer.setKernel(kernel);
        MBeanServer mbeanServer = null;
        ControllerContext context = kernel.getController().getInstalledContext((Object)"MBeanServer");
        if (context != null) {
            mbeanServer = (MBeanServer)context.getTarget();
        } else {
            log.debug((Object)"No MBeanServer");
        }
        deployer.setMbeanServer(mbeanServer);
        return deployer;
    }

    public static void shutdown() {
        try {
            if (deployer != null) {
                deployer.stop();
                deployer.destroy();
                deployer = null;
            }
            BeanXMLDeployer deployer = new BeanXMLDeployer(kernel);
            for (KernelDeployment deployment : deployments) {
                deployer.undeploy(deployment);
            }
            for (URL url : aopDeployments) {
                try {
                    AspectXmlLoader.undeployXML((URL)url);
                }
                catch (Exception e) {
                    log.warn((Object)e);
                }
            }
            kernel = null;
        }
        catch (Throwable throwable) {
            log.warn((Object)throwable);
        }
    }

    public static void boot(String configPath) {
        String basePath = "";
        if (configPath != null && !configPath.equals("")) {
            basePath = configPath;
            if (!configPath.endsWith("/")) {
                basePath = basePath + "/";
            }
        }
        try {
            URL bootstrap = Thread.currentThread().getContextClassLoader().getResource(basePath + "embedded-jboss-beans.xml");
            EJB3StandaloneBootstrap.createKernel();
            BeanXMLDeployer deployer = new BeanXMLDeployer(kernel);
            if (bootstrap == null) {
                throw new RuntimeException("Cannot find embedded-jboss-beans.xml");
            }
            deployments.add(0, deployer.deploy(bootstrap));
            deployer.validate();
            URL ejb3_interceptors = Thread.currentThread().getContextClassLoader().getResource("ejb3-interceptors-aop.xml");
            if (ejb3_interceptors == null) {
                throw new RuntimeException("Cannot find ejb3-interceptors-aop.xml");
            }
            AspectXmlLoader.deployXML((URL)ejb3_interceptors);
            aopDeployments.add(ejb3_interceptors);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public static void createKernel() throws Exception {
        BasicBootstrap bootstrap1 = new BasicBootstrap();
        bootstrap1.run();
        kernel = bootstrap1.getKernel();
    }

    static {
        warned = false;
        deployments = new ArrayList();
        aopDeployments = new ArrayList();
        ignoredJars = new HashSet();
        ignoredJars.add("antlr-2.7.5H3.jar");
        ignoredJars.add("asm-attrs.jar");
        ignoredJars.add("asm.jar");
        ignoredJars.add("cglib-2.1.1.jar");
        ignoredJars.add("commons-collections.jar");
        ignoredJars.add("commons-logging-api.jar");
        ignoredJars.add("commons-logging.jar");
        ignoredJars.add("concurrent.jar");
        ignoredJars.add("dom4j.jar");
        ignoredJars.add("ejb3-persistence.jar");
        ignoredJars.add("hibernate3.jar");
        ignoredJars.add("hibernate-annotations.jar");
        ignoredJars.add("hibernate-entitymanager.jar");
        ignoredJars.add("hsqldb.jar");
        ignoredJars.add("javassist.jar");
        ignoredJars.add("jboss-annotations-ejb3.jar");
        ignoredJars.add("jboss-aop-jdk50.jar");
        ignoredJars.add("jboss-aspect-library-jdk50.jar");
        ignoredJars.add("jboss-common.jar");
        ignoredJars.add("jboss-common-jdbc-wrapper.jar");
        ignoredJars.add("jboss-container.jar");
        ignoredJars.add("jboss-dependency.jar");
        ignoredJars.add("jboss-ejb3.jar");
        ignoredJars.add("jboss-ejb3x.jar");
        ignoredJars.add("jboss-j2ee.jar");
        ignoredJars.add("jboss-j2se.jar");
        ignoredJars.add("jboss.jar");
        ignoredJars.add("jboss-jca.jar");
        ignoredJars.add("jboss-local-jdbc.jar");
        ignoredJars.add("jboss-microcontainer.jar");
        ignoredJars.add("jbossmq.jar");
        ignoredJars.add("jboss-remoting.jar");
        ignoredJars.add("jbosssx.jar");
        ignoredJars.add("jboss-system.jar");
        ignoredJars.add("jboss-transaction.jar");
        ignoredJars.add("jboss-xa-jdbc.jar");
        ignoredJars.add("jnpserver.jar");
        ignoredJars.add("log4j.jar");
        ignoredJars.add("resolver.jar");
        ignoredJars.add("trove.jar");
        ignoredJars.add("xercesImpl.jar");
        ignoredJars.add("xml-apis.jar");
    }
}

