/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.dd;

import javax.annotation.AuthenticationType;
import org.jboss.ejb3.dd.InjectionTarget;
import org.jboss.logging.Logger;

public class ResourceRef {
    private static final Logger log = Logger.getLogger(ResourceRef.class);
    private String resRefName;
    private String resType;
    private String resAuth;
    private String resSharingScope;
    private InjectionTarget injectionTarget;
    private String mappedName;
    private String jndiName;
    private String resourceName;

    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    public String getMappedName() {
        return this.mappedName;
    }

    public void setMappedName(String mappedName) {
        this.mappedName = mappedName;
    }

    public InjectionTarget getInjectionTarget() {
        return this.injectionTarget;
    }

    public void setInjectionTarget(InjectionTarget injectionTarget) {
        this.injectionTarget = injectionTarget;
    }

    public String getResRefName() {
        return this.resRefName;
    }

    public void setResRefName(String resRefName) {
        this.resRefName = resRefName;
    }

    public String getResType() {
        return this.resType;
    }

    public void setResType(String resType) {
        this.resType = resType;
    }

    public String getResAuth() {
        return this.resAuth;
    }

    public void setResAuth(String resAuth) {
        this.resAuth = resAuth;
    }

    public AuthenticationType getAuthorizationType() {
        if (this.resAuth == null || this.resAuth.equals("Container")) {
            return AuthenticationType.CONTAINER;
        }
        return AuthenticationType.APPLICATION;
    }

    public String getResSharingScope() {
        return this.resSharingScope;
    }

    public void setResSharingScope(String resSharingScope) {
        this.resSharingScope = resSharingScope;
    }

    public boolean isShareable() {
        return this.resSharingScope == null || this.resSharingScope.equals("Shareable");
    }

    public void merge(ResourceRef ref) {
        String mappedName;
        if (ref.getJndiName() != null) {
            this.setJndiName(ref.getJndiName());
            mappedName = ref.getJndiName();
            if (mappedName.startsWith("java:")) {
                this.setMappedName(ref.getJndiName());
            } else {
                this.setMappedName("java:" + ref.getJndiName());
            }
        }
        if (ref.getResourceName() != null) {
            this.setResourceName(ref.getResourceName());
            mappedName = ref.getResourceName();
            if (mappedName.startsWith("java:")) {
                this.setMappedName(ref.getResourceName());
            } else {
                this.setMappedName("java:" + ref.getResourceName());
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(100);
        sb.append("[" + this.getClass().getSimpleName() + ": ");
        sb.append("resRefName=").append(this.resRefName);
        sb.append(", jndiName=").append(this.jndiName);
        sb.append(", resourceName=").append(this.resourceName);
        sb.append(", resType=").append(this.resType);
        sb.append(", mappedName=").append(this.mappedName);
        sb.append("]");
        return sb.toString();
    }
}

