/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.renderers.ajax;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.html.HtmlForm;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.framework.renderer.HeaderResourcesRendererBase;
import org.ajax4jsf.framework.renderer.RendererUtils;
import org.ajax4jsf.framework.resource.InternetResource;

public class FormRenderer
extends HeaderResourcesRendererBase {
    public static final String FORM_SUBMIT_FUNCTION_NAME = "_JSFFormSubmit";
    public static final String FORM_CLEAR_FUNCTION_NAME = "_clearJSFFormParameters";
    private static final String FORM_HAS_COMMAND_LINK_ATTR = "com.sun.faces.FORM_HAS_COMMAND_LINK_ATTR";
    private static final String NO_COMMAND_LINK_FOUND_VALUE = "com.sun.faces.NO_COMMAND_LINK_FOUND";
    public static final String CONTENT_TYPE_IS_XHTML = "com.sun.facesContentTypeIsXHTML";
    public static final String HIDDEN_FIELD_SUFFIX = ":_idcl";
    private static final String HIDDEN_COMMAND_INPUTS_SET_ATTR = UIForm.class.getName() + ".org.apache.myfaces.HIDDEN_COMMAND_INPUTS_SET";
    private static final String MYFACES_HIDDEN_FIELD_SUFFIX = ":_link_hidden_";
    private InternetResource[] _scripts = new InternetResource[]{this.getResource("scripts/form.js")};

    protected void doDecode(FacesContext context, UIComponent component) {
        UIForm form = (UIForm)component;
        form.setSubmitted(context.getExternalContext().getRequestParameterMap().containsKey(component.getClientId(context)));
    }

    protected InternetResource[] getScripts() {
        return this._scripts;
    }

    protected void doEncodeBegin(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        String clientId = component.getClientId(context);
        this.getUtils().encodeBeginForm(context, component, writer, clientId);
        this.getUtils().encodeAttribute(context, component, "style");
        this.getUtils().encodeAttribute(context, component, "class");
        this.getUtils().encodePassThru(context, component);
        context.getExternalContext().getRequestMap().put(FORM_HAS_COMMAND_LINK_ATTR, clientId);
    }

    protected void doEncodeEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        String clientId = component.getClientId(context);
        this.renderHiddenInputField(writer, clientId, clientId);
        this.renderHiddenInputField(writer, "autoScroll", null);
        HashSet<String> hiddenFields = new HashSet<String>();
        hiddenFields.add(clientId + HIDDEN_FIELD_SUFFIX);
        hiddenFields.add(clientId + MYFACES_HIDDEN_FIELD_SUFFIX);
        Set set = (Set)component.getAttributes().get(HIDDEN_COMMAND_INPUTS_SET_ATTR);
        if (set != null) {
            hiddenFields.addAll(set);
        }
        this.renderHiddenCommandFormParams(writer, hiddenFields);
        String target = component instanceof HtmlForm ? ((HtmlForm)component).getTarget() : (String)component.getAttributes().get("target");
        this.renderClearHiddenCommandFormParamsFunction(writer, component.getClientId(context), hiddenFields, target);
        this.getUtils().encodeEndForm(context, writer);
        context.getExternalContext().getRequestMap().put(FORM_HAS_COMMAND_LINK_ATTR, NO_COMMAND_LINK_FOUND_VALUE);
    }

    protected Class getComponentClass() {
        return UIForm.class;
    }

    public void renderHiddenCommandFormParams(ResponseWriter writer, Set formParams) throws IOException {
        Iterator it = formParams.iterator();
        while (it.hasNext()) {
            Object name = it.next();
            this.renderHiddenInputField(writer, name, null);
        }
    }

    public void renderHiddenInputField(ResponseWriter writer, Object name, Object value) throws IOException {
        writer.startElement("input", null);
        writer.writeAttribute("type", RendererUtils.HTML.INPUT_TYPE_HIDDEN, null);
        writer.writeAttribute("name", name, null);
        if (value != null) {
            writer.writeAttribute("value", value, null);
        }
        writer.endElement("input");
    }

    public void renderClearHiddenCommandFormParamsFunction(ResponseWriter writer, String formName, Set dummyFormParams, String formTarget) throws IOException {
        String functionName = this.getClearHiddenCommandFormParamsFunctionName(formName);
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        StringBuffer script = new StringBuffer();
        script.append("function ");
        script.append(functionName);
        script.append("() {\n");
        script.append(FORM_CLEAR_FUNCTION_NAME);
        script.append("('");
        script.append(formName);
        script.append("','");
        if (formTarget != null && formTarget.length() > 0) {
            script.append(formTarget);
        }
        script.append("'");
        if (dummyFormParams != null) {
            script.append(",[");
            Iterator it = dummyFormParams.iterator();
            while (it.hasNext()) {
                script.append('\'');
                script.append((String)it.next());
                script.append('\'');
                if (!it.hasNext()) continue;
                script.append(',');
            }
            script.append("]");
        }
        script.append(");");
        script.append("\n}");
        script.append("\n");
        script.append("function ").append("clearFormHiddenParams_").append(this.getValidJavascriptName(formName));
        script.append("(){").append(functionName).append("();}\n");
        script.append(functionName);
        script.append("();");
        writer.writeText((Object)script.toString(), null);
        writer.endElement("script");
    }

    public String getClearHiddenCommandFormParamsFunctionName(String formName) {
        return "clear_" + this.getValidJavascriptName(formName);
    }

    public String getValidJavascriptName(String s) {
        StringBuffer buf = null;
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            byte[] bytes;
            char c = s.charAt(i);
            if (Character.isLetterOrDigit(c)) {
                if (buf == null) continue;
                buf.append(c);
                continue;
            }
            if (buf == null) {
                buf = new StringBuffer(s.length() + 10);
                buf.append(s.substring(0, i));
            }
            buf.append('_');
            if (c < '\u0010') {
                buf.append('0');
            }
            if (c < '\u0080') {
                buf.append(Integer.toHexString(c).toUpperCase());
                continue;
            }
            try {
                bytes = Character.toString(c).getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            for (int j = 0; j < bytes.length; ++j) {
                int intVal = bytes[j];
                if (intVal < 0) {
                    intVal = 256 + intVal;
                } else if (intVal < 16) {
                    buf.append('0');
                }
                buf.append(Integer.toHexString(intVal).toUpperCase());
            }
        }
        return buf == null ? s : buf.toString();
    }
}

