/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.framework.util.javascript;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.ajax4jsf.framework.util.javascript.JSEncoder;
import org.ajax4jsf.framework.util.javascript.ScriptString;

public class ScriptUtils {
    private ScriptUtils() {
    }

    public static String toScript(Object obj) {
        if (obj instanceof ScriptString) {
            return ((ScriptString)obj).toScript();
        }
        if (obj instanceof Collection) {
            Collection collection = (Collection)obj;
            StringBuffer ret = new StringBuffer("[");
            boolean first = true;
            Iterator iter = collection.iterator();
            while (iter.hasNext()) {
                Object element = iter.next();
                if (!first) {
                    ret.append(',');
                }
                ret.append(ScriptUtils.toScript(element));
                first = false;
            }
            return ret.append(']').toString();
        }
        if (obj instanceof Map) {
            Map map = (Map)obj;
            StringBuffer ret = new StringBuffer("{");
            boolean first = true;
            Iterator iter = map.keySet().iterator();
            while (iter.hasNext()) {
                Object key = iter.next();
                if (!first) {
                    ret.append(',');
                }
                ret.append(ScriptUtils.toScript(key));
                ret.append(':').append(ScriptUtils.toScript(map.get(key)));
                first = false;
            }
            return ret.append('}').toString();
        }
        if (obj instanceof Number || obj instanceof Boolean) {
            return obj.toString();
        }
        if (null == obj) {
            return "null";
        }
        StringBuffer ret = new StringBuffer("'");
        ScriptUtils.addEncoded(ret, obj);
        return ret.append('\'').toString();
    }

    public static void addEncoded(StringBuffer buff, Object obj) {
        JSEncoder encoder = new JSEncoder();
        char[] chars = obj.toString().toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (!encoder.compile(c)) {
                buff.append(encoder.encode(c));
                continue;
            }
            buff.append(c);
        }
    }
}

