/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.framework.util.image.imageio;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DirectColorModel;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageInputStream;
import org.ajax4jsf.framework.util.image.ImageGenerator;
import org.ajax4jsf.framework.util.image.ImageWrapper;

public class ImageIOGenerator
extends ImageGenerator {
    public Image read(String filename) throws IOException {
        return ImageIO.read(new File(filename));
    }

    public Image read(URL url) throws IOException {
        return ImageIO.read(url);
    }

    public Image read(byte[] src) throws IOException {
        return ImageIO.read(new ByteArrayInputStream(src));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(ImageWrapper wrapper, String filename, float quality, boolean alpha) throws IOException {
        int pos = filename.lastIndexOf(46);
        if (pos != -1) {
            String extension = filename.substring(pos + 1, filename.length()).toLowerCase();
            ImageWriter writer = null;
            Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName(extension);
            if (iter.hasNext()) {
                writer = iter.next();
            }
            if (writer != null) {
                ImageInputStream ios = null;
                try {
                    BufferedImage bi = wrapper.getBufferedImage();
                    File file = new File(filename);
                    if (file.exists()) {
                        file.delete();
                    }
                    ios = ImageIO.createImageOutputStream(file);
                    writer.setOutput(ios);
                    ImageWriteParam param = writer.getDefaultWriteParam();
                    if (param.canWriteCompressed() && (double)quality >= 0.0 && (double)quality <= 1.0) {
                        param.setCompressionMode(2);
                        param.setCompressionQuality(quality);
                    }
                    if (param.canWriteProgressive()) {
                        param.setProgressiveMode(0);
                    }
                    if (bi.getType() == 2 && !alpha) {
                        WritableRaster raster = bi.getRaster();
                        WritableRaster newRaster = raster.createWritableChild(0, 0, wrapper.getWidth(), wrapper.getHeight(), 0, 0, new int[]{0, 1, 2});
                        DirectColorModel cm = (DirectColorModel)bi.getColorModel();
                        DirectColorModel newCM = new DirectColorModel(cm.getPixelSize(), cm.getRedMask(), cm.getGreenMask(), cm.getBlueMask());
                        BufferedImage rgbBuffer = new BufferedImage(newCM, newRaster, false, null);
                        writer.write(null, new IIOImage(rgbBuffer, null, null), param);
                    } else {
                        writer.write(null, new IIOImage(bi, null, null), param);
                    }
                }
                finally {
                    if (ios != null) {
                        ios.close();
                    }
                    writer.dispose();
                }
            }
        }
    }
}

