/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.framework.renderer;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.faces.application.Application;
import javax.faces.application.StateManager;
import javax.faces.application.ViewHandler;
import javax.faces.component.ActionSource;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.UIParameter;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.servlet.http.HttpServletResponse;
import org.ajax4jsf.ajax.UILoadBundle;
import org.ajax4jsf.framework.ajax.AjaxComponent;
import org.ajax4jsf.framework.ajax.AjaxContainer;
import org.ajax4jsf.framework.ajax.AjaxContext;
import org.ajax4jsf.framework.ajax.AjaxRegionListener;
import org.ajax4jsf.framework.ajax.AjaxSupport;
import org.ajax4jsf.framework.ajax.AjaxViewRoot;
import org.ajax4jsf.framework.ajax.JavaScriptParameter;
import org.ajax4jsf.framework.renderer.RendererUtils;
import org.ajax4jsf.framework.util.javascript.JSFunction;
import org.ajax4jsf.framework.util.javascript.JSFunctionDefinition;
import org.ajax4jsf.framework.util.javascript.JSReference;
import org.ajax4jsf.framework.util.message.Messages;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AjaxRendererUtils {
    public static final String AJAX_FUNCTION_NAME = "A4J.AJAX.Submit";
    public static final String STATUS_ATTR_NAME = "status";
    public static final String ONCOMPLETE_ATTR_NAME = "oncomplete";
    public static final String LIMITTOLIST_ATTR_NAME = "limitToList";
    private static Log log = LogFactory.getLog((Class)AjaxRendererUtils.class);
    public static final String AJAX_REGIONS_ATTRIBUTE = "reRender";
    private static final Class OBJECT_ARRAY_CLASS = new Object[0].getClass();
    public static final String SEQUENCE_PARAM = "jsf_sequence";
    private static final String VALUE_ATTR = "value";
    static final String AJAX_AREAS_RENDERED = "org.ajax4jsf.areas.rendered";
    private static final String AJAX_SINGLE_ATTR = "ajaxSingle";
    public static final String AJAX_QUEUE_ATTR = "eventsQueue";
    public static final String AJAX_DELAY_ATTR = "requestDelay";

    private AjaxRendererUtils() {
    }

    public static StringBuffer buildOnClick(UIComponent uiComponent, FacesContext facesContext) {
        return AjaxRendererUtils.buildOnEvent(uiComponent, facesContext, "onclick");
    }

    public static StringBuffer buildOnEvent(UIComponent uiComponent, FacesContext facesContext, String eventName) {
        AjaxSupport support;
        String commandOnEvent;
        StringBuffer onEvent = new StringBuffer();
        if (null != eventName && (commandOnEvent = (String)uiComponent.getAttributes().get(eventName)) != null) {
            onEvent.append(commandOnEvent);
            onEvent.append(';');
        }
        JSFunction ajaxFunction = AjaxRendererUtils.buildAjaxFunction(uiComponent, facesContext);
        ajaxFunction.addParameter(AjaxRendererUtils.buildEventOptions(facesContext, uiComponent));
        ajaxFunction.appendScript(onEvent);
        if (uiComponent instanceof AjaxSupport && (support = (AjaxSupport)uiComponent).isDisableDefault()) {
            onEvent.append("; return false;");
        }
        log.debug((Object)Messages.getMessage(Messages.BUILD_ONCLICK_INFO, uiComponent.getId(), onEvent.toString()));
        return onEvent;
    }

    public static Map buildEventOptions(FacesContext facesContext, UIComponent uiComponent) {
        String encoding;
        Integer requestDelay;
        String queue;
        String status;
        String oncomplete;
        String clientId = uiComponent.getClientId(facesContext);
        Map componentAttributes = uiComponent.getAttributes();
        HashMap<String, Object> options = new HashMap<String, Object>();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        UIForm form = AjaxRendererUtils.getNestingForm(uiComponent);
        boolean input = uiComponent instanceof AjaxSupport && uiComponent.getParent() instanceof EditableValueHolder || uiComponent instanceof EditableValueHolder;
        boolean action = uiComponent instanceof AjaxSupport && uiComponent.getParent() instanceof ActionSource || uiComponent instanceof ActionSource;
        boolean ajaxSingle = Boolean.TRUE.equals(componentAttributes.get(AJAX_SINGLE_ATTR));
        if ((null == form || ajaxSingle) && input) {
            options.put("control", JSReference.THIS);
        }
        String controlName = clientId;
        String controlValue = clientId;
        parameters.put(controlName, controlValue);
        if (ajaxSingle) {
            options.put("single", JSReference.TRUE);
        }
        Iterator it = uiComponent.getChildren().iterator();
        while (it.hasNext()) {
            UIComponent child = (UIComponent)it.next();
            if (!(child instanceof UIParameter)) continue;
            String name = ((UIParameter)child).getName();
            Object value = ((UIParameter)child).getValue();
            if (null == name) {
                throw new IllegalArgumentException(Messages.getMessage(Messages.UNNAMED_PARAMETER_ERROR, uiComponent.getClientId(facesContext)));
            }
            boolean escape = true;
            if (child instanceof JavaScriptParameter) {
                JavaScriptParameter actionParam = (JavaScriptParameter)child;
                boolean bl = escape = !actionParam.isNoEscape();
            }
            if (escape) {
                parameters.put(name, value);
                continue;
            }
            parameters.put(name, new JSReference(value.toString()));
        }
        if (!parameters.isEmpty()) {
            options.put("parameters", parameters);
        }
        if (AjaxRendererUtils.isAjaxLimitToList(uiComponent)) {
            Set ajaxAreas = AjaxRendererUtils.getAjaxAreas(uiComponent);
            HashSet<String> areasIds = new HashSet<String>();
            if (null != ajaxAreas) {
                Iterator iter = ajaxAreas.iterator();
                while (iter.hasNext()) {
                    String id = (String)iter.next();
                    UIComponent comp = uiComponent.findComponent(id);
                    if (null != comp) {
                        areasIds.add(comp.getClientId(facesContext));
                        continue;
                    }
                    areasIds.add(id);
                }
            }
            options.put("affected", areasIds);
        }
        if (null != (oncomplete = AjaxRendererUtils.getAjaxOncomplete(uiComponent))) {
            JSFunctionDefinition function = new JSFunctionDefinition("request");
            function.addParameter("event");
            function.addParameter("data");
            function.addToBody(oncomplete);
            options.put(ONCOMPLETE_ATTR_NAME, function);
        }
        if (null != (status = AjaxRendererUtils.getAjaxStatus(uiComponent))) {
            options.put(STATUS_ATTR_NAME, status);
        }
        if (null != (queue = (String)componentAttributes.get(AJAX_QUEUE_ATTR))) {
            options.put(AJAX_QUEUE_ATTR, queue);
        }
        if (null != (requestDelay = (Integer)componentAttributes.get(AJAX_DELAY_ATTR)) && requestDelay > 0) {
            options.put(AJAX_DELAY_ATTR, requestDelay);
            if (null == queue) {
                options.put(AJAX_QUEUE_ATTR, clientId);
            }
        }
        if (null != (encoding = (String)uiComponent.getAttributes().get("encoding"))) {
            options.put("encoding", encoding);
        }
        return options;
    }

    public static JSFunction buildAjaxFunction(UIComponent uiComponent, FacesContext facesContext) {
        JSFunction ajaxFunction = AjaxRendererUtils.buildAjaxFunction(uiComponent, facesContext, AJAX_FUNCTION_NAME);
        ajaxFunction.addParameter(new JSReference("event"));
        return ajaxFunction;
    }

    public static JSFunction buildAjaxFunction(UIComponent uiComponent, FacesContext facesContext, String functionName) {
        JSFunction ajaxFunction = new JSFunction(functionName);
        UIComponent nestingContainer = (UIComponent)AjaxRendererUtils.findAjaxContainer(facesContext, uiComponent);
        ajaxFunction.addParameter(nestingContainer.getClientId(facesContext));
        UIForm nestingForm = AjaxRendererUtils.getNestingForm(uiComponent);
        if (null == nestingForm) {
            ajaxFunction.addParameter(AjaxRendererUtils.getActionUrl(facesContext));
        } else {
            ajaxFunction.addParameter(nestingForm.getClientId(facesContext));
        }
        return ajaxFunction;
    }

    public static Set getAjaxAreas(UIComponent uiComponent) {
        Object areas = uiComponent instanceof AjaxComponent ? ((AjaxComponent)uiComponent).getReRender() : uiComponent.getAttributes().get(AJAX_REGIONS_ATTRIBUTE);
        return AjaxRendererUtils.asSet(areas);
    }

    public static Set asSet(Object valueToSet) {
        if (null != valueToSet) {
            if (valueToSet instanceof Set) {
                return (Set)valueToSet;
            }
            if (valueToSet instanceof Collection) {
                return new HashSet((Collection)valueToSet);
            }
            if (OBJECT_ARRAY_CLASS.isAssignableFrom(valueToSet.getClass())) {
                return new HashSet<Object>(Arrays.asList((Object[])valueToSet));
            }
            if (valueToSet instanceof String) {
                String areasString = (String)valueToSet;
                if (areasString.indexOf(",") > 0) {
                    return new HashSet<String>(Arrays.asList(areasString.trim().split("(\\s)*,(\\s)*")));
                }
                HashSet<String> areasSet = new HashSet<String>(5);
                areasSet.add(areasString.trim());
                return areasSet;
            }
        }
        return null;
    }

    public static String getAjaxStatus(UIComponent component) {
        String statusId = component instanceof AjaxComponent ? ((AjaxComponent)component).getStatus() : (String)component.getAttributes().get(STATUS_ATTR_NAME);
        if (null != statusId) {
            UIComponent status = null;
            try {
                for (UIComponent currentParent = component; currentParent != null && (status = currentParent.findComponent(statusId)) == null; currentParent = currentParent.getParent()) {
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (null != status) {
                statusId = status.getClientId(FacesContext.getCurrentInstance());
            } else {
                log.warn((Object)Messages.getMessage(Messages.AJAX_STATUS_COMPONENT_NOT_FOWND_WARNING, component.getId()));
            }
        }
        return statusId;
    }

    public static String getAjaxOncomplete(UIComponent component) {
        if (component instanceof AjaxComponent) {
            return ((AjaxComponent)component).getOncomplete();
        }
        return (String)component.getAttributes().get(ONCOMPLETE_ATTR_NAME);
    }

    public static boolean isAjaxLimitToList(UIComponent component) {
        boolean result = false;
        if (component instanceof AjaxComponent) {
            result = ((AjaxComponent)component).isLimitToList();
        } else {
            try {
                result = (Boolean)component.getAttributes().get(LIMITTOLIST_ATTR_NAME);
            }
            catch (NullPointerException e) {
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return result;
    }

    public static String getAbsoluteId(UIComponent component) {
        if (component == null) {
            throw new NullPointerException(Messages.getMessage(Messages.COMPONENT_NULL_ERROR_2));
        }
        StringBuffer idBuf = new StringBuffer();
        idBuf.append(component.getId());
        UIComponent parent = component;
        while ((parent = parent.getParent()) != null) {
            if (!(parent instanceof NamingContainer)) continue;
            idBuf.insert(0, ':');
            idBuf.insert(0, parent.getId());
        }
        idBuf.insert(0, ':');
        log.debug((Object)Messages.getMessage(Messages.CALCULATE_COMPONENT_ID_INFO, component.getId(), idBuf.toString()));
        return idBuf.toString();
    }

    public static UIForm getNestingForm(UIComponent component) {
        UIComponent parent;
        for (parent = component.getParent(); parent != null && !(parent instanceof UIForm); parent = parent.getParent()) {
        }
        UIForm nestingForm = null;
        if (parent != null) {
            nestingForm = (UIForm)parent;
        }
        return nestingForm;
    }

    protected static String getActionUrl(FacesContext facesContext) {
        ViewHandler viewHandler = facesContext.getApplication().getViewHandler();
        String viewId = facesContext.getViewRoot().getViewId();
        return facesContext.getExternalContext().encodeActionURL(viewHandler.getActionURL(facesContext, viewId));
    }

    public static AjaxContainer findAjaxContainer(FacesContext facesContext, UIComponent uiComponent) {
        UIComponent parent;
        for (parent = uiComponent.getParent(); parent != null && !(parent instanceof AjaxContainer); parent = parent.getParent()) {
        }
        AjaxContainer nestingContainer = null;
        if (parent != null) {
            nestingContainer = (AjaxContainer)parent;
        } else if (facesContext.getViewRoot() instanceof AjaxViewRoot) {
            nestingContainer = (AjaxContainer)facesContext.getViewRoot();
        }
        return nestingContainer;
    }

    public static AjaxContainer getSubmittedAjaxContainer(FacesContext context, AjaxContainer container) {
        UIViewRoot root = context.getViewRoot();
        if (root instanceof AjaxViewRoot) {
            AjaxViewRoot ajaxRoot = (AjaxViewRoot)root;
            UIComponent submitted = ajaxRoot.getSubmittedRegion(context);
            if (null == submitted) {
                return ajaxRoot;
            }
            return (AjaxContainer)submitted;
        }
        return container;
    }

    private static Integer getViewSequence(FacesContext facescontext) {
        Map map = facescontext.getExternalContext().getRequestMap();
        Integer sequence = (Integer)map.get(SEQUENCE_PARAM);
        if (sequence == null) {
            sequence = new Integer(1);
            map.put(SEQUENCE_PARAM, sequence);
        }
        return sequence;
    }

    public static boolean encodeAreas(FacesContext context, UIComponent component) throws IOException {
        AjaxContainer ajax = AjaxRendererUtils.getSubmittedAjaxContainer(context, (AjaxContainer)component);
        if (null != ajax) {
            ExternalContext externalContext = context.getExternalContext();
            Map requestMap = externalContext.getRequestMap();
            if (ajax.isSubmitted() && null == requestMap.get(AJAX_AREAS_RENDERED)) {
                AjaxContext ajaxContext = AjaxContext.getCurrentInstance(context);
                Set rendered = ajaxContext.getAjaxRenderedAreas();
                StringBuffer senderString = new StringBuffer();
                ResponseWriter out = context.getResponseWriter();
                out.startElement("meta", component);
                out.writeAttribute("name", (Object)"Ajax-Update-Ids", null);
                Iterator it = rendered.iterator();
                while (it.hasNext()) {
                    String id = (String)it.next();
                    senderString.append(id);
                    if (!it.hasNext()) continue;
                    senderString.append(',');
                }
                out.writeAttribute("content", (Object)senderString, null);
                out.endElement("meta");
                out.startElement("span", component);
                out.writeAttribute("id", (Object)"ajax-update-ids", null);
                AjaxRendererUtils.writeState(context);
                out.endElement("span");
                out.startElement("meta", component);
                out.writeAttribute("id", (Object)"Ajax-Response", null);
                out.writeAttribute("name", (Object)"Ajax-Response", null);
                out.writeAttribute("content", (Object)"true", null);
                out.endElement("meta");
                Object response = externalContext.getResponse();
                if (response instanceof HttpServletResponse) {
                    HttpServletResponse httpResponse = (HttpServletResponse)response;
                    httpResponse.setHeader("Ajax-Update-Ids", senderString.toString());
                    httpResponse.setHeader("Ajax-Response", "true");
                } else {
                    try {
                        Method setHeadergMethod = response.getClass().getMethod("setHeader", String.class, String.class);
                        setHeadergMethod.invoke(response, "Ajax-Update-Ids", senderString.toString());
                        setHeadergMethod.invoke(response, "Ajax-Response", "true");
                    }
                    catch (Exception e) {
                        log.error((Object)Messages.getMessage(Messages.DETECTING_ENCODING_DISABLED_ERROR));
                        log.error((Object)Messages.getMessage(Messages.OBTAIN_RESPONSE_SET_HEADER_ERROR, e));
                    }
                }
                Map responseDataMap = ajaxContext.getResponseDataMap();
                Iterator dataIterator = responseDataMap.keySet().iterator();
                while (dataIterator.hasNext()) {
                    Object dataKey = dataIterator.next();
                    out.startElement("span", component);
                    out.writeAttribute("id", dataKey, null);
                    out.write(responseDataMap.get(dataKey).toString());
                    out.endElement("span");
                }
                if (ajaxContext.isSelfRender()) {
                    AjaxRendererUtils.saveViewState(context, out);
                }
                requestMap.put(AJAX_AREAS_RENDERED, "true");
                return true;
            }
        }
        return false;
    }

    public static void saveViewState(FacesContext context, ResponseWriter writer) throws IOException {
        try {
            Application.class.getMethod("getExpressionFactory", null);
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        StateManager stateManager = context.getApplication().getStateManager();
        StateManager.SerializedView serializedView = stateManager.saveSerializedView(context);
        if (null != serializedView) {
            StringWriter bufWriter = new StringWriter();
            ResponseWriter cloneWithWriter = writer.cloneWithWriter((Writer)bufWriter);
            context.setResponseWriter(cloneWithWriter);
            stateManager.writeState(context, serializedView);
            cloneWithWriter.flush();
            if (bufWriter.getBuffer().length() > 0) {
                context.getExternalContext().getRequestMap().put("org.ajax4jsf.view.serializedstate", bufWriter.toString());
            }
        }
    }

    public static void writeState(FacesContext context) throws IOException {
        if (!context.getApplication().getStateManager().isSavingStateInClient(context)) {
            ResponseWriter writer = context.getResponseWriter();
            writer.startElement("input", null);
            writer.writeAttribute("type", RendererUtils.HTML.INPUT_TYPE_HIDDEN, null);
            writer.writeAttribute("name", (Object)SEQUENCE_PARAM, null);
            writer.writeAttribute(VALUE_ATTR, (Object)AjaxRendererUtils.getViewSequence(context), null);
            writer.endElement("input");
        }
        context.getApplication().getViewHandler().writeState(context);
    }

    public static void encodeAjaxBegin(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter out = context.getResponseWriter();
        out.startElement("html", component);
        Locale locale = context.getViewRoot().getLocale();
        out.writeAttribute("lang", (Object)locale.toString(), "lang");
        out.startElement("body", component);
    }

    public static void encodeAjaxEnd(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter out = context.getResponseWriter();
        if (AjaxRendererUtils.encodeAreas(context, component)) {
            out.endElement("body");
            out.endElement("html");
        }
    }

    public static boolean isAjaxRequest(FacesContext context) {
        UIViewRoot root = context.getViewRoot();
        if (root instanceof AjaxViewRoot) {
            return ((AjaxViewRoot)root).isAjaxRequest();
        }
        return context.getExternalContext().getRequestParameterMap().containsKey("AJAXREQUEST");
    }

    public static boolean isAjaxRequest() {
        return AjaxRendererUtils.isAjaxRequest(FacesContext.getCurrentInstance());
    }

    public static void addRegionsFromComponent(UIComponent component, FacesContext context) {
        Set ajaxRegions = AjaxRendererUtils.getAjaxAreas(component);
        if (AjaxRegionListener.log.isDebugEnabled()) {
            AjaxRegionListener.log.debug((Object)Messages.getMessage(Messages.INVOKE_AJAX_REGION_LISTENER, component.getId()));
        }
        AjaxRendererUtils.addRegionByName(context, component, ajaxRegions);
    }

    public static void addRegionByName(FacesContext context, UIComponent component, Object ajaxRegions) {
        if (ajaxRegions != null) {
            AjaxContainer view = AjaxRendererUtils.getSubmittedAjaxContainer(context, null);
            if (null != view) {
                if (ajaxRegions instanceof Collection) {
                    Set areasToRender = view.getAjaxAreasToRender();
                    Iterator iter = ((Collection)ajaxRegions).iterator();
                    while (iter.hasNext()) {
                        String id = iter.next().toString();
                        areasToRender.add(AjaxRendererUtils.convertId(component, id));
                    }
                } else {
                    view.addAjaxArea(AjaxRendererUtils.convertId(component, ajaxRegions.toString()));
                }
            } else {
                AjaxRegionListener.log.warn((Object)Messages.getMessage(Messages.APPENDING_AJAX_REGION_TO_NON_AJAX_CONTAINER_WARNING));
            }
        }
    }

    public static String convertId(UIComponent component, String id) {
        UIComponent target;
        if (id.charAt(0) == ':') {
            return id;
        }
        if (null != component && null != (target = component.findComponent(id))) {
            return AjaxRendererUtils.getAbsoluteId(target);
        }
        return id;
    }

    public static void loadBundles(FacesContext context) {
        AjaxRendererUtils.loadBundles(context, (UIComponent)context.getViewRoot());
    }

    private static void loadBundles(FacesContext context, UIComponent component) {
        UIComponent child;
        Iterator<Object> iter = component.getChildren().iterator();
        while (iter.hasNext()) {
            child = (UIComponent)iter.next();
            AjaxRendererUtils.loadCildBundles(context, child);
        }
        iter = component.getFacets().values().iterator();
        while (iter.hasNext()) {
            child = (UIComponent)iter.next();
            AjaxRendererUtils.loadCildBundles(context, child);
        }
    }

    private static void loadCildBundles(FacesContext context, UIComponent child) {
        if (child instanceof UILoadBundle) {
            try {
                child.encodeBegin(context);
            }
            catch (IOException iOException) {}
        } else {
            AjaxRendererUtils.loadBundles(context, child);
        }
    }
}

