/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.framework.renderer;

import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.servlet.ServletResponse;
import org.ajax4jsf.framework.ajax.AjaxContainer;
import org.ajax4jsf.framework.ajax.AjaxContext;
import org.ajax4jsf.framework.ajax.AjaxViewRoot;
import org.ajax4jsf.framework.renderer.AjaxRendererUtils;
import org.ajax4jsf.framework.skin.SkinFactory;
import org.ajax4jsf.framework.util.message.Messages;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AjaxRenderPhaseListener
implements PhaseListener {
    private static final long serialVersionUID = -4087936963051339868L;
    private static final Log log = LogFactory.getLog((Class)AjaxRenderPhaseListener.class);

    public void afterPhase(PhaseEvent event) {
        FacesContext context = event.getFacesContext();
        AjaxContext ajaxContext = AjaxContext.getCurrentInstance(context);
        if (ajaxContext.isAjaxRequest() && null == context.getExternalContext().getRequestMap().get("org.ajax4jsf.areas.rendered")) {
            AjaxContainer ajax;
            if (log.isDebugEnabled()) {
                log.debug((Object)Messages.getMessage(Messages.AJAX_RESPONSE_NOT_RENDERED_INFO));
            }
            if (null != (ajax = AjaxRendererUtils.getSubmittedAjaxContainer(context, null))) {
                ajaxContext.setSelfRender(true);
                ServletResponse response = (ServletResponse)context.getExternalContext().getResponse();
                try {
                    response.reset();
                }
                catch (Exception e) {
                    // empty catch block
                }
                ajaxContext.renderAjaxRegion(context, (UIComponent)ajax, true);
                return;
            }
        }
        ajaxContext.processHeadResources(context);
    }

    public void beforePhase(PhaseEvent event) {
        AjaxViewRoot ajaxRoot;
        FacesContext context = event.getFacesContext();
        UIViewRoot root = context.getViewRoot();
        log.debug((Object)Messages.getMessage(Messages.ENTER_BEFORE_RENDER_VIEW_PHASE, root.getViewId(), root.getRenderKitId()));
        String renderKitId = null;
        try {
            renderKitId = SkinFactory.getInstance().getSkin(context).getRenderKitId(context);
        }
        catch (Exception e) {
            log.error((Object)"Exception on get current Skin ", (Throwable)e);
        }
        if (null != renderKitId) {
            log.debug((Object)Messages.getMessage(Messages.SET_RENDER_KIT_ID_INFO, renderKitId));
            root.setRenderKitId(renderKitId);
        }
        if (root instanceof AjaxViewRoot && (ajaxRoot = (AjaxViewRoot)root).isAjaxRequest() && null == context.getExternalContext().getRequestMap().get("org.ajax4jsf.areas.rendered")) {
            this.processAjaxRender(context, ajaxRoot);
        }
    }

    private void processAjaxRender(FacesContext context, AjaxViewRoot ajaxRoot) {
        AjaxContext.getCurrentInstance(context).setViewIdHolder(null);
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage(Messages.PROCESS_AJAX_EVENTS_INFO));
        }
        ajaxRoot.broadcastAjaxEvents(context);
    }

    public PhaseId getPhaseId() {
        return PhaseId.RENDER_RESPONSE;
    }

    protected boolean isValueReference(String value) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        int start = value.indexOf("#{");
        if (start < 0) {
            return false;
        }
        int end = value.lastIndexOf(125);
        return end >= 0 && start < end;
    }
}

