/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.framework.ajax.xmlfilter;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.ajax4jsf.io.FastBufferOutputStream;
import org.ajax4jsf.io.FastBufferWriter;

public class CacheContent
implements Serializable {
    private static final long serialVersionUID = 8120940486890871176L;
    private transient FastBufferOutputStream outputStream;
    private transient FastBufferWriter stringOutputWriter;
    private transient PrintWriter servletWriter;
    private transient ServletOutputStream servletStream;
    private byte[] content = null;
    private String writerContent = null;
    boolean filledOutputStream = false;
    boolean filledOutputWriter = false;
    private Map headers = new HashMap();
    private String contentType;

    public void send(HttpServletResponse response) throws IOException {
        if (this.filledOutputStream) {
            ServletOutputStream out = response.getOutputStream();
            if (this.content != null) {
                out.write(this.content);
            } else {
                this.outputStream.writeTo((OutputStream)out);
            }
        } else if (this.filledOutputWriter) {
            PrintWriter out = response.getWriter();
            if (null != this.writerContent) {
                ((Writer)out).write(this.writerContent);
            } else {
                this.stringOutputWriter.writeTo(out);
            }
        }
    }

    public void sendHeaders(HttpServletResponse response) {
        Iterator iter = this.headers.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry element = iter.next();
            String header = (String)element.getKey();
            if (element.getValue() instanceof Long) {
                Long time = (Long)element.getValue();
                response.setDateHeader(header, time.longValue());
            } else if (element.getValue() instanceof Integer) {
                Integer value = (Integer)element.getValue();
                response.setIntHeader(header, value.intValue());
            } else {
                response.setHeader(header, (String)element.getValue());
            }
            if (this.filledOutputStream) {
                response.setIntHeader("Content-Lenght", this.outputStream.getLength());
            }
            if (null == this.contentType) continue;
            response.setContentType(this.contentType);
        }
    }

    public void setDateHeader(String name, long value) {
        this.headers.put(name, new Long(value));
    }

    public void setHeader(String name, String value) {
        this.headers.put(name, value);
    }

    public void setIntHeader(String name, int value) {
        this.headers.put(name, new Integer(value));
    }

    public OutputStream getOutputStream(final OutputStream responseStream) {
        if (null == this.servletStream) {
            this.outputStream = new FastBufferOutputStream(1024);
            this.servletStream = new ServletOutputStream(){

                public void close() throws IOException {
                    CacheContent.this.filledOutputStream = true;
                    responseStream.close();
                    CacheContent.access$002(CacheContent.this, null);
                }

                public void flush() throws IOException {
                    responseStream.flush();
                }

                public void write(byte[] b, int off, int len) throws IOException {
                    CacheContent.this.outputStream.write(b, off, len);
                    responseStream.write(b, off, len);
                }

                public void write(byte[] b) throws IOException {
                    CacheContent.this.outputStream.write(b);
                    responseStream.write(b);
                }

                public void write(int b) throws IOException {
                    CacheContent.this.outputStream.write(b);
                    responseStream.write(b);
                }
            };
        }
        return this.servletStream;
    }

    public PrintWriter getWriter(final Writer responseWriter) {
        if (null == this.servletWriter) {
            this.stringOutputWriter = new FastBufferWriter(1024);
            Writer out = new Writer(){

                public void write(char[] cbuf, int off, int len) throws IOException {
                    responseWriter.write(cbuf, off, len);
                    CacheContent.this.stringOutputWriter.write(cbuf, off, len);
                }

                public void flush() throws IOException {
                    responseWriter.flush();
                }

                public void close() throws IOException {
                    responseWriter.close();
                    CacheContent.this.filledOutputWriter = true;
                    CacheContent.this.writerContent = null;
                }
            };
            this.servletWriter = new PrintWriter(out);
        }
        return this.servletWriter;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getContentType() {
        return this.contentType;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        if (this.filledOutputStream) {
            if (this.outputStream != null) {
                this.content = this.outputStream.toByteArray();
            }
        } else if (this.filledOutputWriter && this.stringOutputWriter != null) {
            char[] cs = this.stringOutputWriter.toCharArray();
            this.writerContent = new String(cs);
        }
        s.defaultWriteObject();
    }

    static /* synthetic */ byte[] access$002(CacheContent x0, byte[] x1) {
        x0.content = x1;
        return x1;
    }
}

