/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.proxy.container;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewConstructor;
import javassist.CtNewMethod;
import javassist.Modifier;
import javassist.SerialVersionUID;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.ClassContainer;
import org.jboss.aop.introduction.InterfaceIntroduction;
import org.jboss.aop.proxy.container.Delegate;
import org.jboss.aop.util.JavassistMethodHashing;

public class ContainerProxyFactory {
    private static Object maplock = new Object();
    private static WeakHashMap proxyCache = new WeakHashMap();
    private static int counter = 0;

    public static ArrayList getIntroductions(Class clazz, AspectManager manager) {
        ArrayList<InterfaceIntroduction> list = new ArrayList<InterfaceIntroduction>();
        ClassContainer container = new ClassContainer("temp", manager);
        Iterator it = manager.getInterfaceIntroductions().values().iterator();
        while (it.hasNext()) {
            InterfaceIntroduction intro = (InterfaceIntroduction)it.next();
            if (!intro.matches((Advisor)container, clazz)) continue;
            list.add(intro);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Class getProxyClass(Class clazz, AspectManager manager) throws Exception {
        if (Delegate.class.isAssignableFrom(clazz)) {
            clazz = clazz.getSuperclass();
        }
        Class proxyClass = null;
        Object object = maplock;
        synchronized (object) {
            proxyClass = (Class)proxyCache.get(clazz);
            if (proxyClass == null) {
                proxyClass = ContainerProxyFactory.generateProxy(clazz, ContainerProxyFactory.getIntroductions(clazz, manager));
                proxyCache.put(clazz, proxyClass);
            }
        }
        return proxyClass;
    }

    private static void getIntroductionInterfaces(HashMap intfs, HashMap mixins, InterfaceIntroduction intro, ArrayList mixes, int idx) {
        if (intro.getInterfaces() != null) {
            for (int i = 0; i < intro.getInterfaces().length; ++i) {
                if (intfs.containsKey(intro.getInterfaces()[i]) || mixins.containsKey(intro.getInterfaces()[i])) {
                    throw new RuntimeException("cannot have an IntroductionInterface that introduces same interfaces");
                }
                intfs.put(intro.getInterfaces()[i], new Integer(idx));
            }
        }
        Iterator it = intro.getMixins().iterator();
        while (it.hasNext()) {
            InterfaceIntroduction.Mixin mixin = (InterfaceIntroduction.Mixin)it.next();
            mixes.add(mixin);
            for (int i = 0; i < mixin.getInterfaces().length; ++i) {
                if (intfs.containsKey(mixin.getInterfaces()[i]) || mixins.containsKey(mixin.getInterfaces()[i])) {
                    throw new RuntimeException("cannot have an IntroductionInterface that introduces same interfaces");
                }
                mixins.put(mixin.getInterfaces()[i], new Integer(idx));
            }
        }
    }

    public static CtClass createProxyCtClass(ArrayList mixins, Class clazz) throws Exception {
        ClassPool pool = AspectManager.instance().findClassPool(clazz.getClassLoader());
        if (pool == null) {
            throw new NullPointerException("Could not find ClassPool");
        }
        String classname = "AOPContainerProxy$" + counter++;
        CtClass template = pool.get("org.jboss.aop.proxy.container.ProxyTemplate");
        CtClass superclass = pool.get(clazz.getName());
        CtClass proxy = pool.makeClass(classname, superclass);
        CtField delegateField = template.getField("delegate");
        delegateField = new CtField(superclass, "delegate", proxy);
        delegateField.setModifiers(2);
        proxy.addField(delegateField);
        CtField mixinField = template.getField("mixins");
        mixinField = new CtField(mixinField.getType(), "mixins", proxy);
        mixinField.setModifiers(2);
        proxy.addField(mixinField);
        CtMethod getDelegate = template.getDeclaredMethod("getDelegate");
        CtMethod setDelegate = template.getDeclaredMethod("setDelegate");
        CtMethod rgetDelegate = CtNewMethod.make((CtClass)getDelegate.getReturnType(), (String)"getDelegate", (CtClass[])getDelegate.getParameterTypes(), (CtClass[])getDelegate.getExceptionTypes(), (String)"{ return delegate; }", (CtClass)proxy);
        proxy.addMethod(rgetDelegate);
        CtMethod rsetDelegate = CtNewMethod.make((CtClass)setDelegate.getReturnType(), (String)"setDelegate", (CtClass[])setDelegate.getParameterTypes(), (CtClass[])setDelegate.getExceptionTypes(), (String)("{ this.delegate = (" + clazz.getName() + ")$1; }"), (CtClass)proxy);
        proxy.addMethod(rsetDelegate);
        proxy.addInterface(pool.get("org.jboss.aop.proxy.container.Delegate"));
        proxy.addInterface(pool.get("org.jboss.aop.instrument.Untransformable"));
        CtField advisorField = template.getField("advisor");
        advisorField = new CtField(advisorField.getType(), "advisor", proxy);
        advisorField.setModifiers(2);
        proxy.addField(advisorField);
        CtMethod getAdvisor = template.getDeclaredMethod("getAdvisor");
        CtMethod setAdvisor = template.getDeclaredMethod("setAdvisor");
        CtMethod rgetAdvisor = CtNewMethod.make((CtClass)getAdvisor.getReturnType(), (String)"getAdvisor", (CtClass[])getAdvisor.getParameterTypes(), (CtClass[])getAdvisor.getExceptionTypes(), (String)"{return advisor;}", (CtClass)proxy);
        proxy.addMethod(rgetAdvisor);
        CtMethod rsetAdvisor = CtNewMethod.make((CtClass)setAdvisor.getReturnType(), (String)"setAdvisor", (CtClass[])setAdvisor.getParameterTypes(), (CtClass[])setAdvisor.getExceptionTypes(), (String)"{this.advisor = $1;}", (CtClass)proxy);
        proxy.addMethod(rsetAdvisor);
        proxy.addInterface(pool.get("org.jboss.aop.proxy.container.AspectManaged"));
        HashSet<String> addedInterfaces = new HashSet<String>();
        HashSet<Long> addedMethods = new HashSet<Long>();
        if (mixins != null) {
            String aopReturnStr;
            Long hash;
            int m;
            HashSet<Long> mixinMethods;
            CtMethod[] methods;
            CtClass intfClass;
            Integer idx;
            HashMap intfs = new HashMap();
            HashMap mixinIntfs = new HashMap();
            ArrayList mixes = new ArrayList();
            for (int i = 0; i < mixins.size(); ++i) {
                InterfaceIntroduction introduction = (InterfaceIntroduction)mixins.get(i);
                ContainerProxyFactory.getIntroductionInterfaces(intfs, mixinIntfs, introduction, mixes, i);
            }
            if (mixes.size() > 0) {
                System.out.println("mixins != null");
                CtConstructor con = CtNewConstructor.defaultConstructor((CtClass)proxy);
                con.insertAfter("mixins = new Object[" + mixes.size() + "];");
                for (int i = 0; i < mixes.size(); ++i) {
                    InterfaceIntroduction.Mixin mixin = (InterfaceIntroduction.Mixin)mixes.get(i);
                    String initializer = mixin.getConstruction() == null ? "new " + mixin.getClassName() + "()" : mixin.getConstruction();
                    con.insertAfter("mixins[" + i + "] = " + initializer + ";");
                }
                proxy.addConstructor(con);
            }
            Iterator it = mixinIntfs.keySet().iterator();
            while (it.hasNext()) {
                String intf = (String)it.next();
                idx = (Integer)mixinIntfs.get(intf);
                if (addedInterfaces.contains(intf)) {
                    throw new Exception("2 mixins are implementing the same interfaces");
                }
                intfClass = pool.get(intf);
                methods = intfClass.getMethods();
                mixinMethods = new HashSet<Long>();
                for (m = 0; m < methods.length; ++m) {
                    if (methods[m].getDeclaringClass().getName().equals("java.lang.Object") || mixinMethods.contains(hash = new Long(JavassistMethodHashing.methodHash(methods[m])))) continue;
                    if (addedMethods.contains(hash)) {
                        throw new Exception("More than one mixin has same method");
                    }
                    mixinMethods.add(hash);
                    addedMethods.add(hash);
                    aopReturnStr = methods[m].getReturnType().equals(CtClass.voidType) ? "" : "return ($r)";
                    String returnStr = methods[m].getReturnType().equals(CtClass.voidType) ? "" : "return ";
                    String args = "null";
                    if (methods[m].getParameterTypes().length > 0) {
                        args = "$args";
                    }
                    String code = "{      " + intf + " mixin = (" + intf + ")mixins[" + idx + "];" + "    org.jboss.aop.MethodJoinPoint mi = advisor.getMethodInfo(" + hash + "L); " + "    if (mi != null && mi.interceptors != (Object[])null && mi.interceptors.length > 0) { " + "       org.jboss.aop.joinpoint.MethodInvocation invocation = new org.jboss.aop.joinpoint.MethodInvocation(mi, mi.interceptors); " + "       invocation.setArguments(" + args + "); " + "       invocation.setTargetObject(mixin); " + "       " + aopReturnStr + " invocation.invokeNext(); " + "    } else { " + "   " + returnStr + " mixin." + methods[m].getName() + "($$);" + "    } " + "}";
                    CtMethod newMethod = CtNewMethod.make((CtClass)methods[m].getReturnType(), (String)methods[m].getName(), (CtClass[])methods[m].getParameterTypes(), (CtClass[])methods[m].getExceptionTypes(), (String)code, (CtClass)proxy);
                    newMethod.setModifiers(1);
                    proxy.addMethod(newMethod);
                }
                proxy.addInterface(intfClass);
                addedInterfaces.add(intfClass.getName());
            }
            it = intfs.keySet().iterator();
            while (it.hasNext()) {
                String intf = (String)it.next();
                idx = (Integer)intfs.get(intf);
                if (addedInterfaces.contains(intf)) {
                    throw new Exception("2 mixins are implementing the same interfaces");
                }
                intfClass = pool.get(intf);
                methods = intfClass.getMethods();
                mixinMethods = new HashSet();
                for (m = 0; m < methods.length; ++m) {
                    if (methods[m].getDeclaringClass().getName().equals("java.lang.Object") || mixinMethods.contains(hash = new Long(JavassistMethodHashing.methodHash(methods[m])))) continue;
                    if (addedMethods.contains(hash)) {
                        throw new Exception("More than one mixin has same method");
                    }
                    mixinMethods.add(hash);
                    addedMethods.add(hash);
                    aopReturnStr = methods[m].getReturnType().equals(CtClass.voidType) ? "" : "return ($r)";
                    String args = "null";
                    if (methods[m].getParameterTypes().length > 0) {
                        args = "$args";
                    }
                    String code = "{       org.jboss.aop.MethodJoinPoint mi = advisor.getMethodInfo(" + hash + "L); " + "    org.jboss.aop.joinpoint.MethodInvocation invocation = new org.jboss.aop.joinpoint.MethodInvocation(mi, mi.interceptors); " + "    invocation.setArguments(" + args + "); " + "    invocation.setTargetObject(mixins[" + idx + "]); " + "    " + aopReturnStr + " invocation.invokeNext(); " + "}";
                    CtMethod newMethod = CtNewMethod.make((CtClass)methods[m].getReturnType(), (String)methods[m].getName(), (CtClass[])methods[m].getParameterTypes(), (CtClass[])methods[m].getExceptionTypes(), (String)code, (CtClass)proxy);
                    newMethod.setModifiers(1);
                    proxy.addMethod(newMethod);
                }
                proxy.addInterface(intfClass);
                addedInterfaces.add(intfClass.getName());
            }
        }
        HashMap allMethods = JavassistMethodHashing.getMethodMap(superclass);
        Iterator it = allMethods.entrySet().iterator();
        while (it.hasNext()) {
            Long hash;
            Map.Entry entry = it.next();
            CtMethod m = (CtMethod)entry.getValue();
            if (!Modifier.isPublic((int)m.getModifiers()) || Modifier.isStatic((int)m.getModifiers()) || addedMethods.contains(hash = (Long)entry.getKey())) continue;
            addedMethods.add(hash);
            String aopReturnStr = m.getReturnType().equals(CtClass.voidType) ? "" : "return ($r)";
            String returnStr = m.getReturnType().equals(CtClass.voidType) ? "" : "return ";
            String args = "null";
            if (m.getParameterTypes().length > 0) {
                args = "$args";
            }
            String code = "{       org.jboss.aop.MethodJoinPoint mi = advisor.getMethodInfo(" + hash + "L); " + "    org.jboss.aop.advice.Interceptor[] interceptors = mi.interceptors; " + "    if (interceptors != (Object[])null && interceptors.length > 0) { " + "       org.jboss.aop.joinpoint.MethodInvocation invocation = new org.jboss.aop.joinpoint.MethodInvocation(mi, interceptors); " + "       invocation.setArguments(" + args + "); " + "       invocation.setTargetObject(delegate); " + "       " + aopReturnStr + " invocation.invokeNext(); " + "    } else { " + "       " + returnStr + " delegate." + m.getName() + "($$); " + "    } " + "}";
            System.out.println("adding method: " + m.getName());
            CtMethod newMethod = CtNewMethod.make((CtClass)m.getReturnType(), (String)m.getName(), (CtClass[])m.getParameterTypes(), (CtClass[])m.getExceptionTypes(), (String)code, (CtClass)proxy);
            newMethod.setModifiers(1);
            proxy.addMethod(newMethod);
        }
        SerialVersionUID.setSerialVersionUID((CtClass)proxy);
        return proxy;
    }

    private static Class generateProxy(Class clazz, ArrayList mixins) throws Exception {
        CtClass proxy = ContainerProxyFactory.createProxyCtClass(mixins, clazz);
        Class proxyClass = proxy.toClass();
        return proxyClass;
    }
}

