/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.instrument;

import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.Modifier;
import javassist.NotFoundException;
import org.jboss.aop.instrument.ConstructorExecutionTransformer;
import org.jboss.aop.instrument.Instrumentor;
import org.jboss.aop.instrument.OptimizedBehaviourInvocations;
import org.jboss.aop.instrument.OptimizedConstructorInvocations;

public class OptimizedConstructorExecutionTransformer
extends ConstructorExecutionTransformer {
    public OptimizedConstructorExecutionTransformer(Instrumentor instrumentor) {
        super(instrumentor);
    }

    protected void createWrapper(ConstructorExecutionTransformer.ConstructorTransformation trans) throws NotFoundException, CannotCompileException {
        String invocationClass = OptimizedConstructorInvocations.getOptimizedInvocationClassName(trans.getClazz(), trans.getIndex());
        if (!Modifier.isPublic((int)trans.getConstructor().getModifiers())) {
            invocationClass = invocationClass.substring(invocationClass.lastIndexOf(46) + 1);
            invocationClass = trans.getClazz().getName() + "$" + invocationClass;
        }
        String info = OptimizedConstructorExecutionTransformer.getConstructorInfoFieldName(trans.getSimpleName(), trans.getIndex());
        String code = "{     org.jboss.aop.advice.Interceptor[] interceptors = " + info + ".interceptors; " + "    if (interceptors != (org.jboss.aop.advice.Interceptor[])null) " + "    { " + "       " + invocationClass + " invocation = new " + invocationClass + "(interceptors); " + "       invocation.setConstructor(" + info + ".constructor); " + OptimizedBehaviourInvocations.setArguments(trans.getConstructor().getParameterTypes().length) + "       invocation.setAdvisor(" + "aop$classAdvisor$aop" + "); " + "       return ($r)invocation.invokeNext(); " + "    } " + "    return new " + trans.getClazz().getName() + "($$); " + "}";
        this.codifier.addPendingCode(trans.getWrapperMethod(), code);
    }

    protected void generateConstructorInfoField(CtClass clazz, CtConstructor constructor, int index) throws CannotCompileException, NotFoundException {
        super.generateConstructorInfoField(clazz, constructor, index);
        OptimizedConstructorInvocations.createOptimizedInvocationClass(this.getInstrumentor(), constructor.getDeclaringClass(), constructor, index);
    }
}

