/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.instrument;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewConstructor;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import org.jboss.aop.GeneratedClassAdvisor;
import org.jboss.aop.MethodJoinPoint;
import org.jboss.aop.advice.AdviceMethodProperties;
import org.jboss.aop.instrument.GeneratedAdvisorInstrumentor;
import org.jboss.aop.instrument.GeneratedAdvisorMethodExecutionTransformer;
import org.jboss.aop.instrument.JoinPointGenerator;
import org.jboss.aop.instrument.MethodExecutionTransformer;
import org.jboss.aop.instrument.OptimizedBehaviourInvocations;
import org.jboss.aop.instrument.TransformerCommon;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.aop.util.ReflectToJavassist;

public class MethodJoinPointGenerator
extends JoinPointGenerator {
    private static final Class INVOCATION_TYPE = MethodInvocation.class;
    private static final CtClass INVOCATION_CT_TYPE;

    public MethodJoinPointGenerator(GeneratedClassAdvisor advisor, MethodJoinPoint info) {
        super(advisor, info);
    }

    protected void initialiseJoinPointNames() {
        this.joinpointClassName = MethodJoinPointGenerator.getJoinPointClassName(this.advisedMethodName(), this.methodHash());
        this.joinpointFieldName = MethodJoinPointGenerator.getJoinPointFieldName(this.advisedMethodName(), this.methodHash());
    }

    private String advisedMethodName() {
        return ((MethodJoinPoint)this.info).advisedMethod.getName();
    }

    private long methodHash() {
        return ((MethodJoinPoint)this.info).hash;
    }

    protected boolean isVoid() {
        return ((MethodJoinPoint)this.info).unadvisedMethod.getReturnType().equals(Void.TYPE);
    }

    protected Class getReturnType() {
        if (this.isVoid()) {
            return null;
        }
        return ((MethodJoinPoint)this.info).unadvisedMethod.getReturnType();
    }

    protected AdviceMethodProperties getAdviceMethodProperties(JoinPointGenerator.AdviceSetup setup) {
        Method method = ((MethodJoinPoint)this.info).advisedMethod;
        return new AdviceMethodProperties(setup.getAspectClass(), setup.getAdviceName(), this.info.getClass(), INVOCATION_TYPE, method.getReturnType(), method.getParameterTypes(), method.getExceptionTypes());
    }

    protected boolean hasTargetObject() {
        return !Modifier.isStatic(((MethodJoinPoint)this.info).advisedMethod.getModifiers());
    }

    protected String getInfoName() {
        return MethodExecutionTransformer.getMethodInfoFieldName(((MethodJoinPoint)this.info).advisedMethod.getName(), ((MethodJoinPoint)this.info).hash);
    }

    protected static CtClass createJoinpointBaseClass(GeneratedAdvisorInstrumentor instrumentor, CtClass advisedClass, CtMethod targetMethod, String miname, String originalMethodName, String wrappedMethodName, long hash) throws CannotCompileException, NotFoundException {
        instrumentor.addJoinPointGeneratorFieldToGenAdvisor(MethodJoinPointGenerator.getJoinPointGeneratorFieldName(originalMethodName, hash));
        BaseClassGenerator factory = new BaseClassGenerator(instrumentor, advisedClass, targetMethod, miname, originalMethodName, wrappedMethodName, hash);
        return factory.generate();
    }

    protected String getJoinPointGeneratorFieldName() {
        return MethodJoinPointGenerator.getJoinPointGeneratorFieldName(this.advisedMethodName(), this.methodHash());
    }

    protected static String getJoinPointFieldName(String methodName, long hash) {
        return "joinpoint_" + MethodExecutionTransformer.getMethodNameHash(methodName, hash);
    }

    private static String getJoinPointClassName(String methodName, long hash) {
        return "JoinPoint_" + MethodExecutionTransformer.getMethodNameHash(methodName, hash);
    }

    protected static String getJoinPointGeneratorFieldName(String methodName, long hash) {
        return "generator_" + MethodExecutionTransformer.getMethodNameHash(methodName, hash);
    }

    static {
        try {
            INVOCATION_CT_TYPE = ReflectToJavassist.classToJavassist(INVOCATION_TYPE);
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private static class BaseClassGenerator {
        GeneratedAdvisorInstrumentor instrumentor;
        CtClass advisedClass;
        CtMethod advisedMethod;
        String miname;
        String originalMethodName;
        String wrappedMethodName;
        long hash;
        boolean hasTargetObject;
        CtClass jp;
        CtMethod invokeJoinpointMethod;
        CtConstructor publicConstructor;
        CtConstructor protectedConstructor;
        CtField targetField;
        CtClass[] originalParams;
        CtClass[] params;
        CtClass methodInfoClass;

        BaseClassGenerator(GeneratedAdvisorInstrumentor instrumentor, CtClass advisedClass, CtMethod targetMethod, String miname, String originalMethodName, String wrappedMethodName, long hash) throws NotFoundException {
            this.instrumentor = instrumentor;
            this.advisedClass = advisedClass;
            this.advisedMethod = targetMethod;
            this.miname = miname;
            this.originalMethodName = originalMethodName;
            this.wrappedMethodName = wrappedMethodName;
            this.hash = hash;
            this.originalParams = targetMethod.getParameterTypes();
            this.params = GeneratedAdvisorMethodExecutionTransformer.addTargetToParamsForNonStaticMethod(advisedClass, targetMethod);
            this.methodInfoClass = instrumentor.forName("org.jboss.aop.MethodJoinPoint");
            this.hasTargetObject = !Modifier.isStatic(this.advisedMethod.getModifiers());
        }

        protected CtClass generate() throws CannotCompileException, NotFoundException {
            this.jp = this.setupClass();
            this.addArgumentsFieldsAndAccessors();
            if (this.hasTargetObject) {
                this.addTypedTargetField();
            }
            this.addInvokeJoinpointMethod();
            this.addMethodInfoField();
            this.addDefaultConstructor();
            this.addPublicConstructor();
            this.addProtectedConstructor();
            this.addDispatchMethods();
            TransformerCommon.compileOrLoadClass(this.advisedClass, this.jp);
            return this.jp;
        }

        private CtClass setupClass() throws NotFoundException, CannotCompileException {
            String className = MethodJoinPointGenerator.getJoinPointClassName(this.originalMethodName, this.hash);
            this.jp = this.advisedClass.makeNestedClass(className, true);
            int mod = this.jp.getModifiers();
            this.jp.setModifiers(mod | 1);
            CtClass methodInvocation = INVOCATION_CT_TYPE;
            this.jp.setSuperclass(methodInvocation);
            JoinPointGenerator.addUntransformableInterface(this.instrumentor, this.jp);
            return this.jp;
        }

        private void addArgumentsFieldsAndAccessors() throws NotFoundException, CannotCompileException {
            OptimizedBehaviourInvocations.addArgumentFieldsToInvocation(this.jp, this.originalParams);
            OptimizedBehaviourInvocations.addSetArguments(this.instrumentor.getClassPool(), this.jp, this.originalParams);
            OptimizedBehaviourInvocations.addGetArguments(this.instrumentor.getClassPool(), this.jp, this.originalParams, true);
        }

        private void addTypedTargetField() throws CannotCompileException {
            this.targetField = new CtField(this.advisedClass, "tgt", this.jp);
            this.jp.addField(this.targetField);
            this.targetField.setModifiers(132);
        }

        private void addDefaultConstructor() throws CannotCompileException {
            CtConstructor defaultConstructor = CtNewConstructor.defaultConstructor((CtClass)this.jp);
            this.jp.addConstructor(defaultConstructor);
        }

        private void addPublicConstructor() throws CannotCompileException {
            this.publicConstructor = CtNewConstructor.make((CtClass[])new CtClass[]{this.methodInfoClass}, (CtClass[])new CtClass[0], (CtClass)this.jp);
            this.publicConstructor.setBody("{super($1, $1.interceptors); this.info = $1;}");
            this.jp.addConstructor(this.publicConstructor);
        }

        protected void addProtectedConstructor() throws CannotCompileException {
            CtClass[] ctorParams = new CtClass[this.params.length + 1];
            ctorParams[0] = this.jp;
            System.arraycopy(this.params, 0, ctorParams, 1, this.params.length);
            this.protectedConstructor = CtNewConstructor.make((CtClass[])ctorParams, (CtClass[])new CtClass[0], (CtClass)this.jp);
            this.protectedConstructor.setModifiers(4);
            StringBuffer body = new StringBuffer();
            body.append("{");
            body.append("   this($1.info);");
            int offset = 1;
            if (this.hasTargetObject) {
                body.append("   this.tgt = $2;");
                body.append("   super.setTargetObject($2);");
                offset = 2;
            }
            for (int i = offset; i < ctorParams.length; ++i) {
                body.append("   arg" + (i - offset) + " = $" + (i + 1) + ";");
            }
            body.append("}");
            this.protectedConstructor.setBody(body.toString());
            this.jp.addConstructor(this.protectedConstructor);
        }

        private CtMethod addInvokeJoinpointMethod() throws CannotCompileException, NotFoundException {
            this.invokeJoinpointMethod = CtNewMethod.make((CtClass)this.advisedMethod.getReturnType(), (String)"invokeJoinpoint", (CtClass[])this.params, (CtClass[])this.advisedMethod.getExceptionTypes(), null, (CtClass)this.jp);
            this.invokeJoinpointMethod.setModifiers(4);
            this.jp.addMethod(this.invokeJoinpointMethod);
            return this.invokeJoinpointMethod;
        }

        private void addMethodInfoField() throws CannotCompileException {
            CtField infoField = new CtField(this.methodInfoClass, "info", this.jp);
            this.jp.addField(infoField);
            infoField.setModifiers(132);
        }

        private void addDispatchMethods() throws CannotCompileException, NotFoundException {
            this.addInvokeNextDispatchMethod();
            if (this.params.length > 0) {
                this.addInvokeJoinPointDispatchMethod();
            }
        }

        private void addInvokeNextDispatchMethod() throws CannotCompileException, NotFoundException {
            CtMethod dispatch = CtNewMethod.make((CtClass)this.advisedMethod.getReturnType(), (String)"dispatch", (CtClass[])new CtClass[0], (CtClass[])this.advisedMethod.getExceptionTypes(), null, (CtClass)this.jp);
            dispatch.setModifiers(4);
            StringBuffer parameters = new StringBuffer();
            for (int i = 0; i < this.originalParams.length; ++i) {
                if (i > 0) {
                    parameters.append(", ");
                }
                parameters.append("arg" + i);
            }
            String body = !this.hasTargetObject ? "{" + MethodExecutionTransformer.getReturnStr(this.advisedMethod) + this.advisedClass.getName() + "." + this.wrappedMethodName + "(" + parameters + ");}" : "{" + MethodExecutionTransformer.getAopReturnStr(this.advisedMethod) + "tgt" + "." + this.wrappedMethodName + "(" + parameters + ");}";
            try {
                dispatch.setBody(body);
            }
            catch (CannotCompileException e) {
                throw new RuntimeException("Could not compile code " + body + " for method " + dispatch, e);
            }
            this.jp.addMethod(dispatch);
        }

        private void addInvokeJoinPointDispatchMethod() throws CannotCompileException, NotFoundException {
            CtMethod dispatch = CtNewMethod.make((CtClass)this.advisedMethod.getReturnType(), (String)"dispatch", (CtClass[])this.params, (CtClass[])this.advisedMethod.getExceptionTypes(), null, (CtClass)this.jp);
            dispatch.setModifiers(4);
            int offset = this.hasTargetObject ? 1 : 0;
            StringBuffer parameters = new StringBuffer();
            for (int i = 0; i < this.originalParams.length; ++i) {
                if (i > 0) {
                    parameters.append(", ");
                }
                parameters.append("$" + (i + offset + 1));
            }
            String body = !this.hasTargetObject ? "{" + MethodExecutionTransformer.getReturnStr(this.advisedMethod) + this.advisedClass.getName() + "." + this.wrappedMethodName + "(" + parameters + ");}" : "{" + MethodExecutionTransformer.getAopReturnStr(this.advisedMethod) + "$1." + this.wrappedMethodName + "(" + parameters + ");}";
            try {
                dispatch.setBody(body);
            }
            catch (CannotCompileException e) {
                throw new RuntimeException("Could not compile code " + body + " for method " + dispatch, e);
            }
            this.jp.addMethod(dispatch);
        }
    }
}

