/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.instrument;

import java.lang.reflect.Method;
import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewConstructor;
import javassist.CtNewMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import org.jboss.aop.GeneratedClassAdvisor;
import org.jboss.aop.JoinPoint;
import org.jboss.aop.MethodByMethodJoinPoint;
import org.jboss.aop.advice.AdviceMethodProperties;
import org.jboss.aop.instrument.CallerTransformer;
import org.jboss.aop.instrument.GeneratedAdvisorInstrumentor;
import org.jboss.aop.instrument.JoinPointGenerator;
import org.jboss.aop.instrument.MethodExecutionTransformer;
import org.jboss.aop.instrument.OptimizedBehaviourInvocations;
import org.jboss.aop.instrument.TransformerCommon;
import org.jboss.aop.joinpoint.MethodCalledByMethodInvocation;
import org.jboss.aop.util.ReflectToJavassist;

public class MethodByMethodJoinPointGenerator
extends JoinPointGenerator {
    public static final String GENERATOR_PREFIX = "generator_MByM_";
    public static final String JOINPOINT_CLASS_PREFIX = "JoinPoint_MByM_";
    public static final String JOINPOINT_FIELD_PREFIX = "joinpoint_MByM_";
    private static final Class INVOCATION_TYPE = MethodCalledByMethodInvocation.class;
    private static final CtClass INVOCATION_CT_TYPE;

    public MethodByMethodJoinPointGenerator(GeneratedClassAdvisor advisor, JoinPoint info) {
        super(advisor, info);
    }

    protected void initialiseJoinPointNames() {
        this.joinpointClassName = MethodByMethodJoinPointGenerator.getJoinPointClassName(this.callingMethodHash(), this.calledClass(), this.calledMethodHash());
        this.joinpointFieldName = MethodByMethodJoinPointGenerator.getJoinPointFieldName(this.callingMethodHash(), this.calledClass(), this.calledMethodHash());
    }

    private long callingMethodHash() {
        return ((MethodByMethodJoinPoint)this.info).callingMethodHash;
    }

    private String calledClass() {
        return ((MethodByMethodJoinPoint)this.info).calledClass.getName();
    }

    private long calledMethodHash() {
        return ((MethodByMethodJoinPoint)this.info).calledMethodHash;
    }

    protected boolean isVoid() {
        return ((MethodByMethodJoinPoint)this.info).method.getReturnType().equals(Void.TYPE);
    }

    protected Class getReturnType() {
        if (this.isVoid()) {
            return null;
        }
        return ((MethodByMethodJoinPoint)this.info).method.getReturnType();
    }

    protected AdviceMethodProperties getAdviceMethodProperties(JoinPointGenerator.AdviceSetup setup) {
        Method method = ((MethodByMethodJoinPoint)this.info).method;
        return new AdviceMethodProperties(setup.getAspectClass(), setup.getAdviceName(), this.info.getClass(), INVOCATION_TYPE, method.getReturnType(), method.getParameterTypes(), method.getExceptionTypes());
    }

    protected boolean isCaller() {
        return true;
    }

    protected boolean hasCallingObject() {
        return !java.lang.reflect.Modifier.isStatic(((MethodByMethodJoinPoint)this.info).callingMethod.getModifiers());
    }

    protected boolean hasTargetObject() {
        return !java.lang.reflect.Modifier.isStatic(((MethodByMethodJoinPoint)this.info).method.getModifiers());
    }

    protected static CtClass createJoinpointBaseClass(GeneratedAdvisorInstrumentor instrumentor, long callingHash, boolean hasCallingObject, CtClass callingClass, CtMethod targetMethod, String classname, long calledHash, String ciname) throws NotFoundException, CannotCompileException {
        instrumentor.addJoinPointGeneratorFieldToGenAdvisor(MethodByMethodJoinPointGenerator.getJoinPointGeneratorFieldName(callingHash, classname, calledHash));
        BaseClassGenerator generator = new BaseClassGenerator(instrumentor, callingClass, callingHash, hasCallingObject, classname, targetMethod, calledHash, ciname);
        return generator.generate();
    }

    protected String getJoinPointGeneratorFieldName() {
        return MethodByMethodJoinPointGenerator.getJoinPointGeneratorFieldName(this.callingMethodHash(), this.calledClass(), this.calledMethodHash());
    }

    protected static String getJoinPointClassName(long callingHash, String classname, long calledHash) {
        return JOINPOINT_CLASS_PREFIX + CallerTransformer.getUniqueInvocationFieldname(callingHash, classname, calledHash);
    }

    protected static String getJoinPointFieldName(long callingHash, String classname, long calledHash) {
        return JOINPOINT_FIELD_PREFIX + CallerTransformer.getUniqueInvocationFieldname(callingHash, classname, calledHash);
    }

    protected static String getJoinPointGeneratorFieldName(long callingHash, String classname, long calledHash) {
        return GENERATOR_PREFIX + CallerTransformer.getUniqueInvocationFieldname(callingHash, classname, calledHash);
    }

    static {
        try {
            INVOCATION_CT_TYPE = ReflectToJavassist.classToJavassist(INVOCATION_TYPE);
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private static class BaseClassGenerator {
        GeneratedAdvisorInstrumentor instrumentor;
        CtClass callingClass;
        long callingHash;
        boolean hasCallingObject;
        String classname;
        CtClass targetClass;
        CtMethod targetMethod;
        long calledHash;
        String ciname;
        boolean hasTargetObject;
        CtClass jp;
        CtMethod invokeJoinpointMethod;
        CtConstructor publicConstructor;
        CtConstructor protectedConstructor;
        CtField targetField;
        CtClass[] params;
        CtClass methodInfoClass;

        BaseClassGenerator(GeneratedAdvisorInstrumentor instrumentor, CtClass callingClass, long callingHash, boolean hasCallingObject, String classname, CtMethod targetMethod, long calledHash, String ciname) throws NotFoundException {
            this.instrumentor = instrumentor;
            this.callingClass = callingClass;
            this.callingHash = callingHash;
            this.classname = classname;
            this.hasCallingObject = hasCallingObject;
            this.targetClass = instrumentor.forName(classname);
            this.targetMethod = targetMethod;
            this.calledHash = calledHash;
            this.ciname = ciname;
            this.params = targetMethod.getParameterTypes();
            this.methodInfoClass = instrumentor.forName(CallerTransformer.METHOD_BY_METHOD_INFO_CLASS_NAME);
            this.hasTargetObject = !Modifier.isStatic((int)targetMethod.getModifiers());
        }

        protected CtClass generate() throws CannotCompileException, NotFoundException {
            this.jp = this.setupClass();
            this.addArgumentsFieldsAndAccessors();
            if (this.hasTargetObject) {
                this.addTypedTargetField();
            }
            this.addInvokeJoinpointMethod();
            this.addMethodInfoField();
            this.addPublicConstructor();
            this.addProtectedConstructor();
            this.addDispatchMethods();
            TransformerCommon.compileOrLoadClass(this.callingClass, this.jp);
            return this.jp;
        }

        private CtClass setupClass() throws NotFoundException, CannotCompileException {
            String className = MethodByMethodJoinPointGenerator.getJoinPointClassName(this.callingHash, this.targetClass.getName(), this.calledHash);
            this.jp = this.callingClass.makeNestedClass(className, true);
            int mod = this.jp.getModifiers();
            this.jp.setModifiers(mod | 1);
            CtClass invocation = INVOCATION_CT_TYPE;
            this.jp.setSuperclass(invocation);
            JoinPointGenerator.addUntransformableInterface(this.instrumentor, this.jp);
            return this.jp;
        }

        private void addArgumentsFieldsAndAccessors() throws NotFoundException, CannotCompileException {
            OptimizedBehaviourInvocations.addArgumentFieldsToInvocation(this.jp, this.params);
            OptimizedBehaviourInvocations.addSetArguments(this.instrumentor.getClassPool(), this.jp, this.params);
            OptimizedBehaviourInvocations.addGetArguments(this.instrumentor.getClassPool(), this.jp, this.params);
        }

        private void addTypedTargetField() throws CannotCompileException {
            this.targetField = new CtField(this.targetClass, "tgt", this.jp);
            this.jp.addField(this.targetField);
            this.targetField.setModifiers(4);
        }

        private void addPublicConstructor() throws CannotCompileException {
            this.publicConstructor = CtNewConstructor.make((CtClass[])new CtClass[]{this.methodInfoClass}, (CtClass[])new CtClass[0], (CtClass)this.jp);
            this.publicConstructor.setBody("{super($1, null, null, $1.interceptors); this.info = $1;}");
            this.jp.addConstructor(this.publicConstructor);
        }

        protected void addProtectedConstructor() throws CannotCompileException {
            int offset = 1;
            if (this.hasTargetObject) {
                ++offset;
            }
            if (this.hasCallingObject) {
                ++offset;
            }
            CtClass[] ctorParams = new CtClass[this.params.length + offset];
            int index = 0;
            ctorParams[index++] = this.jp;
            if (this.hasTargetObject) {
                ctorParams[index++] = this.targetClass;
            }
            if (this.hasCallingObject) {
                ctorParams[index] = this.callingClass;
            }
            System.arraycopy(this.params, 0, ctorParams, offset, this.params.length);
            this.protectedConstructor = CtNewConstructor.make((CtClass[])ctorParams, (CtClass[])new CtClass[0], (CtClass)this.jp);
            this.protectedConstructor.setModifiers(4);
            StringBuffer body = new StringBuffer();
            body.append("{");
            body.append("   this($1.info);");
            if (this.hasTargetObject) {
                body.append("   super.targetObject=$2;");
                body.append("   this.tgt=$2;");
            }
            if (this.hasCallingObject) {
                body.append("   super.callingObject=$" + (this.hasTargetObject ? 3 : 2) + ";");
            }
            for (int i = offset; i < ctorParams.length; ++i) {
                body.append("   arg" + (i - offset) + " = $" + (i + 1) + ";");
            }
            body.append("}");
            this.protectedConstructor.setBody(body.toString());
            this.jp.addConstructor(this.protectedConstructor);
        }

        private CtClass[] getInvokeJoinpointParameters() {
            if (!this.hasCallingObject && !this.hasTargetObject) {
                return this.params;
            }
            int offset = 0;
            if (this.hasTargetObject) {
                ++offset;
            }
            if (this.hasCallingObject) {
                ++offset;
            }
            CtClass[] invokeParams = new CtClass[this.params.length + offset];
            int index = 0;
            if (this.hasTargetObject) {
                invokeParams[index++] = this.targetClass;
            }
            if (this.hasCallingObject) {
                invokeParams[index++] = this.callingClass;
            }
            System.arraycopy(this.params, 0, invokeParams, offset, this.params.length);
            return invokeParams;
        }

        private CtMethod addInvokeJoinpointMethod() throws CannotCompileException, NotFoundException {
            this.invokeJoinpointMethod = CtNewMethod.make((CtClass)this.targetMethod.getReturnType(), (String)"invokeJoinpoint", (CtClass[])this.getInvokeJoinpointParameters(), (CtClass[])this.targetMethod.getExceptionTypes(), null, (CtClass)this.jp);
            this.invokeJoinpointMethod.setModifiers(4);
            this.jp.addMethod(this.invokeJoinpointMethod);
            return this.invokeJoinpointMethod;
        }

        private void addMethodInfoField() throws CannotCompileException {
            CtField infoField = new CtField(this.methodInfoClass, "info", this.jp);
            this.jp.addField(infoField);
        }

        private void addDispatchMethods() throws CannotCompileException, NotFoundException {
            this.addInvokeNextDispatchMethod();
            if (this.hasCallingObject || this.hasTargetObject || this.params.length > 0) {
                this.addInvokeJoinPointDispatchMethod();
            }
        }

        private void addInvokeNextDispatchMethod() throws CannotCompileException, NotFoundException {
            boolean isVoid = this.targetMethod.getReturnType().equals(CtClass.voidType);
            CtMethod dispatch = CtNewMethod.make((CtClass)(isVoid ? CtClass.voidType : this.targetMethod.getReturnType()), (String)"dispatch", (CtClass[])new CtClass[0], (CtClass[])this.targetMethod.getExceptionTypes(), null, (CtClass)this.jp);
            dispatch.setModifiers(4);
            StringBuffer parameters = new StringBuffer();
            for (int i = 0; i < this.params.length; ++i) {
                if (i > 0) {
                    parameters.append(", ");
                }
                parameters.append("arg" + i);
            }
            StringBuffer body = new StringBuffer("{");
            if (this.hasTargetObject) {
                body.append(MethodExecutionTransformer.getAopReturnStr(isVoid) + "tgt" + "." + this.targetMethod.getName() + "(" + parameters + ");");
            } else {
                body.append(MethodExecutionTransformer.getReturnStr(isVoid) + this.targetClass.getName() + "." + this.targetMethod.getName() + "(" + parameters + ");");
            }
            body.append("}");
            try {
                dispatch.setBody(body.toString());
            }
            catch (CannotCompileException e) {
                throw new RuntimeException("Could not compile code " + body + " for method " + dispatch, e);
            }
            this.jp.addMethod(dispatch);
        }

        private void addInvokeJoinPointDispatchMethod() throws CannotCompileException, NotFoundException {
            boolean isVoid = this.targetMethod.getReturnType().equals(CtClass.voidType);
            CtClass[] invokeParams = this.getInvokeJoinpointParameters();
            CtMethod dispatch = CtNewMethod.make((CtClass)(isVoid ? CtClass.voidType : this.targetMethod.getReturnType()), (String)"dispatch", (CtClass[])invokeParams, (CtClass[])this.targetMethod.getExceptionTypes(), null, (CtClass)this.jp);
            dispatch.setModifiers(4);
            int offset = invokeParams.length - this.params.length;
            StringBuffer parameters = new StringBuffer();
            for (int i = 0; i < this.params.length; ++i) {
                if (i > 0) {
                    parameters.append(", ");
                }
                parameters.append("$" + (i + offset + 1));
            }
            StringBuffer body = new StringBuffer("{");
            if (this.hasTargetObject) {
                body.append(MethodExecutionTransformer.getAopReturnStr(isVoid) + "$1." + this.targetMethod.getName() + "(" + parameters + ");");
            } else {
                body.append(MethodExecutionTransformer.getReturnStr(isVoid) + this.targetClass.getName() + "." + this.targetMethod.getName() + "(" + parameters + ");");
            }
            body.append("}");
            try {
                dispatch.setBody(body.toString());
            }
            catch (CannotCompileException e) {
                throw new RuntimeException("Could not compile code " + body + " for method " + dispatch, e);
            }
            this.jp.addMethod(dispatch);
        }
    }
}

