/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.advice;

import [Ljava.lang.Class;;
import [Ljava.lang.String;;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Method;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.advice.AspectFactoryWithClassLoaderSupport;
import org.jboss.aop.joinpoint.Joinpoint;
import org.jboss.util.propertyeditor.ClassArrayEditor;
import org.jboss.util.propertyeditor.IntArrayEditor;
import org.jboss.util.propertyeditor.StringArrayEditor;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GenericAspectFactory
extends AspectFactoryWithClassLoaderSupport {
    static final Class[] ADVISOR_INJECTOR_SIGNATURE = new Class[]{Advisor.class};
    static final Class[] INSTANCE_ADVISOR_INJECTOR_SIGNATURE = new Class[]{InstanceAdvisor.class};
    static final Class[] JOINPOINT_INJECTOR_SIGNATURE = new Class[]{Joinpoint.class};
    private Class clazz = null;
    private String classname;
    private Element element;

    public GenericAspectFactory(String classname, Element element) {
        this.classname = classname;
        this.element = element;
    }

    public static void initEditors() {
        String[] currentPath = PropertyEditorManager.getEditorSearchPath();
        int length = currentPath != null ? currentPath.length : 0;
        String[] newPath = new String[length + 2];
        System.arraycopy(currentPath, 0, newPath, 2, length);
        newPath[0] = "org.jboss.util.propertyeditor";
        newPath[1] = "org.jboss.mx.util.propertyeditor";
        PropertyEditorManager.setEditorSearchPath(newPath);
        Class strArrayType = String;.class;
        PropertyEditorManager.registerEditor(strArrayType, StringArrayEditor.class);
        Class clsArrayType = Class;.class;
        PropertyEditorManager.registerEditor(clsArrayType, ClassArrayEditor.class);
        Class intArrayType = [I.class;
        PropertyEditorManager.registerEditor(intArrayType, IntArrayEditor.class);
    }

    public void setClazz(Class clazz) {
        this.clazz = clazz;
    }

    public String getClassname() {
        return this.classname;
    }

    public void setClassname(String classname) {
        this.classname = classname;
    }

    public String getName() {
        return this.classname;
    }

    public Element getElement() {
        return this.element;
    }

    public void setElement(Element element) {
        this.element = element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class getClazz() {
        GenericAspectFactory genericAspectFactory = this;
        synchronized (genericAspectFactory) {
            if (this.clazz == null) {
                try {
                    this.clazz = this.loadClass(this.classname);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return this.clazz;
    }

    public Object createPerVM() {
        try {
            Object aspect = this.getClazz().newInstance();
            this.configureInstance(aspect, null, null, null);
            return aspect;
        }
        catch (Exception re) {
            if (re instanceof RuntimeException) {
                throw (RuntimeException)re;
            }
            throw new RuntimeException(re);
        }
    }

    public Object createPerClass(Advisor advisor) {
        try {
            Object aspect = this.getClazz().newInstance();
            this.configureInstance(aspect, advisor, null, null);
            return aspect;
        }
        catch (Exception re) {
            if (re instanceof RuntimeException) {
                throw (RuntimeException)re;
            }
            throw new RuntimeException(re);
        }
    }

    public Object createPerInstance(Advisor advisor, InstanceAdvisor instanceAdvisor) {
        try {
            Object aspect = this.getClazz().newInstance();
            this.configureInstance(aspect, advisor, instanceAdvisor, null);
            return aspect;
        }
        catch (Exception re) {
            if (re instanceof RuntimeException) {
                throw (RuntimeException)re;
            }
            throw new RuntimeException(re);
        }
    }

    public Object createPerJoinpoint(Advisor advisor, Joinpoint jp) {
        try {
            Object aspect = this.getClazz().newInstance();
            this.configureInstance(aspect, advisor, null, jp);
            return aspect;
        }
        catch (Exception re) {
            if (re instanceof RuntimeException) {
                throw (RuntimeException)re;
            }
            throw new RuntimeException(re);
        }
    }

    public Object createPerJoinpoint(Advisor advisor, InstanceAdvisor instanceAdvisor, Joinpoint jp) {
        try {
            Object aspect = this.getClazz().newInstance();
            this.configureInstance(aspect, advisor, instanceAdvisor, jp);
            return aspect;
        }
        catch (Exception re) {
            if (re instanceof RuntimeException) {
                throw (RuntimeException)re;
            }
            throw new RuntimeException(re);
        }
    }

    protected void configureInstance(Object instance, Advisor advisor, InstanceAdvisor instanceAdvisor, Joinpoint jp) {
        if (this.element == null) {
            return;
        }
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(this.clazz);
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        PropertyDescriptor[] descriptors = beanInfo.getPropertyDescriptors();
        if (descriptors == null) {
            descriptors = new PropertyDescriptor[]{};
        }
        NodeList children = this.element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            if (children.item(i).getNodeType() != 1) continue;
            Element element = (Element)children.item(i);
            String tagname = element.getTagName();
            String attributeName = element.getAttribute("name");
            if (tagname.equals("attribute")) {
                String attributeText = element.getFirstChild().getNodeValue();
                this.setAttribute(instance, descriptors, attributeName, attributeText);
                continue;
            }
            if (tagname.equals("advisor-attribute")) {
                this.injectAdvisor(instance, advisor, attributeName);
                continue;
            }
            if (tagname.equals("joinpoint-attribute")) {
                this.injectJoinpoint(instance, jp, attributeName);
                continue;
            }
            if (!tagname.equals("instance-advisor-attribute")) continue;
            this.injectInstanceAdvisor(instance, instanceAdvisor, attributeName);
        }
    }

    protected void setAttribute(Object instance, PropertyDescriptor[] descriptors, String attributeName, String attributeText) {
        boolean foundProperty = false;
        for (int i = 0; i < descriptors.length; ++i) {
            if (!attributeName.equalsIgnoreCase(descriptors[i].getName())) continue;
            foundProperty = true;
            Class<?> typeClass = descriptors[i].getPropertyType();
            PropertyEditor editor = PropertyEditorManager.findEditor(typeClass);
            if (editor == null) {
                throw new RuntimeException("No property editor for attribute: " + attributeName + "; type=" + typeClass);
            }
            editor.setAsText(attributeText);
            Object value = editor.getValue();
            try {
                descriptors[i].getWriteMethod().invoke(instance, value);
                break;
            }
            catch (Exception e) {
                throw new RuntimeException("Error setting attribute '" + attributeName + "' in " + this.classname, e);
            }
        }
        if (!foundProperty) {
            throw new RuntimeException("Could not find attribute '" + attributeName + "' in aspect/interceptor class " + this.classname);
        }
    }

    protected void injectAdvisor(Object instance, Advisor advisor, String attributeName) {
        if (advisor == null) {
            if (AspectManager.verbose) {
                System.out.println("WARN: Ignoring attempt to set advisor attribute on PER_VM scoped aspect/interceptor: " + this.classname);
            }
            return;
        }
        String injector = this.getInjectorName(attributeName);
        try {
            Method m = this.clazz.getMethod(injector, ADVISOR_INJECTOR_SIGNATURE);
            m.invoke(instance, advisor);
        }
        catch (Exception e) {
            throw new RuntimeException("Aspect/interceptor " + this.classname + " does not contain a public org.jboss.aop.Advisor injector called " + injector);
        }
    }

    protected void injectJoinpoint(Object instance, Joinpoint jp, String attributeName) {
        if (jp == null) {
            if (AspectManager.verbose) {
                System.out.println("WARN: Ignoring attempt to set joinpoint attribute on aspect/interceptor: " + this.classname + " which is not scoped PER_JOINPOINT");
            }
            return;
        }
        String injector = this.getInjectorName(attributeName);
        try {
            Method m = this.clazz.getMethod(injector, JOINPOINT_INJECTOR_SIGNATURE);
            m.invoke(instance, jp);
        }
        catch (Exception e) {
            throw new RuntimeException("Aspect/interceptor " + this.classname + " does not contain a public org.jboss.aop.Joinpoint injector called " + injector);
        }
    }

    protected void injectInstanceAdvisor(Object instance, InstanceAdvisor instanceAdvisor, String attributeName) {
        if (instanceAdvisor == null) {
            if (AspectManager.verbose) {
                System.out.println("WARN: Ignoring attempt to set instance advisor attribute on aspect/interceptor: " + this.classname + " which is not scoped PER_INSTANCE or PER_JOINPOINT");
            }
            return;
        }
        String injector = this.getInjectorName(attributeName);
        try {
            Method m = this.clazz.getMethod(injector, INSTANCE_ADVISOR_INJECTOR_SIGNATURE);
            m.invoke(instance, instanceAdvisor);
        }
        catch (Exception e) {
            throw new RuntimeException("Aspect/interceptor " + this.classname + " does not contain a public org.jboss.aop.InstanceAdvisor injector called " + injector);
        }
    }

    protected String getInjectorName(String attributeName) {
        char firstChar = attributeName.charAt(0);
        if (Character.isLowerCase(firstChar)) {
            attributeName = Character.toUpperCase(firstChar) + attributeName.substring(1);
        }
        return "set" + attributeName;
    }

    static {
        GenericAspectFactory.initEditors();
    }
}

