/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.jboss.aop.Advisor;
import org.jboss.aop.JoinPoint;
import org.jboss.aop.joinpoint.FieldJoinpoint;
import org.jboss.aop.joinpoint.Joinpoint;
import org.jboss.aop.util.MethodHashing;

public class FieldJoinPoint
extends JoinPoint {
    public int index;
    public Field advisedField;
    public Method wrapper;
    public boolean read;

    public FieldJoinPoint() {
    }

    public FieldJoinPoint(Class clazz, int index, String fieldName, long wrapperHash, Advisor advisor, boolean read) {
        super(advisor);
        try {
            this.index = index;
            this.advisedField = clazz.getDeclaredField(fieldName);
            this.wrapper = MethodHashing.findMethodByHash(clazz, wrapperHash);
            this.advisor = advisor;
            this.read = read;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private FieldJoinPoint(FieldJoinPoint other) {
        super(other);
        this.index = other.index;
        this.advisedField = other.advisedField;
        this.wrapper = other.wrapper;
        this.read = other.read;
    }

    protected Joinpoint internalGetJoinpoint() {
        return new FieldJoinpoint(this.advisedField);
    }

    public JoinPoint copy() {
        return new FieldJoinPoint(this);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Field ");
        sb.append(this.read ? " Read" : "Write");
        sb.append("[");
        sb.append("field=" + this.advisedField);
        sb.append("]");
        return sb.toString();
    }
}

