/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.jboss.aop.Advisor;
import org.jboss.aop.CallerConstructorJoinPoint;
import org.jboss.aop.JoinPoint;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.ConstructorCalledByMethodJoinpoint;
import org.jboss.aop.joinpoint.Joinpoint;
import org.jboss.aop.util.MethodHashing;

public class ConByMethodJoinPoint
extends CallerConstructorJoinPoint {
    public final long callingMethodHash;
    public final Method callingMethod;

    public ConByMethodJoinPoint(Advisor advisor, Class calledClass, long callingMethodHash, Constructor c, long calledConHash, Method wrappingMethod, Interceptor[] in) {
        super(advisor, calledClass, c, calledConHash, wrappingMethod, in);
        try {
            this.callingMethodHash = callingMethodHash;
            this.callingMethod = MethodHashing.findMethodByHash(this.callingClass, callingMethodHash);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected ConByMethodJoinPoint(ConByMethodJoinPoint other) {
        super(other);
        this.callingMethodHash = other.callingMethodHash;
        this.callingMethod = other.callingMethod;
    }

    protected Joinpoint internalGetJoinpoint() {
        return new ConstructorCalledByMethodJoinpoint(this.callingMethod, this.constructor);
    }

    public JoinPoint copy() {
        return new ConByMethodJoinPoint(this);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Constructor called by Method");
        sb.append("[");
        sb.append("calling=" + this.callingMethod);
        sb.append(",called=" + this.constructor);
        sb.append("]");
        return sb.toString();
    }
}

