/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.xml;

import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.jboss.logging.Logger;
import org.jboss.util.xml.SchemaResolverConfigMBean;
import org.jboss.util.xml.SingletonSchemaResolverFactory;
import org.jboss.xb.binding.sunday.unmarshalling.DefaultSchemaResolver;

public class SchemaResolverConfig
implements SchemaResolverConfigMBean {
    private static final Logger log = Logger.getLogger(SchemaResolverConfig.class);
    protected static DefaultSchemaResolver resolver = (DefaultSchemaResolver)SingletonSchemaResolverFactory.getInstance().getSchemaBindingResolver();
    protected Properties schemaInitializers;
    protected Properties schemaLocations;

    public Properties getSchemaInitializers() {
        return this.schemaInitializers;
    }

    public void setSchemaInitializers(Properties schemaInitializers) {
        this.schemaInitializers = schemaInitializers;
        if (schemaInitializers != null && schemaInitializers.size() != 0) {
            Iterator<Map.Entry<Object, Object>> i = schemaInitializers.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<Object, Object> entry = i.next();
                String namespace = (String)entry.getKey();
                String initializer = (String)entry.getValue();
                try {
                    resolver.addSchemaInitializer(namespace, initializer);
                }
                catch (Exception ignored) {
                    log.debug("Ignored: ", ignored);
                }
            }
        }
    }

    public Properties getSchemaLocations() {
        return this.schemaLocations;
    }

    public void setSchemaLocations(Properties schemaLocations) {
        this.schemaLocations = schemaLocations;
        if (this.schemaInitializers != null && this.schemaInitializers.size() != 0) {
            Iterator<Map.Entry<Object, Object>> i = schemaLocations.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<Object, Object> entry = i.next();
                String namespace = (String)entry.getKey();
                String location = (String)entry.getValue();
                resolver.addSchemaLocation(namespace, location);
            }
        }
    }
}

