/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.advice;

import org.jboss.aop.Advised;
import org.jboss.aop.Advisor;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.advice.AspectDefinition;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.CallerInvocation;
import org.jboss.aop.joinpoint.ConstructorCalledByMethodInvocation;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodCalledByMethodInvocation;

public class PerInstanceInterceptor
implements Interceptor {
    AspectDefinition aspectDefinition;

    public PerInstanceInterceptor(AspectDefinition a, Advisor advisor) {
        this.aspectDefinition = a;
        advisor.addPerInstanceAspect(a);
    }

    public String getName() {
        return this.aspectDefinition.getName();
    }

    public Object invoke(Invocation invocation) throws Throwable {
        if (invocation instanceof CallerInvocation) {
            Object callingObject = null;
            if (invocation instanceof ConstructorCalledByMethodInvocation) {
                callingObject = ((ConstructorCalledByMethodInvocation)invocation).getCallingObject();
            } else if (invocation instanceof MethodCalledByMethodInvocation) {
                callingObject = ((MethodCalledByMethodInvocation)invocation).getCallingObject();
            }
            if (callingObject == null) {
                return invocation.invokeNext();
            }
            Advised advised = (Advised)callingObject;
            InstanceAdvisor advisor = advised._getInstanceAdvisor();
            Interceptor interceptor = (Interceptor)advisor.getPerInstanceAspect(this.aspectDefinition);
            return interceptor.invoke(invocation);
        }
        Object targetObject = invocation.getTargetObject();
        if (targetObject == null) {
            return invocation.invokeNext();
        }
        InstanceAdvisor instanceAdvisor = null;
        if (targetObject instanceof Advised) {
            Advised advised = (Advised)targetObject;
            instanceAdvisor = advised._getInstanceAdvisor();
        } else {
            Advisor advisor = invocation.getAdvisor();
            if (advisor == null || !(advisor instanceof InstanceAdvisor)) {
                return invocation.invokeNext();
            }
            instanceAdvisor = (InstanceAdvisor)((Object)advisor);
        }
        Interceptor interceptor = (Interceptor)instanceAdvisor.getPerInstanceAspect(this.aspectDefinition);
        return interceptor.invoke(invocation);
    }
}

