/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.advice;

import java.lang.reflect.Method;
import java.util.ArrayList;
import javassist.NotFoundException;
import org.jboss.aop.JoinPoint;
import org.jboss.aop.advice.AdviceMethodProperties;
import org.jboss.aop.advice.MatchData;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.util.ReflectUtils;

public class AdviceMethodFactory {
    private static final int IS_BEFORE = 1;
    private static final int IS_AFTER = 2;
    private static final int IS_THROWING = 3;
    private static final int IS_AROUND = 4;
    public static final AdviceMethodFactory BEFORE = new AdviceMethodFactory(1, false, true, false, false);
    public static final AdviceMethodFactory AFTER = new AdviceMethodFactory(2, false, true, true, false);
    public static final AdviceMethodFactory THROWING = new AdviceMethodFactory(3, false, true, false, true);
    public static final AdviceMethodFactory AROUND = new AdviceMethodFactory(4, true, false, false, false);
    private static final Class INVOCATION = Invocation.class;
    private static final Class THROWABLE = Throwable.class;
    int type;
    boolean canHaveJoinpoint;
    boolean canHaveInvocation;
    boolean mustHaveReturnType;
    boolean mustHaveThrowable;
    static final MatchData BEST_MATCH_START = new MatchData();

    private AdviceMethodFactory(int type, boolean canHaveInvocation, boolean canHaveJoinpoint, boolean canHaveReturnType, boolean canHaveThrowable) {
        this.type = type;
        this.canHaveInvocation = canHaveInvocation;
        this.canHaveJoinpoint = canHaveJoinpoint;
        this.mustHaveReturnType = canHaveReturnType;
        this.mustHaveThrowable = canHaveThrowable;
    }

    public AdviceMethodProperties findAdviceMethod(AdviceMethodProperties properties) {
        Method[] methods = ReflectUtils.getMethodsWithName(properties.getAspectClass(), properties.getAdviceName());
        if (methods.length == 0) {
            return null;
        }
        if (methods.length == 1 && methods[0].getParameterTypes().length == 0) {
            if (this.mustHaveReturnType && !properties.getJoinpointReturnType().equals(Void.TYPE)) {
                return null;
            }
            if (this.mustHaveThrowable) {
                return null;
            }
            properties.setFoundProperties(methods[0], new ArrayList());
            return properties;
        }
        MatchData bestMatch = BEST_MATCH_START;
        for (int i = 0; i < methods.length; ++i) {
            MatchData matchData = this.matchParameters(properties, methods[i], bestMatch);
            if (matchData == null) continue;
            bestMatch = matchData;
        }
        if (bestMatch.method != null) {
            return this.setupMethodAndArgsInProperties(properties, bestMatch);
        }
        return null;
    }

    private AdviceMethodProperties setupMethodAndArgsInProperties(AdviceMethodProperties properties, MatchData matchData) {
        ArrayList<Integer> args = new ArrayList<Integer>();
        if (matchData.invocationMatchDegree >= 0) {
            if (this.canHaveInvocation) {
                args.add(AdviceMethodProperties.INVOCATION_ARG);
            } else if (this.canHaveJoinpoint) {
                args.add(AdviceMethodProperties.JOINPOINT_ARG);
            }
        }
        if (matchData.returnOrThrowingMatchDegree >= 0) {
            if (this.mustHaveReturnType) {
                args.add(AdviceMethodProperties.RETURN_ARG);
            } else if (this.mustHaveThrowable) {
                args.add(AdviceMethodProperties.THROWABLE_ARG);
            }
        }
        if (matchData.argsIndices != null) {
            args.addAll(matchData.argsIndices);
        }
        properties.setFoundProperties(matchData.method, args);
        return properties;
    }

    private MatchData matchParameters(AdviceMethodProperties properties, Method adviceMethod, MatchData bestMatch) {
        Class<?>[] adviceParams = adviceMethod.getParameterTypes();
        if (adviceParams.length == 0 && bestMatch.method == null) {
            return new MatchData(adviceMethod);
        }
        MatchData currentMatch = this.lookForJoinPointOrInvocation(properties, adviceMethod, bestMatch);
        if (currentMatch == null) {
            return null;
        }
        if ((currentMatch = this.lookForThrowingOrReturn(properties, adviceMethod, currentMatch, bestMatch)) == null) {
            return null;
        }
        if ((currentMatch = this.matchActualArgs(properties, adviceMethod, currentMatch, bestMatch)) == null) {
            return null;
        }
        if (currentMatch.currentParam == adviceMethod.getParameterTypes().length) {
            return currentMatch;
        }
        return currentMatch;
    }

    private MatchData lookForJoinPointOrInvocation(AdviceMethodProperties properties, Method method, MatchData bestMatch) {
        Class<?>[] adviceParams = method.getParameterTypes();
        int index = 0;
        int matchDegree = -1;
        boolean firstIsSpecial = false;
        if (this.canHaveInvocation) {
            if (this.isInvocation(adviceParams[index])) {
                firstIsSpecial = true;
                matchDegree = this.matchClass(adviceParams[index], properties.getInvocationType());
            }
        } else if (this.canHaveJoinpoint && this.isInfo(adviceParams[index])) {
            firstIsSpecial = true;
            matchDegree = this.matchClass(adviceParams[index], properties.getInfoType());
        }
        if (firstIsSpecial) {
            if (matchDegree < 0) {
                return null;
            }
            ++index;
        }
        if (!(bestMatch.invocationMatchDegree < 0 || bestMatch.invocationMatchDegree >= matchDegree && firstIsSpecial)) {
            return null;
        }
        return new MatchData(method, index, matchDegree);
    }

    private MatchData lookForTargetObject(AdviceMethodProperties properties, Method adviceMethod, MatchData currentMatch, MatchData bestMatch) throws NotFoundException {
        return currentMatch;
    }

    private MatchData lookForThrowingOrReturn(AdviceMethodProperties properties, Method adviceMethod, MatchData currentMatch, MatchData bestMatch) {
        if (currentMatch.currentParam == adviceMethod.getParameterTypes().length) {
            return currentMatch;
        }
        if (this.mustHaveReturnType) {
            if ((currentMatch = this.lookForReturn(properties, adviceMethod, currentMatch, bestMatch)) == null) {
                return null;
            }
        } else if (this.mustHaveThrowable) {
            currentMatch.returnOrThrowingMatchDegree = this.matchClass(adviceMethod.getParameterTypes()[currentMatch.currentParam], THROWABLE);
            ++currentMatch.currentParam;
        }
        if (bestMatch.returnOrThrowingMatchDegree >= 0 && bestMatch.returnOrThrowingMatchDegree < currentMatch.returnOrThrowingMatchDegree) {
            return null;
        }
        return currentMatch;
    }

    private MatchData lookForReturn(AdviceMethodProperties properties, Method adviceMethod, MatchData currentMatch, MatchData bestMatch) {
        Class returnType = properties.getJoinpointReturnType();
        if (returnType != null && !returnType.equals(Void.TYPE)) {
            currentMatch.returnOrThrowingMatchDegree = this.subClassMatch(returnType, adviceMethod.getReturnType());
            if (currentMatch.returnOrThrowingMatchDegree < 0) {
                return null;
            }
            Class<?> param = adviceMethod.getParameterTypes()[currentMatch.currentParam];
            if (!returnType.equals(param)) {
                int match2 = this.subClassMatch(returnType, param);
                if (match2 < 0) {
                    return null;
                }
                currentMatch.returnOrThrowingMatchDegree = (currentMatch.returnOrThrowingMatchDegree + match2) / 2;
            }
            ++currentMatch.currentParam;
        }
        return currentMatch;
    }

    private MatchData matchActualArgs(AdviceMethodProperties properties, Method adviceMethod, MatchData currentMatch, MatchData bestMatch) {
        Class[] targetParams;
        int adviceParam = currentMatch.currentParam;
        Class<?>[] adviceParams = adviceMethod.getParameterTypes();
        if (adviceParams.length - currentMatch.currentParam > (targetParams = properties.getJoinpointParameters()).length) {
            return null;
        }
        if (adviceParam == adviceParams.length) {
            return this.nullOrCurrentMatch(currentMatch, bestMatch);
        }
        currentMatch.argsIndices = new ArrayList();
        for (int i = 0; i < targetParams.length && adviceParam < adviceParams.length; ++i) {
            int match = this.matchClass(adviceParams[adviceParam], targetParams[i]);
            if (match < 0) continue;
            ++adviceParam;
            currentMatch.argsIndices.add(new Integer(i));
            currentMatch.argsDegreeSum += match;
        }
        if (currentMatch.argsIndices.size() != adviceParams.length - currentMatch.currentParam) {
            return null;
        }
        return this.nullOrCurrentMatch(currentMatch, bestMatch);
    }

    private MatchData nullOrCurrentMatch(MatchData currentMatch, MatchData bestMatch) {
        if (currentMatch.compare(bestMatch, true) < 0) {
            return currentMatch;
        }
        return null;
    }

    private boolean isInvocation(Class clazz) {
        return Invocation.class.isAssignableFrom(clazz);
    }

    private boolean isInfo(Class clazz) {
        return JoinPoint.class.isAssignableFrom(clazz);
    }

    private int matchClass(Class clazz, Class lookingFor) {
        return this.matchClass(clazz, lookingFor, 0);
    }

    private int subClassMatch(Class clazz, Class superClass) {
        return this.matchClass(superClass, clazz);
    }

    private int matchClass(Class wanted, Class candidate, int matchDegree) {
        if (candidate == null) {
            return -1;
        }
        if (candidate.equals(wanted)) {
            return matchDegree;
        }
        ++matchDegree;
        Class<?>[] interfaces = candidate.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (this.matchClass(wanted, interfaces[i], matchDegree) <= 0) continue;
            return matchDegree;
        }
        if (this.matchClass(wanted, candidate.getSuperclass(), matchDegree) > 0) {
            return matchDegree;
        }
        return -1;
    }
}

