/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop;

import java.lang.reflect.Method;
import org.jboss.aop.Advisor;
import org.jboss.aop.CallerMethodJoinPoint;
import org.jboss.aop.JoinPoint;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Joinpoint;
import org.jboss.aop.joinpoint.MethodCalledByMethodJoinpoint;
import org.jboss.aop.util.MethodHashing;

public class MethodByMethodJoinPoint
extends CallerMethodJoinPoint {
    public final long callingMethodHash;
    public final Method callingMethod;

    public MethodByMethodJoinPoint(Advisor advisor, Class calledClass, Method m, long callingMethodHash, long calledMethodHash, Interceptor[] in) {
        super(advisor, calledClass, m, calledMethodHash, in);
        try {
            this.callingMethodHash = callingMethodHash;
            this.callingMethod = MethodHashing.findMethodByHash(this.callingClass, callingMethodHash);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private MethodByMethodJoinPoint(MethodByMethodJoinPoint other) {
        super(other);
        this.callingMethodHash = other.callingMethodHash;
        this.callingMethod = other.callingMethod;
    }

    protected Joinpoint internalGetJoinpoint() {
        return new MethodCalledByMethodJoinpoint(this.callingMethod, this.method);
    }

    public JoinPoint copy() {
        return new MethodByMethodJoinPoint(this);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Method called by Method");
        sb.append("[");
        sb.append("calling=" + this.callingMethod);
        sb.append(",called=" + this.method);
        sb.append("]");
        return sb.toString();
    }
}

