/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop;

import java.util.ArrayList;
import org.jboss.aop.Advisor;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.advice.InterceptorFactoryWrapper;
import org.jboss.aop.joinpoint.Joinpoint;

public abstract class JoinPoint {
    public InterceptorFactoryWrapper[] factories;
    public ArrayList factoryChain = new ArrayList();
    public Interceptor[] interceptors;
    public ArrayList interceptorChain = new ArrayList();
    public Advisor advisor;
    protected volatile Joinpoint joinpoint;

    protected JoinPoint() {
    }

    protected JoinPoint(Advisor advisor) {
        this.advisor = advisor;
    }

    protected JoinPoint(JoinPoint other) {
        this.advisor = other.advisor;
        if (other.factories != null) {
            this.factories = new InterceptorFactoryWrapper[other.factories.length];
            System.arraycopy(other.factories, 0, this.factories, 0, other.factories.length);
        }
        if (other.factoryChain != null) {
            this.factoryChain = (ArrayList)this.factoryChain.clone();
        }
        if (other.interceptors != null) {
            this.interceptors = new Interceptor[other.interceptors.length];
            System.arraycopy(other.interceptors, 0, this.interceptors, 0, other.interceptors.length);
        }
        if (other.interceptorChain != null) {
            this.interceptorChain = (ArrayList)this.interceptorChain.clone();
        }
    }

    protected void clear() {
        this.factoryChain.clear();
        this.interceptorChain.clear();
        this.interceptors = null;
        this.factories = null;
    }

    public boolean hasAdvices() {
        return this.interceptors != null && this.interceptors.length > 0 || this.factories != null && this.factories.length > 0;
    }

    protected JoinPoint initialiseInterceptors() {
        if (this.factories == null || this.interceptors != null) {
            return this;
        }
        this.interceptors = new Interceptor[this.factories.length];
        for (int i = 0; i < this.factories.length; ++i) {
            this.interceptors[i] = this.factories[i].create(this.advisor, this.getJoinpoint());
        }
        return this;
    }

    public boolean equalChains(JoinPoint other) {
        if (this.factories == null && other.factories == null) {
            return true;
        }
        if (this.factories == null || other.factories == null) {
            return false;
        }
        if (this.factories.length != other.factories.length) {
            return false;
        }
        for (int i = 0; i < this.factories.length; ++i) {
            if (this.factories[i].equals(other.factories[i])) continue;
            return false;
        }
        return true;
    }

    public Joinpoint getJoinpoint() {
        if (this.joinpoint == null) {
            this.joinpoint = this.internalGetJoinpoint();
        }
        return this.joinpoint;
    }

    protected abstract Joinpoint internalGetJoinpoint();

    public abstract JoinPoint copy();
}

