/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding.sunday.unmarshalling.impl.runtime;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.util.Classes;
import org.jboss.xb.binding.Constants;
import org.jboss.xb.binding.GenericValueContainer;
import org.jboss.xb.binding.JBossXBRuntimeException;
import org.jboss.xb.binding.SimpleTypeBindings;
import org.jboss.xb.binding.Util;
import org.jboss.xb.binding.group.ValueList;
import org.jboss.xb.binding.group.ValueListHandler;
import org.jboss.xb.binding.group.ValueListInitializer;
import org.jboss.xb.binding.metadata.AddMethodMetaData;
import org.jboss.xb.binding.metadata.ClassMetaData;
import org.jboss.xb.binding.metadata.MapEntryMetaData;
import org.jboss.xb.binding.metadata.PackageMetaData;
import org.jboss.xb.binding.metadata.PropertyMetaData;
import org.jboss.xb.binding.metadata.PutMethodMetaData;
import org.jboss.xb.binding.metadata.ValueMetaData;
import org.jboss.xb.binding.sunday.unmarshalling.AttributeBinding;
import org.jboss.xb.binding.sunday.unmarshalling.AttributeHandler;
import org.jboss.xb.binding.sunday.unmarshalling.CharactersHandler;
import org.jboss.xb.binding.sunday.unmarshalling.ElementBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ModelGroupBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ParticleBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ParticleHandler;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;
import org.jboss.xb.binding.sunday.unmarshalling.TermBinding;
import org.jboss.xb.binding.sunday.unmarshalling.TypeBinding;
import org.jboss.xb.binding.sunday.unmarshalling.WildcardBinding;
import org.jboss.xb.binding.sunday.unmarshalling.impl.runtime.MapEntry;
import org.jboss.xb.binding.sunday.unmarshalling.impl.runtime.RtUtil;
import org.xml.sax.Attributes;

public class RtElementHandler
implements ParticleHandler {
    private static final Logger log = Logger.getLogger((Class)RtElementHandler.class);
    public static final RtElementHandler INSTANCE = new RtElementHandler();

    public Object startParticle(Object parent, QName elementName, ParticleBinding particle, Attributes attrs, NamespaceContext nsCtx) {
        TermBinding term = particle.getTerm();
        Object o = this.startElement(parent, elementName, particle);
        if (!term.isModelGroup()) {
            ElementBinding element = (ElementBinding)term;
            if (o != null) {
                attrs = element.getType().expandWithDefaultAttributes(attrs);
                this.attributes(o, elementName, element, attrs, nsCtx);
            }
        }
        return o;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setParent(Object parent, Object o, QName qName, ParticleBinding particle, ParticleBinding parentParticle) {
        String propName;
        TermBinding term = particle.getTerm();
        if (term.isSkip()) {
            return;
        }
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)("setParent " + qName + " parent=" + parent + " object=" + o + " term=" + term));
        }
        TermBinding parentTerm = parentParticle.getTerm();
        if (term.isMapEntryKey()) {
            if (trace) {
                log.trace((Object)("setParent " + qName + " mapKey"));
            }
            if (parent instanceof MapEntry) {
                MapEntry mapEntry = (MapEntry)parent;
                mapEntry.setKey(o);
                return;
            } else {
                String setKeyMethodName;
                if (parentTerm == null) throw new JBossXBRuntimeException("Element " + qName + " bound as map entry key but parent element is not recognized as map entry and its metadata is not available.");
                MapEntryMetaData mapEntryMetaData = RtElementHandler.getMapEntryMetaData(parentTerm, qName);
                String getKeyMethodName = mapEntryMetaData.getGetKeyMethod();
                if (getKeyMethodName == null) {
                    getKeyMethodName = "getKey";
                }
                if ((setKeyMethodName = mapEntryMetaData.getSetKeyMethod()) == null) {
                    setKeyMethodName = "setKey";
                }
                Class<?> parentCls = parent.getClass();
                Method setKeyMethod = RtElementHandler.getSetMethod(parentCls, getKeyMethodName, setKeyMethodName);
                RtElementHandler.invokeSetter(setKeyMethod, parent, o, setKeyMethodName);
            }
            return;
        }
        if (term.isMapEntryValue()) {
            if (trace) {
                log.trace((Object)("setParent " + qName + " mapValue"));
            }
            if (parent instanceof MapEntry) {
                MapEntry mapEntry = (MapEntry)parent;
                mapEntry.setValue(o);
                return;
            } else {
                if (parentTerm == null) throw new JBossXBRuntimeException("Element " + qName + " bound as map entry key but parent element is not recognized as map entry and its metadata is not available.");
                MapEntryMetaData mapEntryMetaData = RtElementHandler.getMapEntryMetaData(parentTerm, qName);
                RtElementHandler.setMapEntryValue(mapEntryMetaData, parent, o);
            }
            return;
        }
        Object owner = parent;
        if (parent instanceof MapEntry) {
            MapEntry mapEntry;
            if (trace) {
                log.trace((Object)("setParent " + qName + " mapEntry"));
            }
            if ((owner = (mapEntry = (MapEntry)parent).getValue()) == null) {
                Class<?> valueCls;
                if (parentTerm == null) {
                    throw new JBossXBRuntimeException("Binding metadata needed for lazy map entry value instantiation is not available for parent element of element " + qName);
                }
                MapEntryMetaData mapEntryMetaData = RtElementHandler.getMapEntryMetaData(parentTerm, qName);
                String valueType = mapEntryMetaData.getValueType();
                if (valueType == null) {
                    throw new JBossXBRuntimeException("Element " + qName + " is supposed to be bound as map entry value with lazy value instantiation " + "but value type is not specified in its map entry metadata.");
                }
                try {
                    valueCls = Thread.currentThread().getContextClassLoader().loadClass(valueType);
                }
                catch (ClassNotFoundException e) {
                    throw new JBossXBRuntimeException("Failed to load value type specified in the map entry metadata: " + valueType);
                }
                try {
                    owner = valueCls.newInstance();
                }
                catch (Exception e) {
                    throw new JBossXBRuntimeException("Failed to create an instance of value type " + valueType + ": " + e.getMessage());
                }
                RtElementHandler.setMapEntryValue(mapEntryMetaData, parent, owner);
            }
        }
        if (term.getPutMethodMetaData() != null || term.getMapEntryMetaData() != null && owner instanceof Map) {
            if (trace) {
                log.trace((Object)("setParent " + qName + " mapPut"));
            }
            this.invokePut(qName, term, owner, o);
            return;
        }
        if (term.getAddMethodMetaData() != null) {
            if (trace) {
                log.trace((Object)("setParent " + qName + " add"));
            }
            this.invokeAdd(qName, term, owner, o);
            return;
        }
        PropertyMetaData propertyMetaData = null;
        if (parentTerm != null && !parentTerm.isModelGroup()) {
            ElementBinding parentElement = (ElementBinding)parentTerm;
            TypeBinding parentType = parentElement.getType();
            WildcardBinding wildcard = parentType.getWildcard();
            PropertyMetaData propertyMetaData2 = propertyMetaData = wildcard == null ? null : wildcard.getPropertyMetaData();
        }
        if (propertyMetaData == null) {
            propertyMetaData = term.getPropertyMetaData();
        }
        if (owner instanceof GenericValueContainer) {
            if (trace) {
                log.trace((Object)("setParent " + qName + " addChild"));
            }
            ((GenericValueContainer)owner).addChild(qName, o);
            return;
        }
        if (owner instanceof ValueList) {
            if (trace) {
                log.trace((Object)("setParent " + qName + " add"));
            }
            ValueList valueList = (ValueList)owner;
            ValueListInitializer initializer = valueList.getInitializer();
            if (particle.isRepeatable()) {
                Class<?> fieldType;
                String propName2;
                String string = propName2 = propertyMetaData == null ? null : propertyMetaData.getName();
                if (propName2 == null) {
                    propName2 = Util.xmlNameToFieldName(qName.getLocalPart(), term.getSchema().isIgnoreLowLine());
                }
                try {
                    fieldType = Classes.getAttributeGetter((Class)valueList.getTargetClass(), (String)propName2).getReturnType();
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    String msg = "Neither getter/setter nor field were found for field " + propName2 + " in " + valueList.getTargetClass();
                    if (!term.getSchema().isIgnoreUnresolvedFieldOrClass()) throw new JBossXBRuntimeException(msg);
                    log.warn((Object)msg);
                    return;
                }
                if (Collection.class.isAssignableFrom(fieldType)) {
                    void var15_31;
                    Collection collection = (Collection)initializer.getElementValue(qName, valueList);
                    if (collection == null) {
                        void var15_30;
                        if ((fieldType.getModifiers() & 0x600) == 0) {
                            try {
                                Collection collection2 = (Collection)fieldType.newInstance();
                            }
                            catch (Exception e) {
                                throw new JBossXBRuntimeException("Failed to create an instance of " + fieldType + " for element " + qName);
                            }
                        } else if (Set.class.isAssignableFrom(fieldType)) {
                            HashSet hashSet = new HashSet();
                        } else {
                            ArrayList arrayList = new ArrayList();
                        }
                        initializer.addElementValue(qName, (ElementBinding)term, valueList, var15_30);
                    }
                    var15_31.add(o);
                    return;
                } else {
                    void var15_35;
                    if (!fieldType.isArray()) throw new JBossXBRuntimeException("Failed to recognize collection type of " + fieldType + " for element " + qName);
                    Object object = initializer.getElementValue(qName, valueList);
                    int index = 0;
                    if (object == null) {
                        Object object2 = Array.newInstance(fieldType.getComponentType(), 1);
                    } else {
                        Object tmp = object;
                        index = Array.getLength(object);
                        Object object3 = Array.newInstance(fieldType.getComponentType(), index + 1);
                        System.arraycopy(tmp, 0, object3, 0, index);
                    }
                    Array.set(var15_35, index, o);
                    initializer.addElementValue(qName, (ElementBinding)term, valueList, var15_35);
                }
                return;
            }
            initializer.addElementValue(qName, (ElementBinding)term, valueList, o);
            return;
        }
        if (propertyMetaData != null) {
            propName = propertyMetaData.getName();
            if (propName == null) {
                propName = Util.xmlNameToFieldName(qName.getLocalPart(), term.getSchema().isIgnoreLowLine());
            }
            if (trace) {
                log.trace((Object)("setParent " + qName + " metadata set " + propName));
            }
            if (particle.isRepeatable()) {
                RtUtil.add(owner, o, propName, propertyMetaData.getCollectionType(), term.getSchema().isIgnoreUnresolvedFieldOrClass(), term.getValueAdapter());
                return;
            } else {
                RtUtil.set(owner, o, propName, propertyMetaData.getCollectionType(), term.getSchema().isIgnoreUnresolvedFieldOrClass(), term.getValueAdapter());
            }
            return;
        } else if (owner instanceof Collection) {
            if (trace) {
                log.trace((Object)("setParent " + qName + " collection.add()"));
            }
            ((Collection)owner).add(o);
            return;
        } else {
            propName = Util.xmlNameToFieldName(qName.getLocalPart(), term.getSchema().isIgnoreLowLine());
            if (trace) {
                log.trace((Object)("setParent " + qName + " no metadata set " + propName));
            }
            if (particle.isRepeatable()) {
                RtUtil.add(owner, o, propName, null, term.getSchema().isIgnoreUnresolvedFieldOrClass(), term.getValueAdapter());
                return;
            } else {
                RtUtil.set(owner, o, propName, null, term.getSchema().isIgnoreUnresolvedFieldOrClass(), term.getValueAdapter());
            }
        }
    }

    public Object endParticle(Object o, QName elementName, ParticleBinding particle) {
        TermBinding term = particle.getTerm();
        if (term.isSkip()) {
            return o;
        }
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)("endParticle " + elementName + " object=" + o + " term=" + term));
        }
        if (o instanceof GenericValueContainer) {
            try {
                if (trace) {
                    log.trace((Object)("endParticle " + elementName + " instantiate()"));
                }
                o = ((GenericValueContainer)o).instantiate();
            }
            catch (JBossXBRuntimeException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new JBossXBRuntimeException("Container failed to create an instance for " + elementName + ": " + e.getMessage(), e);
            }
        } else if (o instanceof ValueList) {
            if (trace) {
                log.trace((Object)("endParticle " + elementName + " valueList"));
            }
            ValueList valueList = (ValueList)o;
            o = valueList.getHandler().newInstance(valueList);
        }
        return o;
    }

    private Object startElement(Object parent, QName elementName, ParticleBinding particle) {
        TypeBinding type;
        TermBinding term = particle.getTerm();
        if (term.isSkip()) {
            return parent;
        }
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)("startElement " + elementName + " parent=" + parent + " term=" + term));
        }
        ClassMetaData classMetaData = term.getClassMetaData();
        MapEntryMetaData mapEntryMetaData = term.getMapEntryMetaData();
        if (!term.isModelGroup() && (!(type = ((ElementBinding)term).getType()).isStartElementCreatesObject() || classMetaData == null && mapEntryMetaData == null && Constants.QNAME_ANYTYPE.equals(type.getQName()))) {
            if (trace) {
                log.trace((Object)("startElement " + elementName + " does not create an object"));
            }
            return null;
        }
        ArrayList o = null;
        ElementBinding arrayItem = null;
        if (!term.isModelGroup()) {
            ParticleBinding typeParticle = ((ElementBinding)term).getType().getParticle();
            ModelGroupBinding modelGroup = (ModelGroupBinding)(typeParticle == null ? null : typeParticle.getTerm());
            ElementBinding elementBinding = arrayItem = modelGroup == null ? null : modelGroup.getArrayItem();
        }
        if (classMetaData == null && term.getAddMethodMetaData() == null && arrayItem != null) {
            if (parent == null) {
                Class itemCls = this.classForElement(arrayItem, parent == null ? null : parent.getClass());
                if (itemCls != null) {
                    if (trace) {
                        log.trace((Object)("startElement " + elementName + " new array " + itemCls.getName()));
                    }
                    o = GenericValueContainer.FACTORY.array(itemCls);
                }
            } else {
                Class<?> fieldType;
                String getterName;
                String propName;
                PropertyMetaData propertyMetaData = term.getPropertyMetaData();
                String string = propName = propertyMetaData == null ? null : propertyMetaData.getName();
                if (trace) {
                    log.trace((Object)("startElement " + elementName + " property=" + propName));
                }
                String string2 = getterName = propName == null ? Util.xmlNameToGetMethodName(elementName.getLocalPart(), term.getSchema().isIgnoreLowLine()) : "get" + Character.toUpperCase(propName.charAt(0)) + propName.substring(1);
                Class parentClass = parent instanceof GenericValueContainer ? ((GenericValueContainer)parent).getTargetClass() : (parent instanceof ValueList ? ((ValueList)parent).getTargetClass() : parent.getClass());
                if (parentClass.isArray()) {
                    fieldType = parentClass.getComponentType();
                } else {
                    try {
                        Method getter = parentClass.getMethod(getterName, null);
                        fieldType = getter.getReturnType();
                    }
                    catch (NoSuchMethodException e) {
                        String fieldName = null;
                        try {
                            fieldName = propName == null ? Util.xmlNameToFieldName(elementName.getLocalPart(), term.getSchema().isIgnoreLowLine()) : propName;
                            Field field = parentClass.getField(fieldName);
                            fieldType = field.getType();
                        }
                        catch (NoSuchFieldException e1) {
                            throw new JBossXBRuntimeException("Failed to find field " + fieldName + " and getter " + getterName + " for term " + elementName + " in " + parentClass);
                        }
                    }
                    if (particle.isRepeatable() && fieldType.isArray()) {
                        fieldType = fieldType.getComponentType();
                    }
                }
                if (fieldType.isArray()) {
                    o = GenericValueContainer.FACTORY.array(fieldType.getComponentType());
                } else if (Collection.class.isAssignableFrom(fieldType)) {
                    o = new ArrayList();
                }
            }
        } else if (mapEntryMetaData != null) {
            if (mapEntryMetaData.getImpl() != null) {
                Class cls = RtElementHandler.loadClassForTerm(mapEntryMetaData.getImpl(), term, elementName);
                if (trace) {
                    log.trace((Object)("startElement " + elementName + " new map entry " + cls.getName()));
                }
                o = RtElementHandler.newInstance(cls, elementName);
            } else {
                o = new MapEntry();
                if (trace) {
                    log.trace((Object)("startElement " + elementName + " new map entry"));
                }
            }
            if (mapEntryMetaData.isNonNullValue() && mapEntryMetaData.getValueType() != null) {
                Object value;
                Class<?> mapValueType;
                try {
                    mapValueType = Thread.currentThread().getContextClassLoader().loadClass(mapEntryMetaData.getValueType());
                }
                catch (ClassNotFoundException e) {
                    throw new JBossXBRuntimeException("startElement failed for " + elementName + ": failed to load class " + mapEntryMetaData.getValueType() + " for map entry value.");
                }
                try {
                    if (trace) {
                        log.trace((Object)("startElement " + elementName + " map value type " + mapEntryMetaData.getValueType()));
                    }
                    value = mapValueType.newInstance();
                }
                catch (Exception e) {
                    throw new JBossXBRuntimeException("startElement failed for " + elementName + ": failed to create an instance of " + mapValueType + " for map entry value.");
                }
                if (o instanceof MapEntry) {
                    ((MapEntry)((Object)o)).setValue(value);
                } else {
                    Method setValueMethod;
                    Method getValueMethod;
                    String setValueMethodName;
                    String getValueMethodName = mapEntryMetaData.getGetValueMethod();
                    if (getValueMethodName == null) {
                        getValueMethodName = "getValue";
                    }
                    if ((setValueMethodName = mapEntryMetaData.getSetValueMethod()) == null) {
                        setValueMethodName = "setValue";
                    }
                    try {
                        getValueMethod = o.getClass().getMethod(getValueMethodName, null);
                    }
                    catch (NoSuchMethodException e) {
                        throw new JBossXBRuntimeException("getValueMethod=" + getValueMethodName + " is not found in map entry " + o.getClass());
                    }
                    try {
                        setValueMethod = o.getClass().getMethod(setValueMethodName, getValueMethod.getReturnType());
                    }
                    catch (NoSuchMethodException e) {
                        throw new JBossXBRuntimeException("setValueMethod=" + setValueMethodName + "(" + getValueMethod.getReturnType().getName() + " value) is not found in map entry " + o.getClass());
                    }
                    try {
                        setValueMethod.invoke(o, value);
                    }
                    catch (Exception e) {
                        throw new JBossXBRuntimeException("setValueMethod=" + setValueMethodName + " failed: owner=" + o + ", value=" + value + ", msg=" + e.getMessage(), e);
                    }
                }
            }
        } else {
            Class cls;
            Class parentClass = null;
            if (parent != null) {
                parentClass = parent instanceof GenericValueContainer ? ((GenericValueContainer)parent).getTargetClass() : (parent instanceof ValueList ? ((ValueList)parent).getTargetClass() : parent.getClass());
            }
            if (term.isModelGroup()) {
                if (classMetaData == null) {
                    throw new JBossXBRuntimeException("Model groups should be annotated with 'class' annotation to be bound.");
                }
                cls = RtElementHandler.loadClassForTerm(classMetaData.getImpl(), term, elementName);
            } else {
                Class simpleCls;
                TypeBinding simpleType;
                ElementBinding element = (ElementBinding)term;
                cls = this.classForNonArrayItem(element, parentClass);
                if (cls != null && (simpleType = element.getType().getSimpleType()) != null && (cls.equals(simpleCls = RtElementHandler.classForSimpleType(simpleType, element.isNillable())) || cls.isPrimitive() && Classes.getPrimitiveWrapper((Class)cls) == simpleCls || simpleCls.isPrimitive() && Classes.getPrimitiveWrapper((Class)simpleCls) == cls)) {
                    cls = null;
                }
            }
            if (cls != null) {
                if (trace) {
                    log.trace((Object)("startElement " + elementName + " new " + cls.getName()));
                }
                o = RtElementHandler.newInstance(cls, elementName);
            }
        }
        return o;
    }

    private void attributes(Object o, QName elementName, ElementBinding element, Attributes attrs, NamespaceContext nsCtx) {
        TypeBinding type = element.getType();
        for (int i = 0; i < attrs.getLength(); ++i) {
            CharactersHandler simpleType;
            Object value;
            QName attrName = new QName(attrs.getURI(i), attrs.getLocalName(i));
            AttributeBinding binding = type.getAttribute(attrName);
            if (binding != null) {
                AttributeHandler handler = binding.getHandler();
                if (handler != null) {
                    value = handler.unmarshal(elementName, attrName, binding, nsCtx, attrs.getValue(i));
                    handler.attribute(elementName, attrName, binding, o, value);
                    continue;
                }
                throw new JBossXBRuntimeException("Attribute binding present but has no handler: element=" + elementName + ", attrinute=" + attrName);
            }
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(attrs.getURI(i)) || (simpleType = type.getCharactersHandler()) != null) continue;
            value = attrs.getValue(i);
            RtUtil.set(o, attrName, value, element.getSchema().isIgnoreLowLine());
        }
    }

    private Class classForElement(ElementBinding element, Class parentClass) {
        Class<?> cls;
        TypeBinding type = element.getType();
        QName typeQName = type.getQName();
        if (typeQName != null && "http://www.w3.org/2001/XMLSchema".equals(typeQName.getNamespaceURI())) {
            cls = SimpleTypeBindings.classForType(type.getQName().getLocalPart(), element.isNillable());
        } else {
            ElementBinding arrayItem = null;
            if (!type.isSimple()) {
                ParticleBinding typeParticle = type.getParticle();
                ModelGroupBinding modelGroup = (ModelGroupBinding)(typeParticle == null ? null : typeParticle.getTerm());
                ElementBinding elementBinding = arrayItem = modelGroup == null ? null : modelGroup.getArrayItem();
            }
            if (arrayItem != null) {
                cls = this.classForElement(arrayItem, parentClass);
                cls = Array.newInstance(cls, 0).getClass();
            } else {
                cls = this.classForNonArrayItem(element, parentClass);
            }
        }
        return cls;
    }

    private static void setMapEntryValue(MapEntryMetaData mapEntryMetaData, Object parent, Object o) {
        String setValueMethodName;
        String getValueMethodName = mapEntryMetaData.getGetValueMethod();
        if (getValueMethodName == null) {
            getValueMethodName = "getValue";
        }
        if ((setValueMethodName = mapEntryMetaData.getSetValueMethod()) == null) {
            setValueMethodName = "setValue";
        }
        Class<?> parentCls = parent.getClass();
        Method setValueMethod = RtElementHandler.getSetMethod(parentCls, getValueMethodName, setValueMethodName);
        RtElementHandler.invokeSetter(setValueMethod, parent, o, setValueMethodName);
    }

    private static void invokeSetter(Method setValueMethod, Object parent, Object o, String setValueMethodName) {
        try {
            setValueMethod.invoke(parent, o);
        }
        catch (Exception e) {
            throw new JBossXBRuntimeException("Failed to invoke " + setValueMethodName + " on " + parent + " with parameter " + o + ": " + e.getMessage());
        }
    }

    private static Method getSetMethod(Class cls, String getMethodName, String setMethodName) {
        Method setKeyMethod;
        Method getKeyMethod;
        try {
            getKeyMethod = cls.getMethod(getMethodName, null);
        }
        catch (NoSuchMethodException e) {
            throw new JBossXBRuntimeException("Method " + getMethodName + " not found in " + cls);
        }
        try {
            setKeyMethod = cls.getMethod(setMethodName, getKeyMethod.getReturnType());
        }
        catch (NoSuchMethodException e) {
            throw new JBossXBRuntimeException("Method " + setMethodName + "(" + getKeyMethod.getReturnType().getName() + " p) not found in " + cls);
        }
        return setKeyMethod;
    }

    private static MapEntryMetaData getMapEntryMetaData(TermBinding term, QName qName) {
        MapEntryMetaData mapEntryMetaData = term.getMapEntryMetaData();
        if (mapEntryMetaData == null) {
            String msg;
            if (term.isModelGroup()) {
                msg = "Term " + qName + " bound as map entry key or value but map entry metadata is not available for its parent term.";
            } else {
                ElementBinding element = (ElementBinding)term;
                msg = "Element " + qName + " bound as map entry key or value but map entry metadata is not available for its parent element nor its " + (element.getType().getQName() == null ? "annonymous" : element.getType().getQName().toString()) + " type.";
            }
            throw new JBossXBRuntimeException(msg);
        }
        return mapEntryMetaData;
    }

    private static Object newInstance(Class cls, QName elementName) {
        Object o;
        block5: {
            try {
                if (cls.isArray()) {
                    o = GenericValueContainer.FACTORY.array(cls.getComponentType());
                    break block5;
                }
                Constructor ctor = cls.getConstructor(null);
                try {
                    o = ctor.newInstance(null);
                }
                catch (Exception e) {
                    throw new JBossXBRuntimeException("Failed to create an instance of " + cls + " using default constructor for element " + elementName + ": " + e.getMessage(), e);
                }
            }
            catch (NoSuchMethodException e) {
                o = new ValueListInitializer().newValueList(ValueListHandler.IMMUTABLE, cls);
            }
        }
        return o;
    }

    private static Class getClass(ElementBinding element) {
        String localClassName;
        ClassMetaData clsMetaData = element.getClassMetaData();
        String string = localClassName = clsMetaData == null ? null : clsMetaData.getImpl();
        if (localClassName == null) {
            SchemaBinding schemaBinding;
            TypeBinding type = element.getType();
            QName typeBaseQName = type.getQName();
            if (typeBaseQName == null) {
                typeBaseQName = element.getQName();
            }
            PackageMetaData jaxbPackage = (schemaBinding = type.getSchemaBinding()) == null ? null : schemaBinding.getPackageMetaData();
            String pkg = jaxbPackage == null ? Util.xmlNamespaceToJavaPackage(typeBaseQName.getNamespaceURI()) : jaxbPackage.getName();
            localClassName = Util.xmlNameToClassName(typeBaseQName.getLocalPart(), element.getSchema().isIgnoreLowLine());
            if (pkg != null && pkg.length() > 0) {
                localClassName = pkg + '.' + localClassName;
            }
        }
        return RtElementHandler.loadClassForTerm(localClassName, element, element.getQName());
    }

    private static Class loadClassForTerm(String className, TermBinding term, QName elementName) {
        if (className == null) {
            throw new JBossXBRuntimeException("No class for " + elementName);
        }
        Class<?> cls = null;
        try {
            cls = Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            if (term.getSchema().isIgnoreUnresolvedFieldOrClass()) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Failed to resolve class for element " + elementName + ": " + className));
                }
            }
            throw new JBossXBRuntimeException("Failed to resolve class name for " + elementName + ": " + e.getMessage());
        }
        return cls;
    }

    private void invokeAdd(QName qName, TermBinding term, Object owner, Object o) {
        Method addMethod;
        Class valueType;
        AddMethodMetaData addMethodMetaData = term.getAddMethodMetaData();
        Class clazz = valueType = Object.class;
        if (addMethodMetaData.getValueType() != null) {
            try {
                valueType = Thread.currentThread().getContextClassLoader().loadClass(addMethodMetaData.getValueType());
            }
            catch (ClassNotFoundException e) {
                throw new JBossXBRuntimeException("Failed to load value type for addMethod.name=" + addMethodMetaData.getMethodName() + ", valueType=" + addMethodMetaData.getValueType() + ": " + e.getMessage(), e);
            }
        } else if (addMethodMetaData.isChildType()) {
            if (o == null) {
                throw new JBossXBRuntimeException("addMethod=" + addMethodMetaData.getMethodName() + " for element " + qName + " is configured with valueType='child'. The valueType cannot be determined because" + " the child is null");
            }
            valueType = o.getClass();
        }
        Class<?> ownerClass = owner.getClass();
        try {
            addMethod = ownerClass.getMethod(addMethodMetaData.getMethodName(), valueType);
        }
        catch (NoSuchMethodException e) {
            throw new JBossXBRuntimeException("Failed to find addMethod.name=" + addMethodMetaData.getMethodName() + ", addMethod.valueType=" + valueType.getName() + " in class " + ownerClass.getName() + ": " + e.getMessage(), e);
        }
        try {
            addMethod.invoke(owner, o);
        }
        catch (Exception e) {
            throw new JBossXBRuntimeException("setParent failed for " + qName + "=" + o + ": addMethod=" + addMethodMetaData.getMethodName() + " threw an exception for owner=" + owner + ", value=" + o + ": " + e.getMessage(), e);
        }
    }

    private void invokePut(QName qName, TermBinding term, Object owner, Object o) {
        Method putMethod;
        Object key;
        Method keyMethod;
        PutMethodMetaData putMethodMetaData = term.getPutMethodMetaData();
        MapEntryMetaData mapEntryMetaData = term.getMapEntryMetaData();
        if (mapEntryMetaData == null) {
            throw new JBossXBRuntimeException((putMethodMetaData == null ? "Parent object is an instance of java.util.Map" : "putMethod is specified for element " + qName) + " but mapEntry is specified for neither element " + qName + " nor it's type.");
        }
        Class<?> oClass = o.getClass();
        String getKeyMethodName = mapEntryMetaData.getGetKeyMethod();
        if (getKeyMethodName == null) {
            getKeyMethodName = "getKey";
        }
        try {
            keyMethod = oClass.getMethod(getKeyMethodName, null);
        }
        catch (NoSuchMethodException e) {
            throw new JBossXBRuntimeException("setParent failed for " + qName + "=" + o + ": getKeyMethod=" + getKeyMethodName + " not found in " + oClass);
        }
        try {
            key = keyMethod.invoke(o, null);
        }
        catch (Exception e) {
            throw new JBossXBRuntimeException("setParent failed for " + qName + "=" + o + ": getKeyMethod=" + getKeyMethodName + " threw an exception: " + e.getMessage(), e);
        }
        Class keyType = Object.class;
        Class valueType = Object.class;
        String putMethodName = "put";
        Class<?> ownerClass = owner.getClass();
        if (putMethodMetaData != null) {
            String name;
            if (putMethodMetaData.getKeyType() != null) {
                try {
                    keyType = Thread.currentThread().getContextClassLoader().loadClass(putMethodMetaData.getKeyType());
                }
                catch (ClassNotFoundException e) {
                    throw new JBossXBRuntimeException("setParent failed for " + qName + ": " + e.getMessage(), e);
                }
            }
            if (putMethodMetaData.getValueType() != null) {
                try {
                    valueType = Thread.currentThread().getContextClassLoader().loadClass(putMethodMetaData.getValueType());
                }
                catch (ClassNotFoundException e) {
                    throw new JBossXBRuntimeException("setParent failed for " + qName + ": " + e.getMessage(), e);
                }
            }
            if ((name = putMethodMetaData.getName()) != null) {
                putMethodName = name;
            }
        }
        try {
            putMethod = ownerClass.getMethod(putMethodName, keyType, valueType);
        }
        catch (NoSuchMethodException e) {
            throw new JBossXBRuntimeException("setParent failed for " + qName + "=" + o + ": putMethod=" + putMethodName + "(" + keyType.getName() + " key, " + valueType.getName() + " value) not found in " + ownerClass);
        }
        Object value = o;
        String valueMethodName = mapEntryMetaData.getGetValueMethod();
        if (valueMethodName != null) {
            Method valueMethod;
            try {
                valueMethod = oClass.getMethod(valueMethodName, null);
            }
            catch (NoSuchMethodException e) {
                throw new JBossXBRuntimeException("setParent failed for " + qName + "=" + o + ": getValueMethod=" + mapEntryMetaData.getGetValueMethod() + " not found in " + oClass);
            }
            try {
                value = valueMethod.invoke(o, null);
            }
            catch (Exception e) {
                throw new JBossXBRuntimeException("setParent failed for " + qName + "=" + o + ": getValueMethod=" + mapEntryMetaData.getGetValueMethod() + " threw an exception: " + e.getMessage(), e);
            }
        }
        if (o instanceof MapEntry) {
            value = ((MapEntry)o).getValue();
        }
        try {
            putMethod.invoke(owner, key, value);
        }
        catch (Exception e) {
            throw new JBossXBRuntimeException("setParent failed for " + qName + "=" + o + ": putMethod=" + putMethodName + " threw an exception for owner=" + owner + ", key=" + key + ", value=" + value + ": " + e.getMessage(), e);
        }
    }

    private Class classForNonArrayItem(ElementBinding element, Class parentClass) {
        MapEntryMetaData mapEntryMetaData;
        String clsName;
        ClassMetaData clsMetaData = element.getClassMetaData();
        String string = clsName = clsMetaData == null ? null : clsMetaData.getImpl();
        if (clsName == null && (mapEntryMetaData = element.getMapEntryMetaData()) != null && (clsName = mapEntryMetaData.getImpl()) == null) {
            clsName = MapEntry.class.getName();
        }
        if (clsName == null) {
            if (parentClass == null) {
                clsName = this.classFromQName(element);
            } else {
                String propName;
                PropertyMetaData propertyMetaData = element.getPropertyMetaData();
                String string2 = propName = propertyMetaData == null ? null : propertyMetaData.getName();
                if (propName == null && element.getAddMethodMetaData() == null && element.getPutMethodMetaData() == null) {
                    propName = Util.xmlNameToFieldName(element.getQName().getLocalPart(), element.getSchema().isIgnoreLowLine());
                }
                if (propName != null) {
                    Class<?> fieldType;
                    try {
                        fieldType = Classes.getAttributeGetter((Class)parentClass, (String)propName).getReturnType();
                    }
                    catch (NoSuchMethodException e) {
                        try {
                            fieldType = parentClass.getField(propName).getType();
                        }
                        catch (NoSuchFieldException e1) {
                            fieldType = null;
                        }
                    }
                    if (fieldType == null || Modifier.isAbstract(fieldType.getModifiers()) || Modifier.isInterface(fieldType.getModifiers()) || fieldType.isArray() || Collection.class.isAssignableFrom(fieldType)) {
                        clsName = this.classFromQName(element);
                    } else {
                        return fieldType;
                    }
                }
            }
        }
        return RtElementHandler.loadClassForTerm(clsName, element, element.getQName());
    }

    private String classFromQName(ElementBinding element) {
        String pkg;
        SchemaBinding schema;
        PackageMetaData pkgMetaData;
        QName typeBase = element.getType().getQName();
        if (typeBase == null) {
            typeBase = element.getQName();
        }
        String clsName = (pkgMetaData = (schema = element.getSchema()).getPackageMetaData()) == null ? Util.xmlNameToClassName(typeBase.getNamespaceURI(), typeBase.getLocalPart(), schema.isIgnoreLowLine()) : ((pkg = pkgMetaData.getName()) == null || pkg.length() == 0 ? Util.xmlNameToClassName(typeBase.getLocalPart(), schema.isIgnoreLowLine()) : pkg + "." + Util.xmlNameToClassName(typeBase.getLocalPart(), schema.isIgnoreLowLine()));
        return clsName;
    }

    private static boolean createInstance(Class cls) {
        return cls != null && !Classes.isPrimitive((Class)cls) && cls != String.class;
    }

    private static Class classForSimpleType(TypeBinding type, boolean nillable) {
        ValueMetaData valueMetaData = type.getValueMetaData();
        if (valueMetaData != null && valueMetaData.getUnmarshalMethod() != null) {
            return RtUtil.getUnmarshalMethod(type.getQName(), valueMetaData).getReturnType();
        }
        if (type.getClassMetaData() != null && type.getClassMetaData().getImpl() != null) {
            return RtUtil.loadClass(type.getClassMetaData().getImpl(), true);
        }
        TypeBinding itemType = type.getItemType();
        if (itemType != null) {
            if (type.getSchemaBinding().isUnmarshalListsToArrays()) {
                Class itemClass = RtElementHandler.classForSimpleType(itemType, nillable);
                return Array.newInstance(itemClass, 0).getClass();
            }
            return List.class;
        }
        QName qName = type.getQName();
        if (qName != null && "http://www.w3.org/2001/XMLSchema".equals(qName.getNamespaceURI())) {
            return SimpleTypeBindings.classForType(qName.getLocalPart(), nillable);
        }
        TypeBinding baseType = type.getBaseType();
        if (baseType == null) {
            throw new JBossXBRuntimeException("Expected a base type here.");
        }
        return RtElementHandler.classForSimpleType(baseType, nillable);
    }
}

