/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding.sunday.unmarshalling;

import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.util.xml.JBossEntityResolver;
import org.jboss.xb.binding.sunday.unmarshalling.LSInputAdaptor;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBindingInitializer;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBindingResolver;
import org.jboss.xb.binding.sunday.unmarshalling.XsdBinder;
import org.w3c.dom.ls.LSInput;
import org.xml.sax.InputSource;

public class DefaultSchemaResolver
implements SchemaBindingResolver {
    private static Logger log = Logger.getLogger((Class)DefaultSchemaResolver.class);
    private String baseURI;
    private JBossEntityResolver resolver;
    private boolean cacheResolvedSchemas = true;
    private Map schemasByUri = Collections.EMPTY_MAP;
    private Map schemaInitByUri = Collections.EMPTY_MAP;

    public DefaultSchemaResolver() {
        this(new JBossEntityResolver());
    }

    public DefaultSchemaResolver(JBossEntityResolver resolver) {
        this.resolver = resolver;
    }

    public boolean isCacheResolvedSchemas() {
        return this.cacheResolvedSchemas;
    }

    public void setCacheResolvedSchemas(boolean cacheResolvedSchemas) {
        this.cacheResolvedSchemas = cacheResolvedSchemas;
        if (!cacheResolvedSchemas) {
            this.schemasByUri = Collections.EMPTY_MAP;
        }
    }

    public void addSchemaLocation(String nsUri, String location) {
        this.resolver.registerLocalEntity(nsUri, location);
    }

    public void removeSchemaLocation(String nsUri) {
        this.resolver.registerLocalEntity(nsUri, null);
    }

    public void addSchemaInitializer(String nsUri, String sbiClassName) throws Exception {
        if (sbiClassName == null) {
            throw new IllegalArgumentException("Null class name");
        }
        Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(sbiClassName);
        Object object = clazz.newInstance();
        if (!(object instanceof SchemaBindingInitializer)) {
            throw new IllegalArgumentException(clazz.getName() + " is not an instance of " + SchemaBindingInitializer.class.getName());
        }
        SchemaBindingInitializer sbi = (SchemaBindingInitializer)object;
        this.addSchemaInitializer(nsUri, sbi);
    }

    public void addSchemaInitializer(String nsUri, SchemaBindingInitializer sbi) {
        if (nsUri == null) {
            throw new IllegalArgumentException("Null namespace uri");
        }
        if (sbi == null) {
            throw new IllegalArgumentException("Null schema binding initializer");
        }
        switch (this.schemaInitByUri.size()) {
            case 0: {
                this.schemaInitByUri = Collections.singletonMap(nsUri, sbi);
                break;
            }
            case 1: {
                this.schemaInitByUri = new HashMap(this.schemaInitByUri);
            }
            default: {
                this.schemaInitByUri.put(nsUri, sbi);
            }
        }
    }

    public SchemaBindingInitializer removeSchemaInitializer(String nsUri) {
        if (nsUri == null) {
            throw new IllegalArgumentException("Null namespace uri");
        }
        return (SchemaBindingInitializer)this.schemaInitByUri.remove(nsUri);
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public void setBaseURI(String baseURI) {
        this.baseURI = baseURI;
    }

    public SchemaBinding resolve(String nsURI, String baseURI, String schemaLocation) {
        SchemaBinding schema = (SchemaBinding)this.schemasByUri.get(nsURI);
        if (schema != null) {
            return schema;
        }
        InputSource is = this.getInputSource(nsURI, baseURI, schemaLocation);
        if (is != null) {
            if (baseURI == null) {
                baseURI = this.baseURI;
            }
            schema = XsdBinder.bind(is.getByteStream(), null, baseURI);
        }
        if (schema != null) {
            schema.setSchemaResolver(this);
            SchemaBindingInitializer sbi = (SchemaBindingInitializer)this.schemaInitByUri.get(nsURI);
            if (sbi != null) {
                schema = sbi.init(schema);
            }
            if (schema != null && this.cacheResolvedSchemas) {
                if (this.schemasByUri == Collections.EMPTY_MAP) {
                    this.schemasByUri = new HashMap();
                }
                this.schemasByUri.put(nsURI, schema);
            }
        }
        return schema;
    }

    public LSInput resolveAsLSInput(String nsURI, String baseURI, String schemaLocation) {
        LSInputAdaptor lsInput = null;
        InputSource is = this.getInputSource(nsURI, baseURI, schemaLocation);
        if (is != null) {
            String publicId = is.getPublicId();
            String systemId = is.getSystemId();
            lsInput = new LSInputAdaptor(publicId, systemId, baseURI);
            lsInput.setCharacterStream(is.getCharacterStream());
            lsInput.setByteStream(is.getByteStream());
            lsInput.setEncoding(is.getEncoding());
        }
        return lsInput;
    }

    private InputSource getInputSource(String nsURI, String baseURI, String schemaLocation) {
        InputSource is;
        boolean trace;
        block19: {
            block17: {
                trace = log.isTraceEnabled();
                is = null;
                if (trace) {
                    log.trace((Object)("getInputSource, nsURI=" + nsURI + ", baseURI=" + baseURI + ", schemaLocation=" + schemaLocation));
                }
                try {
                    is = this.resolver.resolveEntity(null, nsURI);
                }
                catch (Exception e) {
                    if (!trace) break block17;
                    log.trace((Object)"Failed to use nsUri as systemID", (Throwable)e);
                }
            }
            if (is == null && schemaLocation != null) {
                block18: {
                    try {
                        is = this.resolver.resolveEntity(null, schemaLocation);
                        if (trace && is != null) {
                            log.trace((Object)"Resolved schemaLocation as systemID");
                        }
                    }
                    catch (Exception e) {
                        if (!trace) break block18;
                        log.trace((Object)"Failed to use schemaLocation as systemID", (Throwable)e);
                    }
                }
                if (is == null) {
                    try {
                        if (baseURI == null) {
                            baseURI = this.baseURI;
                            if (trace) {
                                log.trace((Object)("Using resolver baseURI=" + baseURI));
                            }
                        }
                        URL schemaURL = null;
                        if (baseURI != null) {
                            URL baseURL = new URL(baseURI);
                            schemaURL = new URL(baseURL, schemaLocation);
                        } else {
                            schemaURL = new URL(schemaLocation);
                        }
                        if (schemaURL != null) {
                            InputStream is2 = schemaURL.openStream();
                            is = new InputSource(is2);
                            if (trace) {
                                log.trace((Object)("Using resolver schemaURL=" + schemaURL));
                            }
                        }
                    }
                    catch (Exception e) {
                        if (!trace) break block19;
                        log.trace((Object)"Failed to use schemaLocation as URL", (Throwable)e);
                    }
                }
            }
        }
        if (trace) {
            log.trace((Object)("getInputSource, nsURI=" + nsURI + ", baseURI=" + baseURI + ", schemaLocation=" + schemaLocation + ", is=" + is));
        }
        return is;
    }
}

