/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding.parser.sax;

import java.io.InputStream;
import java.io.Reader;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jboss.logging.Logger;
import org.jboss.util.xml.JBossEntityResolver;
import org.jboss.xb.binding.JBossXBException;
import org.jboss.xb.binding.JBossXBRuntimeException;
import org.jboss.xb.binding.parser.JBossXBParser;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class SaxJBossXBParser
implements JBossXBParser {
    private static final Logger log = Logger.getLogger((Class)SaxJBossXBParser.class);
    private final SAXParser parser;
    private JBossXBParser.ContentHandler contentHandler;

    public SaxJBossXBParser() throws JBossXBException {
        SAXParserFactory saxFactory = SAXParserFactory.newInstance();
        saxFactory.setValidating(true);
        saxFactory.setNamespaceAware(true);
        try {
            this.parser = saxFactory.newSAXParser();
        }
        catch (Exception e) {
            throw new JBossXBException("Failed to create a new SAX parser", e);
        }
        XMLReader reader = this.getXmlReader();
        reader.setContentHandler(new DelegatingContentHandler());
        reader.setErrorHandler(new MetaDataErrorHandler());
        reader.setEntityResolver((EntityResolver)new JBossEntityResolver());
    }

    public void setEntityResolver(EntityResolver entityResolver) throws JBossXBException {
        this.getXmlReader().setEntityResolver(entityResolver);
    }

    public void setProperty(String name, Object value) {
        try {
            this.getXmlReader().setProperty(name, value);
        }
        catch (SAXException e) {
            throw new JBossXBRuntimeException("Failed to set property on the XML reader", e);
        }
    }

    public void setFeature(String name, boolean value) {
        try {
            this.getXmlReader().setFeature(name, value);
        }
        catch (SAXException e) {
            throw new JBossXBRuntimeException("Failed to set feature on the XMLReader", e);
        }
    }

    public void parse(String systemId, JBossXBParser.ContentHandler handler) throws JBossXBException {
        this.contentHandler = handler;
        try {
            this.getXmlReader().parse(systemId);
        }
        catch (Exception e) {
            throw new JBossXBException("Failed to parse source: " + systemId, e);
        }
    }

    public void parse(InputStream is, JBossXBParser.ContentHandler handler) throws JBossXBException {
        this.contentHandler = handler;
        try {
            this.getXmlReader().parse(new InputSource(is));
        }
        catch (Exception e) {
            throw new JBossXBException("Failed to parse source", e);
        }
    }

    public void parse(Reader reader, JBossXBParser.ContentHandler handler) throws JBossXBException {
        this.contentHandler = handler;
        try {
            this.getXmlReader().parse(new InputSource(reader));
        }
        catch (Exception e) {
            throw new JBossXBException("Failed to parse source", e);
        }
    }

    private XMLReader getXmlReader() {
        try {
            return this.parser.getXMLReader();
        }
        catch (SAXException e) {
            throw new JBossXBRuntimeException("Failed to get parser's XMLReader", e);
        }
    }

    private static final class MetaDataErrorHandler
    implements ErrorHandler {
        private MetaDataErrorHandler() {
        }

        public void warning(SAXParseException exception) {
            log.warn((Object)this.formatMessage(exception));
        }

        public void error(SAXParseException exception) throws SAXException {
            throw new SAXException(this.formatMessage(exception));
        }

        public void fatalError(SAXParseException exception) throws SAXException {
            throw new SAXException(this.formatMessage(exception));
        }

        public String formatMessage(SAXParseException exception) {
            StringBuffer buffer = new StringBuffer(50);
            buffer.append(exception.getMessage()).append(" @ ");
            String location = exception.getPublicId();
            if (location != null) {
                buffer.append(location);
            } else {
                location = exception.getSystemId();
                if (location != null) {
                    buffer.append(location);
                } else {
                    buffer.append("*unknown*");
                }
            }
            buffer.append('[');
            buffer.append(exception.getLineNumber()).append(',');
            buffer.append(exception.getColumnNumber()).append(']');
            return buffer.toString();
        }
    }

    private final class DelegatingContentHandler
    implements ContentHandler {
        boolean trace = SaxJBossXBParser.access$200().isTraceEnabled();

        private DelegatingContentHandler() {
        }

        public void endDocument() {
        }

        public void startDocument() {
        }

        public void characters(char[] ch, int start, int length) {
            int i = start;
            while (i < start + length) {
                if (Character.isWhitespace(ch[i++])) continue;
                SaxJBossXBParser.this.contentHandler.characters(ch, start, length);
                break;
            }
        }

        public void ignorableWhitespace(char[] ch, int start, int length) {
        }

        public void endPrefixMapping(String prefix) {
            SaxJBossXBParser.this.contentHandler.endPrefixMapping(prefix);
        }

        public void skippedEntity(String name) {
        }

        public void setDocumentLocator(Locator locator) {
        }

        public void processingInstruction(String target, String data) {
            SaxJBossXBParser.this.contentHandler.processingInstruction(target, data);
        }

        public void startPrefixMapping(String prefix, String uri) {
            SaxJBossXBParser.this.contentHandler.startPrefixMapping(prefix, uri);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void endElement(String namespaceURI, String localName, String qName) {
            String name = null;
            if (this.trace) {
                name = localName.length() == 0 ? qName : namespaceURI + ':' + localName;
                log.trace((Object)("Enter endElement " + name));
            }
            try {
                SaxJBossXBParser.this.contentHandler.endElement(namespaceURI, localName, qName);
            }
            finally {
                if (this.trace) {
                    log.trace((Object)("Exit endElement  " + name));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
            String name = null;
            if (this.trace) {
                name = localName.length() == 0 ? qName : namespaceURI + ':' + localName;
                log.trace((Object)("Enter startElement " + name));
            }
            try {
                SaxJBossXBParser.this.contentHandler.startElement(namespaceURI, localName, qName, atts, null);
            }
            finally {
                if (this.trace) {
                    log.trace((Object)("Exit startElement  " + name));
                }
            }
        }
    }
}

