/*
 * Decompiled with CFR 0.152.
 */
package com.corejsf;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.application.ViewHandler;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

public class ResourcePhaseListener
implements PhaseListener {
    public static final String RESOURCE_PREFIX = "/resource";
    public static final String RESOURCE_LOCATION_PARAM = "r";
    public static final String CONTENT_TYPE_PARAM = "ct";
    public static final String DEFAULT_CONTENT_TYPE = "application/octet-stream";
    private Map<String, String> extensionToContentType = new HashMap<String, String>();

    public ResourcePhaseListener() {
        this.extensionToContentType.put(".js", "text/javascript");
        this.extensionToContentType.put(".gif", "image/gif");
        this.extensionToContentType.put(".jpg", "image/jpeg");
        this.extensionToContentType.put(".jpeg", "image/jpeg");
        this.extensionToContentType.put(".png", "image/png");
    }

    public PhaseId getPhaseId() {
        return PhaseId.RESTORE_VIEW;
    }

    public void beforePhase(PhaseEvent phaseEvent) {
    }

    public void afterPhase(PhaseEvent event) {
        if (event.getFacesContext().getViewRoot().getViewId().startsWith(RESOURCE_PREFIX)) {
            FacesContext context = event.getFacesContext();
            ExternalContext external = context.getExternalContext();
            String resourcePath = (String)external.getRequestParameterMap().get(RESOURCE_LOCATION_PARAM);
            if (resourcePath == null) {
                return;
            }
            String contentType = (String)external.getRequestParameterMap().get(CONTENT_TYPE_PARAM);
            if (contentType == null) {
                int extensionIndex = resourcePath.lastIndexOf(".");
                if (extensionIndex != -1) {
                    contentType = this.extensionToContentType.get(resourcePath.substring(extensionIndex));
                }
                if (contentType == null) {
                    contentType = DEFAULT_CONTENT_TYPE;
                }
            }
            InputStream in = this.getClass().getResourceAsStream(resourcePath);
            HttpServletResponse servletResponse = (HttpServletResponse)external.getResponse();
            try {
                int ch;
                ServletOutputStream out = servletResponse.getOutputStream();
                servletResponse.setContentType(contentType);
                while ((ch = in.read()) != -1) {
                    out.write(ch);
                }
            }
            catch (IOException ex) {
                throw new FacesException((Throwable)ex);
            }
            context.responseComplete();
        }
    }

    public static String getURL(FacesContext context, String resourcePath, String contentType) {
        ViewHandler handler = context.getApplication().getViewHandler();
        String url = handler.getActionURL(context, RESOURCE_PREFIX);
        StringBuilder r = new StringBuilder(url);
        r.append("?r=").append(resourcePath);
        if (contentType != null) {
            r.append(",ct=").append(contentType);
        }
        return r.toString();
    }
}

