/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.servlets;

import java.util.HashMap;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServlet;
import org.apache.tiles.DefinitionsFactory;
import org.apache.tiles.DefinitionsFactoryConfig;
import org.apache.tiles.DefinitionsFactoryException;
import org.apache.tiles.DefinitionsUtil;
import org.apache.tiles.TilesUtil;
import org.apache.tiles.TilesUtilImpl;

public class TilesServlet
extends HttpServlet {
    protected static Logger logger = Logger.getLogger((class$org$apache$tiles$servlets$TilesServlet == null ? (class$org$apache$tiles$servlets$TilesServlet = TilesServlet.class$("org.apache.tiles.servlets.TilesServlet")) : class$org$apache$tiles$servlets$TilesServlet).getName());
    private static final String DEFAULT_CONFIG_FILE_PARAM = "definitions-config";
    private static final String DEFAULT_CONFIG_FILE = "/WEB-INF/tiles.xml";
    private static final String CANT_POPULATE_FACTORY_ERROR = "CAN'T POPULATE TILES DEFINITION FACTORY";
    protected DefinitionsFactory definitionFactory = null;
    private String configFiles = null;
    static /* synthetic */ Class class$org$apache$tiles$servlets$TilesServlet;

    public void init(ServletConfig config) throws ServletException {
        logger.info("Initializing TilesServlet");
        this.configFiles = config.getInitParameter(DEFAULT_CONFIG_FILE_PARAM);
        try {
            DefinitionsFactoryConfig fconfig = this.readFactoryConfig();
            fconfig.setModuleAware(false);
            ServletContext context = config.getServletContext();
            TilesUtil.setTilesUtil(new TilesUtilImpl());
            this.initDefinitionsFactory(context, fconfig);
        }
        catch (Exception ex) {
            this.saveExceptionMessage(config, ex);
            throw new ServletException(ex.getMessage());
        }
    }

    protected DefinitionsFactoryConfig readFactoryConfig() throws ServletException {
        DefinitionsFactoryConfig factoryConfig = new DefinitionsFactoryConfig();
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            if (this.configFiles != null) {
                logger.info("CONFIG FILES DEFINED IN WEB.XML");
                map.put(DEFAULT_CONFIG_FILE_PARAM, this.configFiles);
            } else {
                logger.info("CONFIG FILES WERE NOT DEFINED IN WEB.XML, LOOKING FOR /WEB-INF/tiles.xml");
                map.put(DEFAULT_CONFIG_FILE_PARAM, DEFAULT_CONFIG_FILE);
            }
            factoryConfig.populate(map);
        }
        catch (Exception ex) {
            this.saveExceptionMessage(this.getServletConfig(), ex);
            throw new UnavailableException(CANT_POPULATE_FACTORY_ERROR + ex.getMessage());
        }
        return factoryConfig;
    }

    private void initDefinitionsFactory(ServletContext servletContext, DefinitionsFactoryConfig factoryConfig) throws ServletException {
        logger.info("initializing definitions factory...");
        try {
            this.definitionFactory = DefinitionsUtil.createDefinitionsFactory(servletContext, factoryConfig);
        }
        catch (DefinitionsFactoryException ex) {
            this.saveExceptionMessage(this.getServletConfig(), ex);
            throw new ServletException(ex.getMessage());
        }
    }

    private void saveExceptionMessage(ServletConfig config, Exception ex) {
        logger.warning("Caught exception when initializing definitions factory");
        logger.warning(ex.getMessage());
        logger.warning(ex.toString());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

