/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.util;

import javax.ejb.EJBContext;
import javax.naming.NamingException;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import org.jboss.logging.Logger;
import org.jboss.seam.util.NamingHelper;

public class Transactions {
    public static final String EJBCONTEXT_NAME = "java:comp/EJBContext";
    public static final String USER_TRANSACTION_NAME = "java:comp/UserTransaction";
    public static Logger log = Logger.getLogger(Transactions.class);

    public static boolean isTransactionActive() throws SystemException, NamingException {
        return Transactions.getUserTransaction().getStatus() == 0;
    }

    public static boolean isTransactionActiveOrMarkedRollback() throws SystemException, NamingException {
        int status = Transactions.getUserTransaction().getStatus();
        return status == 0 || status == 1;
    }

    public static UserTransaction getUserTransaction() throws NamingException {
        return (UserTransaction)NamingHelper.getInitialContext().lookup(USER_TRANSACTION_NAME);
    }

    public static EJBContext getEJBContext() throws NamingException {
        return (EJBContext)NamingHelper.getInitialContext().lookup(EJBCONTEXT_NAME);
    }

    private Transactions() {
    }

    public static void setUserTransactionRollbackOnly() throws SystemException, NamingException {
        UserTransaction userTransaction = Transactions.getUserTransaction();
        if (userTransaction.getStatus() != 6) {
            userTransaction.setRollbackOnly();
        }
    }
}

