/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.jsf;

import java.io.IOException;
import java.util.Map;
import javax.faces.application.Application;
import javax.faces.application.NavigationHandler;
import javax.faces.application.StateManager;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.el.VariableResolver;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import org.jboss.logging.Logger;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.contexts.Lifecycle;
import org.jboss.seam.contexts.Session;
import org.jboss.seam.core.Init;
import org.jboss.seam.core.Manager;
import org.jboss.seam.core.Pageflow;
import org.jboss.seam.jsf.SeamNavigationHandler;
import org.jboss.seam.jsf.SeamVariableResolver;

public class SeamPhaseListener
implements PhaseListener {
    private static Logger log = Logger.getLogger(SeamPhaseListener.class);
    private boolean firstRequest = true;

    private void setupCustomThingys(FacesContext facesContext) {
        if (this.firstRequest) {
            Application app = facesContext.getApplication();
            StateManagerInterceptor stateManager = new StateManagerInterceptor(app.getStateManager());
            app.setStateManager((StateManager)stateManager);
            SeamNavigationHandler navHandler = new SeamNavigationHandler(app.getNavigationHandler());
            app.setNavigationHandler((NavigationHandler)navHandler);
            SeamVariableResolver varResolver = new SeamVariableResolver(app.getVariableResolver());
            app.setVariableResolver((VariableResolver)varResolver);
            this.firstRequest = false;
        }
    }

    public PhaseId getPhaseId() {
        return PhaseId.ANY_PHASE;
    }

    public void beforePhase(PhaseEvent event) {
        this.setupCustomThingys(event.getFacesContext());
        log.trace((Object)("before phase: " + event.getPhaseId()));
        Lifecycle.setPhaseId(event.getPhaseId());
        if (event.getPhaseId() == PhaseId.RESTORE_VIEW) {
            Lifecycle.beginRequest(event.getFacesContext().getExternalContext());
        } else if (event.getPhaseId() == PhaseId.RENDER_RESPONSE) {
            Manager.instance().prepareBackswitch(event);
        }
    }

    public void afterPhase(PhaseEvent event) {
        log.trace((Object)("after phase: " + event.getPhaseId()));
        if (event.getPhaseId() == PhaseId.RESTORE_VIEW) {
            SeamPhaseListener.restoreAnyConversationContext(event);
        } else if (event.getPhaseId() == PhaseId.RENDER_RESPONSE) {
            if (!Init.instance().isClientSideConversations()) {
                Manager.instance().conversationTimeout(event.getFacesContext().getExternalContext());
            }
            Lifecycle.endRequest(event.getFacesContext().getExternalContext());
        } else if (event.getFacesContext().getResponseComplete()) {
            this.beforeSaveState(event.getFacesContext());
            Lifecycle.endRequest(event.getFacesContext().getExternalContext());
        }
        Lifecycle.setPhaseId(null);
    }

    private void beforeSaveState(FacesContext ctx) {
        log.debug((Object)"Before saving state");
        SeamPhaseListener.storeAnyConversationContext(ctx);
    }

    private static void restoreAnyConversationContext(PhaseEvent event) {
        Map attributes = SeamPhaseListener.getAttributes(event.getFacesContext());
        ExternalContext externalContext = event.getFacesContext().getExternalContext();
        Manager.instance().restoreConversation(attributes, SeamPhaseListener.getParameters(event));
        Lifecycle.resumePage();
        Lifecycle.resumeConversation(externalContext);
        if (Init.instance().isJbpmInstalled()) {
            Pageflow.instance().validatePageflow(attributes);
        }
        log.debug((Object)("After restore view, conversation context: " + Contexts.getConversationContext()));
    }

    private static void storeAnyConversationContext(FacesContext ctx) {
        Lifecycle.flushClientConversation();
        Lifecycle.flushPage();
        if (!Contexts.isConversationContextActive()) {
            log.debug((Object)"No active conversation context");
        } else {
            Session session = Session.getSession(ctx.getExternalContext(), true);
            Manager.instance().storeConversation(SeamPhaseListener.getAttributes(ctx), session);
        }
    }

    private static Map getParameters(PhaseEvent event) {
        return event.getFacesContext().getExternalContext().getRequestParameterMap();
    }

    private static Map getAttributes(FacesContext facesContext) {
        return facesContext.getViewRoot().getAttributes();
    }

    private final class StateManagerInterceptor
    extends StateManager {
        private final StateManager stateManager;

        private StateManagerInterceptor(StateManager sm) {
            this.stateManager = sm;
        }

        protected Object getComponentStateToSave(FacesContext ctx) {
            throw new UnsupportedOperationException();
        }

        protected Object getTreeStructureToSave(FacesContext ctx) {
            throw new UnsupportedOperationException();
        }

        protected void restoreComponentState(FacesContext ctx, UIViewRoot viewRoot, String str) {
            throw new UnsupportedOperationException();
        }

        protected UIViewRoot restoreTreeStructure(FacesContext ctx, String str1, String str2) {
            throw new UnsupportedOperationException();
        }

        public UIViewRoot restoreView(FacesContext ctx, String str1, String str2) {
            return this.stateManager.restoreView(ctx, str1, str2);
        }

        public StateManager.SerializedView saveSerializedView(FacesContext ctx) {
            SeamPhaseListener.this.beforeSaveState(ctx);
            return this.stateManager.saveSerializedView(ctx);
        }

        public void writeState(FacesContext ctx, StateManager.SerializedView sv) throws IOException {
            this.stateManager.writeState(ctx, sv);
        }

        public boolean isSavingStateInClient(FacesContext ctx) {
            return this.stateManager.isSavingStateInClient(ctx);
        }
    }
}

