/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.interceptors;

import java.lang.reflect.Method;
import java.rmi.RemoteException;
import javax.ejb.ApplicationException;
import javax.ejb.AroundInvoke;
import javax.ejb.InvocationContext;
import javax.ejb.Remove;
import org.jboss.logging.Logger;
import org.jboss.seam.ComponentType;
import org.jboss.seam.annotations.Around;
import org.jboss.seam.interceptors.AbstractInterceptor;
import org.jboss.seam.interceptors.BijectionInterceptor;
import org.jboss.seam.interceptors.ConversationInterceptor;
import org.jboss.seam.interceptors.ValidationInterceptor;

@Around(value={ValidationInterceptor.class, BijectionInterceptor.class, ConversationInterceptor.class})
public class RemoveInterceptor
extends AbstractInterceptor {
    private static final Logger log = Logger.getLogger(RemoveInterceptor.class);

    @AroundInvoke
    public Object removeIfNecessary(InvocationContext invocation) throws Exception {
        Object result;
        try {
            result = invocation.proceed();
        }
        catch (Exception exception) {
            this.removeIfNecessary(invocation.getMethod(), exception);
            throw exception;
        }
        this.removeIfNecessary(invocation.getMethod());
        return result;
    }

    private void removeIfNecessary(Method method, Exception exception) {
        if (exception instanceof RuntimeException || exception instanceof RemoteException) {
            if (!exception.getClass().isAnnotationPresent(ApplicationException.class) && this.component.getType() == ComponentType.STATEFUL_SESSION_BEAN) {
                this.remove();
            }
        } else if (method.isAnnotationPresent(Remove.class) && !method.getAnnotation(Remove.class).retainIfException()) {
            this.remove();
        }
    }

    private void removeIfNecessary(Method method) {
        if (method.isAnnotationPresent(Remove.class)) {
            this.remove();
        }
    }

    private void remove() {
        this.component.getScope().getContext().remove(this.component.getName());
        log.debug((Object)("Stateful component was removed: " + this.component.getName()));
    }
}

